/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;

class ArrayFieldVariable
extends AbstractVariable
implements Field {
    private final ArrayReference array;
    private int index;
    private int maxIndexLog;
    private String declaredType;
    private static final String ZEROS = "            ";

    ArrayFieldVariable(JPDADebuggerImpl debugger, Value value, String declaredType, ArrayReference array, int index, int maxIndex, String parentID) {
        super(debugger, value, parentID + '.' + index + (value instanceof ObjectReference ? "^" : ""));
        this.index = index;
        this.maxIndexLog = ArrayFieldVariable.log10(maxIndex);
        this.declaredType = declaredType;
        this.array = array;
    }

    public String getName() {
        int num0 = this.maxIndexLog - ArrayFieldVariable.log10(this.index);
        if (num0 > 0) {
            return "[" + ArrayFieldVariable.zeros(num0) + this.index + "]";
        }
        return "[" + this.index + "]";
    }

    static int log10(int n) {
        int l = 1;
        while ((n /= 10) > 0) {
            ++l;
        }
        return l;
    }

    static String zeros(int n) {
        if (n < ZEROS.length()) {
            return ZEROS.substring(0, n);
        }
        String z = ZEROS;
        while (z.length() < n) {
            z = z + " ";
        }
        return z;
    }

    public String getClassName() {
        return this.getType();
    }

    public boolean isStatic() {
        return false;
    }

    public String getDeclaredType() {
        return this.declaredType;
    }

    protected void setValue(Value value) throws InvalidExpressionException {
        try {
            this.array.setValue(this.index, value);
        }
        catch (InvalidTypeException ex) {
            throw new InvalidExpressionException((Throwable)ex);
        }
        catch (ClassNotLoadedException ex) {
            throw new InvalidExpressionException((Throwable)ex);
        }
    }

    public String toString() {
        return "FieldVariable " + this.getName();
    }
}

