/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.xml.xdm.XDMModel;
import org.netbeans.modules.xml.xdm.nodes.Document;

class XDMModelUndoableEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = -4513245871320808368L;
    private Document oldDocument;
    private Document newDocument;
    private XDMModel model;

    public XDMModelUndoableEdit(Document oldDoc, Document newDoc, XDMModel model) {
        this.oldDocument = oldDoc;
        this.newDocument = newDoc;
        this.model = model;
    }

    public void redo() throws CannotRedoException {
        super.redo();
        try {
            this.model.resetDocument(this.newDocument);
        }
        catch (RuntimeException ex) {
            if (this.newDocument != this.model.getCurrentDocument()) {
                CannotRedoException e = new CannotRedoException();
                e.initCause(ex);
                throw e;
            }
            throw ex;
        }
    }

    public void undo() throws CannotUndoException {
        super.undo();
        try {
            this.model.resetDocument(this.oldDocument);
        }
        catch (RuntimeException ex) {
            if (this.oldDocument != this.model.getCurrentDocument()) {
                CannotUndoException e = new CannotUndoException();
                e.initCause(ex);
                throw e;
            }
            throw ex;
        }
    }

    public boolean addEdit(UndoableEdit anEdit) {
        if (anEdit instanceof XDMModelUndoableEdit) {
            XDMModelUndoableEdit theEdit = (XDMModelUndoableEdit)anEdit;
            if (this.newDocument == theEdit.oldDocument) {
                this.newDocument = theEdit.newDocument;
                return true;
            }
        }
        return false;
    }
}

