/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.cluster.ClusterMessage;
import org.apache.catalina.cluster.ClusterSender;
import org.apache.catalina.cluster.Member;
import org.apache.catalina.cluster.tcp.ClusterData;
import org.apache.catalina.cluster.tcp.IDataSender;
import org.apache.catalina.cluster.tcp.IDataSenderFactory;
import org.apache.catalina.cluster.tcp.SimpleTcpCluster;
import org.apache.catalina.cluster.util.IDynamicProperty;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;

public class ReplicationTransmitter
implements ClusterSender,
IDynamicProperty {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$ReplicationTransmitter == null ? (class$org$apache$catalina$cluster$tcp$ReplicationTransmitter = ReplicationTransmitter.class$("org.apache.catalina.cluster.tcp.ReplicationTransmitter")) : class$org$apache$catalina$cluster$tcp$ReplicationTransmitter));
    private static final String info = "ReplicationTransmitter/3.0";
    protected StringManager sm = StringManager.getManager((String)"org.apache.catalina.cluster.tcp");
    private Map map = new HashMap();
    private long nrOfRequests = 0L;
    private long totalBytes = 0L;
    private long failureCounter = 0L;
    private int count = 0;
    protected int processSenderFrequency = 2;
    private String replicationMode;
    private long ackTimeout = 15000L;
    private boolean waitForAck = true;
    private boolean autoConnect = false;
    private boolean compress = false;
    protected boolean doTransmitterProcessingStats = false;
    protected long processingTime = 0L;
    protected long minProcessingTime = Long.MAX_VALUE;
    protected long maxProcessingTime = 0L;
    private Map properties = new HashMap();
    private SimpleTcpCluster cluster;
    private ObjectName objectName;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$ReplicationTransmitter;

    public String getInfo() {
        return info;
    }

    public long getNrOfRequests() {
        return this.nrOfRequests;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getFailureCounter() {
        return this.failureCounter;
    }

    public String getReplicationMode() {
        return this.replicationMode;
    }

    public void setReplicationMode(String mode) {
        String msg = IDataSenderFactory.validateMode(mode);
        if (msg == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting replication mode to " + mode));
            }
        } else {
            throw new IllegalArgumentException(msg);
        }
        this.replicationMode = mode;
    }

    public double getAvgProcessingTime() {
        return (double)this.processingTime / (double)this.nrOfRequests;
    }

    public long getMaxProcessingTime() {
        return this.maxProcessingTime;
    }

    public long getMinProcessingTime() {
        return this.minProcessingTime;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public boolean isDoTransmitterProcessingStats() {
        return this.doTransmitterProcessingStats;
    }

    public void setDoTransmitterProcessingStats(boolean doProcessingStats) {
        this.doTransmitterProcessingStats = doProcessingStats;
    }

    public void setObjectName(ObjectName name) {
        this.objectName = name;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compressMessageData) {
        this.compress = compressMessageData;
    }

    public boolean isAutoConnect() {
        return this.autoConnect;
    }

    public void setAutoConnect(boolean autoConnect) {
        this.autoConnect = autoConnect;
        this.setProperty("autoConnect", String.valueOf(autoConnect));
    }

    public long getAckTimeout() {
        return this.ackTimeout;
    }

    public void setAckTimeout(long ackTimeout) {
        this.ackTimeout = ackTimeout;
        this.setProperty("ackTimeout", String.valueOf(ackTimeout));
    }

    public boolean isWaitForAck() {
        return this.waitForAck;
    }

    public void setWaitForAck(boolean waitForAck) {
        this.waitForAck = waitForAck;
        this.setProperty("waitForAck", String.valueOf(waitForAck));
    }

    public int getProcessSenderFrequency() {
        return this.processSenderFrequency;
    }

    public void setProcessSenderFrequency(int processSenderFrequency) {
        this.processSenderFrequency = processSenderFrequency;
    }

    public void setCatalinaCluster(SimpleTcpCluster cluster) {
        this.cluster = cluster;
    }

    public boolean getIsSenderSynchronized() {
        return "synchronous".equals(this.replicationMode) || "pooled".equals(this.replicationMode);
    }

    public void setProperty(String name, Object value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)this.sm.getString("ReplicationTransmitter.setProperty", (Object)name, value, this.properties.get(name)));
        }
        this.properties.put(name, value);
    }

    public Object getProperty(String key) {
        if (log.isTraceEnabled()) {
            log.trace((Object)this.sm.getString("ReplicationTransmitter.getProperty", (Object)key));
        }
        return this.properties.get(key);
    }

    public Iterator getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(ClusterMessage message, Member member) throws IOException {
        long time = 0L;
        if (this.doTransmitterProcessingStats) {
            time = System.currentTimeMillis();
        }
        try {
            ClusterData data = this.serialize(message);
            String key = this.getKey(member);
            IDataSender sender = (IDataSender)this.map.get(key);
            this.sendMessageData(data, sender);
        }
        finally {
            if (this.doTransmitterProcessingStats) {
                this.addProcessingStats(time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageClusterDomain(ClusterMessage message) throws IOException {
        long time = 0L;
        if (this.doTransmitterProcessingStats) {
            time = System.currentTimeMillis();
        }
        try {
            String domain = message.getAddress().getDomain();
            if (domain == null) {
                throw new RuntimeException("Domain at member not set");
            }
            ClusterData data = this.serialize(message);
            IDataSender[] senders = this.getSenders();
            for (int i = 0; i < senders.length; ++i) {
                IDataSender sender = senders[i];
                if (!domain.equals(sender.getDomain())) continue;
                try {
                    boolean success = this.sendMessageData(data, sender);
                    continue;
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
        }
        finally {
            if (this.doTransmitterProcessingStats) {
                this.addProcessingStats(time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(ClusterMessage message) throws IOException {
        long time = 0L;
        if (this.doTransmitterProcessingStats) {
            time = System.currentTimeMillis();
        }
        try {
            ClusterData data = this.serialize(message);
            IDataSender[] senders = this.getSenders();
            for (int i = 0; i < senders.length; ++i) {
                IDataSender sender = senders[i];
                try {
                    this.sendMessageData(data, sender);
                    continue;
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
        }
        finally {
            if (this.doTransmitterProcessingStats) {
                this.addProcessingStats(time);
            }
        }
    }

    public void start() throws IOException {
        if (this.cluster != null) {
            ObjectName clusterName = this.cluster.getObjectName();
            ObjectName transmitterName = null;
            try {
                MBeanServer mserver = this.cluster.getMBeanServer();
                Container container = this.cluster.getContainer();
                String name = clusterName.getDomain() + ":type=ClusterSender";
                if (container instanceof StandardHost) {
                    name = name + ",host=" + clusterName.getKeyProperty("host");
                }
                if (mserver.isRegistered(transmitterName = new ObjectName(name))) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)this.sm.getString("cluster.mbean.register.already", (Object)transmitterName));
                    }
                    return;
                }
                this.setObjectName(transmitterName);
                mserver.registerMBean(this.cluster.getManagedBean(this), this.getObjectName());
                if (log.isInfoEnabled()) {
                    log.info((Object)this.sm.getString("ReplicationTransmitter.started", (Object)clusterName, (Object)transmitterName));
                }
            }
            catch (Exception e) {
                log.warn((Object)e);
            }
        }
    }

    public synchronized void stop() {
        Iterator i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            IDataSender sender = (IDataSender)i.next().getValue();
            try {
                this.unregisterSenderMBean(sender);
                sender.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            i.remove();
        }
        if (this.cluster != null && this.getObjectName() != null) {
            try {
                MBeanServer mserver = this.cluster.getMBeanServer();
                mserver.unregisterMBean(this.getObjectName());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)this.sm.getString("ReplicationTransmitter.stopped", (Object)this.cluster.getObjectName(), (Object)this.getObjectName()));
            }
        }
    }

    public void backgroundProcess() {
        this.count = (this.count + 1) % this.processSenderFrequency;
        if (this.count == 0) {
            this.checkKeepAlive();
        }
    }

    public void checkKeepAlive() {
        if (this.map.size() > 0) {
            Iterator iter = this.map.entrySet().iterator();
            while (iter.hasNext()) {
                IDataSender sender = (IDataSender)iter.next().getValue();
                if (sender == null) continue;
                sender.checkKeepAlive();
            }
        }
    }

    public IDataSender[] getSenders() {
        Iterator iter = this.map.entrySet().iterator();
        IDataSender[] array = new IDataSender[this.map.size()];
        int i = 0;
        while (iter.hasNext()) {
            IDataSender sender = (IDataSender)iter.next().getValue();
            if (sender != null) {
                array[i] = sender;
            }
            ++i;
        }
        return array;
    }

    public ObjectName[] getSenderObjectNames() {
        Iterator iter = this.map.entrySet().iterator();
        ObjectName[] array = new ObjectName[this.map.size()];
        int i = 0;
        while (iter.hasNext()) {
            IDataSender sender = (IDataSender)iter.next().getValue();
            if (sender != null) {
                array[i] = this.getSenderObjectName(sender);
            }
            ++i;
        }
        return array;
    }

    public synchronized void resetStatistics() {
        this.nrOfRequests = 0L;
        this.totalBytes = 0L;
        this.failureCounter = 0L;
        this.processingTime = 0L;
        this.minProcessingTime = Long.MAX_VALUE;
        this.maxProcessingTime = 0L;
    }

    public synchronized void add(Member member) {
        try {
            String key = this.getKey(member);
            if (!this.map.containsKey(key)) {
                IDataSender sender = IDataSenderFactory.getIDataSender(this.replicationMode, member);
                this.transferSenderProperty(sender);
                this.map.put(key, sender);
                this.registerSenderMBean(member, sender);
            }
        }
        catch (IOException x) {
            log.error((Object)"Unable to create and add a IDataSender object.", (Throwable)x);
        }
    }

    public synchronized void remove(Member member) {
        String key = this.getKey(member);
        IDataSender toberemoved = (IDataSender)this.map.get(key);
        if (toberemoved == null) {
            return;
        }
        this.unregisterSenderMBean(toberemoved);
        toberemoved.disconnect();
        this.map.remove(key);
    }

    protected synchronized void addStats(int length) {
        ++this.nrOfRequests;
        this.totalBytes += (long)length;
        if (log.isDebugEnabled() && this.nrOfRequests % 100L == 0L) {
            log.debug((Object)("Nr of bytes sent=" + this.totalBytes + " over " + this.nrOfRequests + "; avg=" + this.totalBytes / this.nrOfRequests + " bytes/request; failures=" + this.failureCounter));
        }
    }

    protected void transferSenderProperty(IDataSender sender) {
        Iterator iter = this.getPropertyNames();
        while (iter.hasNext()) {
            String pkey = (String)iter.next();
            Object value = this.getProperty(pkey);
            IntrospectionUtils.setProperty((Object)sender, (String)pkey, (String)value.toString());
        }
    }

    protected String getKey(Member member) {
        return member.getHost() + ":" + member.getPort();
    }

    protected void unregisterSenderMBean(IDataSender sender) {
        try {
            MBeanServer mserver = this.cluster.getMBeanServer();
            if (mserver != null) {
                mserver.unregisterMBean(this.getSenderObjectName(sender));
            }
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void registerSenderMBean(Member member, IDataSender sender) {
        if (member != null && this.cluster != null) {
            try {
                MBeanServer mserver = this.cluster.getMBeanServer();
                ObjectName senderName = this.getSenderObjectName(sender);
                if (mserver.isRegistered(senderName)) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)this.sm.getString("cluster.mbean.register.already", (Object)senderName));
                    }
                    return;
                }
                mserver.registerMBean(this.cluster.getManagedBean(sender), senderName);
            }
            catch (Exception e) {
                log.warn((Object)e);
            }
        }
    }

    protected ObjectName getSenderObjectName(IDataSender sender) {
        ObjectName senderName = null;
        try {
            ObjectName clusterName = this.cluster.getObjectName();
            Container container = this.cluster.getContainer();
            String name = clusterName.getDomain() + ":type=IDataSender";
            if (container instanceof StandardHost) {
                name = name + ",host=" + clusterName.getKeyProperty("host");
            }
            senderName = new ObjectName(name + ",senderAddress=" + sender.getAddress().getHostAddress() + ",senderPort=" + sender.getPort());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        return senderName;
    }

    protected ClusterData serialize(ClusterMessage msg) throws IOException {
        ObjectOutputStream out;
        msg.setTimestamp(System.currentTimeMillis());
        ByteArrayOutputStream outs = new ByteArrayOutputStream();
        GZIPOutputStream gout = null;
        ClusterData data = new ClusterData();
        data.setType(msg.getClass().getName());
        data.setUniqueId(msg.getUniqueId());
        data.setTimestamp(msg.getTimestamp());
        data.setCompress(msg.getCompress());
        data.setResend(msg.getResend());
        if (this.isCompress() && msg.getCompress() != 0 || msg.getCompress() == 1) {
            gout = new GZIPOutputStream(outs);
            out = new ObjectOutputStream(gout);
        } else {
            out = new ObjectOutputStream(outs);
        }
        out.writeObject(msg);
        if (gout != null) {
            gout.flush();
            gout.close();
        }
        data.setMessage(outs.toByteArray());
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sendMessageData(ClusterData data, IDataSender sender) throws IOException {
        if (sender == null) {
            throw new IOException("Sender not available. Make sure sender information is available to the ReplicationTransmitter.");
        }
        try {
            if (this.autoConnect) {
                IDataSender iDataSender = sender;
                synchronized (iDataSender) {
                    if (!sender.isConnected()) {
                        sender.connect();
                    }
                }
            }
            sender.sendMessage(data);
            sender.setSuspect(false);
            this.addStats(data.getMessage().length);
            return true;
        }
        catch (Exception x) {
            if (!sender.getSuspect()) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Unable to send replicated message, is member [" + sender.toString() + "] down?"), (Throwable)x);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to send replicated message, is member [" + sender.toString() + "] down?"), (Throwable)x);
            }
            sender.setSuspect(true);
            ++this.failureCounter;
            return false;
        }
    }

    protected void addProcessingStats(long startTime) {
        long time = System.currentTimeMillis() - startTime;
        if (time < this.minProcessingTime) {
            this.minProcessingTime = time;
        }
        if (time > this.maxProcessingTime) {
            this.maxProcessingTime = time;
        }
        this.processingTime += time;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

