/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Dimension;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.CompletionView;
import org.openide.util.NbBundle;

public class ListCompletionView
extends JList
implements CompletionView {
    ListCellRenderer renderer;
    ListCellRenderer defaultRenderer;

    public ListCompletionView() {
        this((ListCellRenderer)null);
    }

    public ListCompletionView(ListCellRenderer renderer) {
        this.setSelectionMode(0);
        this.renderer = renderer;
        this.defaultRenderer = this.getCellRenderer();
        ResourceBundle bundle = NbBundle.getBundle((Class)BaseKit.class);
        this.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_CompletionView"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CompletionView"));
    }

    public void setResult(CompletionQuery.Result result) {
        if (result != null) {
            this.setResult(result.getData());
        } else {
            this.setResult(Collections.EMPTY_LIST);
        }
    }

    public void setResult(List data) {
        if (data != null) {
            if (data.size() == 0) {
                this.setCellRenderer(this.defaultRenderer);
                data = new LinkedList();
                this.setModel(new Model(data));
                this.clearSelection();
            } else {
                if (this.renderer != null) {
                    this.setCellRenderer(this.renderer);
                }
                this.setModel(new Model(data));
                this.setSelectedIndex(0);
            }
        }
    }

    public void displayWaitStatus() {
        if (this.getCellRenderer() == this.defaultRenderer) {
            LinkedList<String> data = new LinkedList<String>();
            data.add(NbBundle.getBundle((Class)BaseKit.class).getString("please-wait"));
            this.setModel(new Model(data));
            this.clearSelection();
        }
    }

    public boolean showingData() {
        return this.getCellRenderer() == this.renderer;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public void up() {
        if (this.getModel().getSize() > 0) {
            this.setSelectedIndex(this.getSelectedIndex() - 1);
            this.ensureIndexIsVisible(this.getSelectedIndex());
        }
    }

    public void down() {
        int lastInd = this.getModel().getSize() - 1;
        if (lastInd >= 0) {
            this.setSelectedIndex(Math.min(this.getSelectedIndex() + 1, lastInd));
            this.ensureIndexIsVisible(this.getSelectedIndex());
        }
    }

    public void pageUp() {
        if (this.getModel().getSize() > 0) {
            int pageSize = Math.max(this.getLastVisibleIndex() - this.getFirstVisibleIndex(), 0);
            int ind = Math.max(this.getSelectedIndex() - pageSize, 0);
            this.setSelectedIndex(ind);
            this.ensureIndexIsVisible(ind);
        }
    }

    public void pageDown() {
        int lastInd = this.getModel().getSize() - 1;
        if (lastInd >= 0) {
            int pageSize = Math.max(this.getLastVisibleIndex() - this.getFirstVisibleIndex(), 0);
            int ind = Math.min(this.getSelectedIndex() + pageSize, lastInd);
            this.setSelectedIndex(ind);
            this.ensureIndexIsVisible(ind);
        }
    }

    public void begin() {
        if (this.getModel().getSize() > 0) {
            this.setSelectedIndex(0);
            this.ensureIndexIsVisible(0);
        }
    }

    public void end() {
        int lastInd = this.getModel().getSize() - 1;
        if (lastInd >= 0) {
            this.setSelectedIndex(lastInd);
            this.ensureIndexIsVisible(lastInd);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    static class Model
    extends AbstractListModel {
        List data;
        static final long serialVersionUID = 3292276783870598274L;

        public Model(List data) {
            this.data = data;
        }

        public int getSize() {
            return this.data.size();
        }

        public Object getElementAt(int index) {
            return index >= 0 && index < this.data.size() ? this.data.get(index) : null;
        }

        List getData() {
            return this.data;
        }
    }
}

