/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.CompletionView;
import org.netbeans.editor.ext.ExtCompletionPane;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.JavaDocPane;
import org.netbeans.editor.ext.JavaDocView;

public class JDCPopupPanel
extends JPanel
implements PropertyChangeListener,
SettingsChangeListener {
    private ExtCompletionPane completion;
    private ExtEditorUI extEditorUI;
    private FocusListener focusL;
    private List keyActionPairsList;
    private JavaDocPane javadoc;
    private int lastSize = -1;
    private static final int WINDOW_GAP = 1;
    private static final String POPUP_HIDE = "jdc-popup-hide";
    private static final String COMPLETION_UP = "completion-up";
    private static final String COMPLETION_DOWN = "completion-down";
    private static final String COMPLETION_PGUP = "completion-pgup";
    private static final String COMPLETION_PGDN = "completion-pgdn";
    private static final String COMPLETION_BEGIN = "completion-begin";
    private static final String COMPLETION_END = "completion-end";
    private static final String JAVADOC_UP = "javadoc-up";
    private static final String JAVADOC_DOWN = "javadoc-down";
    private static final String JAVADOC_PGUP = "javadoc-pgup";
    private static final String JAVADOC_PGDN = "javadoc-pgdn";
    private static final String JAVADOC_BEGIN = "javadoc-begin";
    private static final String JAVADOC_END = "javadoc-end";
    private static final String JAVADOC_LEFT = "javadoc-left";
    private static final String JAVADOC_RIGHT = "javadoc-right";
    private static final String JAVADOC_BACK = "javadoc-back";
    private static final String JAVADOC_FORWARD = "javadoc-forward";
    private static final String JAVADOC_OPEN_IN_BROWSER = "javadoc-open-in-browser";
    private static final String JAVADOC_OPEN_SOURCE = "javadoc-open-source";
    public static final String COMPLETION_SUBSTITUTE_TEXT = "completion-substitute-text";
    public static final String COMPLETION_SUBSTITUTE_TEXT_SIMPLE = "completion-substitute-text-simple";
    private static final String COMPLETION_SUBSTITUTE_TEXT_KEEP_POPUP_OPEN = "completion-substitute-text-keep-popup-open";
    private static final String COMPLETION_SUBSTITUTE_COMMON_TEXT = "completion-substitutecommon-text";
    private static final int ACTION_POPUP_HIDE = 1;
    private static final int ACTION_COMPLETION_UP = 2;
    private static final int ACTION_COMPLETION_DOWN = 3;
    private static final int ACTION_COMPLETION_PGUP = 4;
    private static final int ACTION_COMPLETION_PGDN = 5;
    private static final int ACTION_COMPLETION_BEGIN = 6;
    private static final int ACTION_COMPLETION_END = 7;
    private static final int ACTION_JAVADOC_UP = 8;
    private static final int ACTION_JAVADOC_DOWN = 9;
    private static final int ACTION_JAVADOC_PGUP = 10;
    private static final int ACTION_JAVADOC_PGDN = 11;
    private static final int ACTION_JAVADOC_BEGIN = 12;
    private static final int ACTION_JAVADOC_END = 13;
    private static final int ACTION_JAVADOC_LEFT = 14;
    private static final int ACTION_JAVADOC_RIGHT = 15;
    private static final int ACTION_JAVADOC_BACK = 16;
    private static final int ACTION_JAVADOC_FORWARD = 17;
    private static final int ACTION_JAVADOC_OPEN_IN_BROWSER = 18;
    private static final int ACTION_JAVADOC_OPEN_SOURCE = 19;
    private static final int ACTION_COMPLETION_SUBSTITUTE_TEXT = 20;
    private static final int ACTION_COMPLETION_SUBSTITUTE_TEXT_SIMPLE = 21;
    private static final int ACTION_COMPLETION_SUBSTITUTE_TEXT_KEEP_POPUP_OPEN = 22;
    private static final int ACTION_COMPLETION_SUBSTITUTE_COMMON_TEXT = 23;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDCPopupPanel(ExtEditorUI extEditorUI, ExtCompletionPane completion, Completion documentationProvider) {
        this.completion = completion;
        this.extEditorUI = extEditorUI;
        this.keyActionPairsList = new ArrayList();
        this.setLayout(null);
        this.setOpaque(false);
        this.focusL = new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JTextComponent component;
                        if (JDCPopupPanel.this.isVisible() && (component = JDCPopupPanel.this.extEditorUI.getComponent()) != null) {
                            boolean comO;
                            Component focusOwner;
                            Window w = SwingUtilities.windowForComponent(component);
                            Component component2 = focusOwner = w == null ? null : w.getFocusOwner();
                            if (focusOwner == null) {
                                JDCPopupPanel.this.setVisible(false);
                            }
                            boolean docO = JDCPopupPanel.this.javadoc != null && focusOwner == JDCPopupPanel.this.getJavaDocView();
                            boolean docA = JDCPopupPanel.this.javadoc != null && JDCPopupPanel.this.getJavaDocPane().getComponent().isAncestorOf(focusOwner);
                            boolean bl = comO = focusOwner == JDCPopupPanel.this.getCompletionView();
                            if (docO || comO || docA) {
                                component.requestFocus();
                            } else if (focusOwner != component) {
                                JDCPopupPanel.this.setVisible(false);
                            }
                        }
                    }
                });
            }
        };
        Object object = extEditorUI.getComponentLock();
        synchronized (object) {
            JTextComponent component = extEditorUI.getComponent();
            if (component != null) {
                this.propertyChange(new PropertyChangeEvent(extEditorUI, "component", null, component));
            }
            extEditorUI.addPropertyChangeListener(this);
        }
        super.setVisible(false);
        Settings.addSettingsChangeListener(this);
    }

    public ExtCompletionPane getCompletionPane() {
        return this.completion;
    }

    private void clearJavadocContent() {
        CompletionJavaDoc cjd = this.extEditorUI.getCompletionJavaDoc();
        if (cjd != null) {
            cjd.clearContent();
        }
    }

    private JavaDocView getJavaDocView() {
        CompletionJavaDoc cjd = this.extEditorUI.getCompletionJavaDoc();
        if (cjd != null) {
            return cjd.getJavaDocView();
        }
        return null;
    }

    private CompletionView getCompletionView() {
        Completion c = this.extEditorUI.getCompletion();
        if (c != null) {
            return c.getView();
        }
        return null;
    }

    public JavaDocPane getJavaDocPane() {
        Completion c;
        if (this.javadoc == null && (c = this.extEditorUI.getCompletion()) != null) {
            this.javadoc = c.getJavaDocPane();
        }
        return this.javadoc;
    }

    public Dimension getMinimumSize() {
        return this.completion.getComponent().getMinimumSize();
    }

    public Dimension getMaximumSize() {
        Dimension compDim = this.completion.getComponent().getMaximumSize();
        Dimension javadocDim = new Dimension();
        if (this.javadoc != null) {
            javadocDim = this.javadoc.getComponent().getMaximumSize();
        }
        return new Dimension(Math.max(compDim.width, javadocDim.width), compDim.height + javadocDim.height);
    }

    public Dimension getPreferredSize() {
        Dimension ret = new Dimension();
        Dimension compPref = this.completion.getComponent().getPreferredSize();
        Dimension compMax = this.completion.getComponent().getMaximumSize();
        Dimension javadocPref = new Dimension();
        Dimension javadocMax = new Dimension();
        if (this.javadoc != null) {
            javadocPref = this.javadoc.getComponent().getPreferredSize();
            javadocMax = this.javadoc.getComponent().getMaximumSize();
        }
        ret.width = Math.min(compPref.width, compMax.width) + Math.min(javadocPref.width, javadocMax.width);
        ret.height = Math.min(compPref.height, compMax.height) + Math.min(javadocPref.height, javadocMax.height);
        return ret;
    }

    public void setCompletionVisible(boolean visible) {
        this.completion.setVisible(visible);
        this.setVisible(visible);
    }

    public void setJavaDocVisible(boolean visible) {
        this.getJavaDocPane().getComponent().setVisible(visible);
        if (visible || !this.getCompletionPane().isVisible()) {
            this.setVisible(visible);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (Utilities.getLastActiveComponent() != this.extEditorUI.getComponent()) {
                return;
            }
            boolean docv = this.javadoc != null && this.javadoc.getComponent().isVisible();
            Completion c = this.extEditorUI.getCompletion();
            if (c != null) {
                int resultSize;
                CompletionQuery.Result result = c.getLastResult();
                int n = resultSize = result == null ? -1 : result.getData().size();
                if (this.lastSize != resultSize || !this.isVisible() || docv) {
                    this.extEditorUI.getPopupManager().install(this);
                    this.lastSize = resultSize;
                }
            }
            if (docv || this.completion.isVisible()) {
                super.setVisible(visible);
            }
        } else {
            this.lastSize = -1;
            this.clearJavadocContent();
            Completion c = this.extEditorUI.getCompletion();
            if (c != null) {
                c.completionCancel();
            }
            if (this.javadoc != null) {
                this.javadoc.getComponent().setVisible(visible);
            }
            this.completion.getComponent().setVisible(visible);
            super.setVisible(visible);
            PopupManager pm = this.extEditorUI.getPopupManager();
            if (pm != null) {
                pm.uninstall(this);
            }
        }
    }

    public void setSize(int width, int height) {
        boolean showCompletion;
        CompletionJavaDoc completionJavaDoc;
        PopupManager.Placement placement = (PopupManager.Placement)this.getClientProperty(PopupManager.Placement.class);
        Dimension completionMinSize = this.completion.getComponent().getMinimumSize();
        if (completionMinSize.height > height) {
            this.putClientProperty(PopupManager.Placement.class, null);
        }
        this.completion.getComponent().setSize(width, height);
        Dimension javaDocMinSize = new Dimension();
        if (this.javadoc != null) {
            javaDocMinSize = this.javadoc.getComponent().getMinimumSize();
        }
        Dimension completionMaxSize = this.completion.getComponent().getMaximumSize();
        Rectangle completionBounds = new Rectangle(this.completion.getComponent().getSize());
        Rectangle javadocBounds = new Rectangle();
        if (this.javadoc != null) {
            javadocBounds = new Rectangle(this.javadoc.getComponent().getMaximumSize());
        }
        boolean showJavaDoc = true;
        if (this.javadoc == null || !this.javadoc.getComponent().isVisible()) {
            showJavaDoc = false;
        }
        if ((completionJavaDoc = this.extEditorUI.getCompletionJavaDoc()) != null && completionJavaDoc.autoPopup()) {
            boolean bl = showJavaDoc = this.javadoc != null;
        }
        if (!(showCompletion = this.getCompletionPane().isVisible())) {
            completionMinSize.height = 0;
            completionMinSize.width = 0;
            completionBounds = new Rectangle();
        } else {
            completionBounds.width = Math.min(completionMaxSize.width, completionBounds.width);
            completionBounds.height = Math.min(completionMaxSize.height, completionBounds.height);
        }
        if (javaDocMinSize.height + completionMinSize.height > height) {
            showJavaDoc = false;
        }
        if (showJavaDoc) {
            if (completionBounds.height + javadocBounds.height > height) {
                completionBounds.height = Math.max(Math.min(height / 2, completionBounds.height), completionMinSize.height);
                completionBounds.height = Math.min(130, completionBounds.height);
                javadocBounds.height = Math.min(height - completionBounds.height - 1, javadocBounds.height);
            }
            if (placement == PopupManager.Below) {
                completionBounds.y = 0;
                javadocBounds.y = completionBounds.height + 1;
            } else {
                completionBounds.y = javadocBounds.height + 1;
                javadocBounds.y = 0;
            }
        }
        if (width < javaDocMinSize.width) {
            showJavaDoc = false;
        } else {
            javadocBounds.width = Math.min(width, javadocBounds.width);
            JTextComponent component = this.extEditorUI.getComponent();
            Rectangle extBounds = this.extEditorUI.getExtentBounds();
            Rectangle caretRect = new Rectangle();
            try {
                caretRect = component.getUI().modelToView(component, component.getCaret().getDot(), Position.Bias.Forward);
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
            completionBounds.x = width - javadocBounds.width < caretRect.x - extBounds.x ? (caretRect.x - extBounds.x + completionBounds.width < width ? caretRect.x - extBounds.x - width + javadocBounds.width : javadocBounds.width - completionBounds.width) : 0;
        }
        this.completion.setVisible(false);
        boolean isJavadocVisible = this.getJavaDocPane().getComponent().isVisible();
        if (isJavadocVisible && !showJavaDoc) {
            this.getJavaDocPane().getComponent().setVisible(false);
        }
        this.remove(this.completion.getComponent());
        if (this.javadoc != null) {
            this.remove(this.javadoc.getComponent());
        }
        if (showJavaDoc) {
            if (showCompletion) {
                this.completion.getComponent().setBounds(completionBounds);
                this.getJavaDocPane().getComponent().setBounds(javadocBounds);
                super.setBounds(0, 0, Math.max(completionBounds.width, javadocBounds.width), completionBounds.height + javadocBounds.height + 1);
                this.add(this.completion.getComponent());
                this.add(this.getJavaDocPane().getComponent());
                this.completion.setVisible(true);
                if (isJavadocVisible) {
                    this.getJavaDocPane().getComponent().setVisible(true);
                }
            } else {
                javadocBounds.x = 0;
                javadocBounds.y = 0;
                this.getJavaDocPane().getComponent().setBounds(javadocBounds);
                super.setBounds(0, 0, javadocBounds.width, javadocBounds.height);
                this.add(this.getJavaDocPane().getComponent());
                if (isJavadocVisible) {
                    this.getJavaDocPane().getComponent().setVisible(true);
                }
            }
        } else {
            completionBounds.x = 0;
            completionBounds.y = 0;
            this.completion.getComponent().setBounds(completionBounds);
            super.setBounds(0, 0, completionBounds.width, completionBounds.height + 1);
            this.add(this.completion.getComponent());
            this.completion.setVisible(true);
        }
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void refresh() {
        this.setVisible(true);
    }

    private void performJavaDocAction(KeyStroke ks) {
        ActionListener act = this.getJavaDocPane().getJavadocDisplayComponent().getActionForKeyStroke(ks);
        if (act != null) {
            act.actionPerformed(new ActionEvent(this.getJavaDocPane().getJavadocDisplayComponent(), 1001, ""));
            this.getJavaDocPane().getJavadocDisplayComponent().repaint();
        }
    }

    private KeyStroke[] findEditorKeys(String editorActionName, KeyStroke defaultKey) {
        JTextComponent component;
        KeyStroke[] ret = new KeyStroke[]{defaultKey};
        if (editorActionName != null && this.extEditorUI != null && (component = this.extEditorUI.getComponent()) != null) {
            KeyStroke[] keys;
            Action a;
            EditorKit kit;
            TextUI ui = component.getUI();
            Keymap km = component.getKeymap();
            if (ui != null && km != null && (kit = ui.getEditorKit(component)) instanceof BaseKit && (a = ((BaseKit)kit).getActionByName(editorActionName)) != null && (keys = km.getKeyStrokesForAction(a)) != null && keys.length > 0) {
                ret = keys;
            }
        }
        return ret;
    }

    private void registerKeybinding(int action, String actionName, KeyStroke stroke, String editorActionName) {
        KeyStroke[] keys = this.findEditorKeys(editorActionName, stroke);
        for (int i = 0; i < keys.length; ++i) {
            this.getInputMap().put(keys[i], actionName);
            this.keyActionPairsList.add(actionName);
            this.keyActionPairsList.add(keys[i]);
        }
        this.getActionMap().put(actionName, new JDCPopupAction(action));
    }

    private void unregisterKeybinding(String actionName, KeyStroke stroke) {
        this.getInputMap().remove(stroke);
        this.getActionMap().remove(actionName);
    }

    private void installKeybindings() {
        this.registerKeybinding(1, POPUP_HIDE, KeyStroke.getKeyStroke(27, 0), "escape");
        this.registerKeybinding(2, COMPLETION_UP, KeyStroke.getKeyStroke(38, 0), "caret-up");
        this.registerKeybinding(3, COMPLETION_DOWN, KeyStroke.getKeyStroke(40, 0), "caret-down");
        this.registerKeybinding(5, COMPLETION_PGDN, KeyStroke.getKeyStroke(34, 0), "page-down");
        this.registerKeybinding(4, COMPLETION_PGUP, KeyStroke.getKeyStroke(33, 0), "page-up");
        this.registerKeybinding(6, COMPLETION_BEGIN, KeyStroke.getKeyStroke(36, 0), "caret-begin-line");
        this.registerKeybinding(7, COMPLETION_END, KeyStroke.getKeyStroke(35, 0), "caret-end-line");
        this.registerKeybinding(8, JAVADOC_UP, KeyStroke.getKeyStroke(38, 1), null);
        this.registerKeybinding(9, JAVADOC_DOWN, KeyStroke.getKeyStroke(40, 1), null);
        this.registerKeybinding(11, JAVADOC_PGDN, KeyStroke.getKeyStroke(34, 1), null);
        this.registerKeybinding(10, JAVADOC_PGUP, KeyStroke.getKeyStroke(33, 1), null);
        this.registerKeybinding(12, JAVADOC_BEGIN, KeyStroke.getKeyStroke(36, 1), null);
        this.registerKeybinding(13, JAVADOC_END, KeyStroke.getKeyStroke(35, 1), null);
        this.registerKeybinding(14, JAVADOC_LEFT, KeyStroke.getKeyStroke(37, 1), null);
        this.registerKeybinding(15, JAVADOC_RIGHT, KeyStroke.getKeyStroke(39, 1), null);
        this.registerKeybinding(16, JAVADOC_BACK, KeyStroke.getKeyStroke(37, 8), null);
        this.registerKeybinding(17, JAVADOC_FORWARD, KeyStroke.getKeyStroke(39, 8), null);
        this.registerKeybinding(18, JAVADOC_OPEN_IN_BROWSER, KeyStroke.getKeyStroke(112, 9), null);
        this.registerKeybinding(19, JAVADOC_OPEN_SOURCE, KeyStroke.getKeyStroke(79, 10), null);
        this.registerKeybinding(20, COMPLETION_SUBSTITUTE_TEXT, KeyStroke.getKeyStroke(10, 0), null);
        this.registerKeybinding(21, COMPLETION_SUBSTITUTE_TEXT_SIMPLE, KeyStroke.getKeyStroke(10, 2), null);
        this.registerKeybinding(22, COMPLETION_SUBSTITUTE_TEXT_KEEP_POPUP_OPEN, KeyStroke.getKeyStroke(10, 1), null);
        this.registerKeybinding(23, COMPLETION_SUBSTITUTE_COMMON_TEXT, KeyStroke.getKeyStroke(9, 0), null);
    }

    private void uninstallKeybindings() {
        Iterator it = this.keyActionPairsList.iterator();
        while (it.hasNext()) {
            this.unregisterKeybinding((String)it.next(), (KeyStroke)it.next());
        }
        this.keyActionPairsList.clear();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("component".equals(propName)) {
            if (evt.getNewValue() != null) {
                JTextComponent component = this.extEditorUI.getComponent();
                this.installKeybindings();
                component.addFocusListener(this.focusL);
            } else {
                JTextComponent component = (JTextComponent)evt.getOldValue();
                this.uninstallKeybindings();
                component.removeFocusListener(this.focusL);
            }
        }
    }

    public void settingsChange(SettingsChangeEvent evt) {
        this.uninstallKeybindings();
        this.installKeybindings();
    }

    private class JDCPopupAction
    extends AbstractAction {
        private int action;

        private JDCPopupAction(int action) {
            this.action = action;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.action) {
                case 1: {
                    JDCPopupPanel.this.setVisible(false);
                    break;
                }
                case 2: {
                    if (JDCPopupPanel.this.completion.isVisible()) {
                        JDCPopupPanel.this.getCompletionView().up();
                        break;
                    }
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(38, 0));
                    break;
                }
                case 3: {
                    if (JDCPopupPanel.this.completion.isVisible()) {
                        JDCPopupPanel.this.getCompletionView().down();
                        break;
                    }
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(40, 0));
                    break;
                }
                case 4: {
                    if (JDCPopupPanel.this.completion.isVisible()) {
                        JDCPopupPanel.this.getCompletionView().pageUp();
                        break;
                    }
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(33, 0));
                    break;
                }
                case 5: {
                    if (JDCPopupPanel.this.completion.isVisible()) {
                        JDCPopupPanel.this.getCompletionView().pageDown();
                        break;
                    }
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(34, 0));
                    break;
                }
                case 6: {
                    if (JDCPopupPanel.this.completion.isVisible()) {
                        JDCPopupPanel.this.getCompletionView().begin();
                        break;
                    }
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(36, 0));
                    break;
                }
                case 7: {
                    if (JDCPopupPanel.this.completion.isVisible()) {
                        JDCPopupPanel.this.getCompletionView().end();
                        break;
                    }
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(35, 0));
                    break;
                }
                case 8: {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(38, 0));
                    break;
                }
                case 9: {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(40, 0));
                    break;
                }
                case 10: {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(33, 0));
                    break;
                }
                case 11: {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(34, 0));
                    break;
                }
                case 12: {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(36, 0));
                    break;
                }
                case 13: {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(35, 0));
                    break;
                }
                case 14: {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(37, 0));
                    break;
                }
                case 15: {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(39, 0));
                    break;
                }
                case 16: {
                    CompletionJavaDoc cjd = JDCPopupPanel.this.extEditorUI.getCompletionJavaDoc();
                    if (cjd == null) break;
                    cjd.backHistory();
                    break;
                }
                case 17: {
                    CompletionJavaDoc cjd = JDCPopupPanel.this.extEditorUI.getCompletionJavaDoc();
                    if (cjd == null) break;
                    cjd.forwardHistory();
                    break;
                }
                case 18: {
                    CompletionJavaDoc cjd = JDCPopupPanel.this.extEditorUI.getCompletionJavaDoc();
                    if (cjd == null || !cjd.isExternalJavaDocMounted()) break;
                    cjd.openInExternalBrowser();
                    break;
                }
                case 19: {
                    CompletionJavaDoc cjd = JDCPopupPanel.this.extEditorUI.getCompletionJavaDoc();
                    if (cjd == null) break;
                    cjd.goToSource();
                    break;
                }
                case 20: {
                    Completion cc = JDCPopupPanel.this.extEditorUI.getCompletion();
                    if (cc == null || !cc.isPaneVisible()) break;
                    if (cc.substituteText(false)) {
                        cc.setPaneVisible(false);
                        break;
                    }
                    cc.refresh(false);
                    break;
                }
                case 21: {
                    Completion cc = JDCPopupPanel.this.extEditorUI.getCompletion();
                    if (cc == null || !cc.isPaneVisible()) break;
                    if (cc.substituteSimpleText()) {
                        cc.setPaneVisible(false);
                        break;
                    }
                    cc.refresh(false);
                    break;
                }
                case 22: {
                    Completion cc = JDCPopupPanel.this.extEditorUI.getCompletion();
                    if (cc == null || !cc.isPaneVisible() || cc.substituteText(true)) break;
                    cc.refresh(false);
                    break;
                }
                case 23: {
                    Completion cc = JDCPopupPanel.this.extEditorUI.getCompletion();
                    if (cc == null || !cc.isPaneVisible()) break;
                    cc.refresh(false);
                    cc.substituteCommonText();
                }
            }
        }
    }
}

