/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Segment;

public class SegmentCache {
    private static final SegmentCache SHARED = new SegmentCache();
    private List freeSegments = new ArrayList();

    public static SegmentCache getSharedInstance() {
        return SHARED;
    }

    public synchronized Segment getSegment() {
        int size = this.freeSegments.size();
        return size > 0 ? (Segment)this.freeSegments.remove(size - 1) : new CachedSegment();
    }

    public synchronized void releaseSegment(Segment segment) {
        if (!(segment instanceof CachedSegment)) {
            throw new IllegalStateException(segment + " was not obtained from segment cache");
        }
        segment.array = null;
        segment.count = 0;
        this.freeSegments.add(segment);
    }

    private static class CachedSegment
    extends Segment {
        private CachedSegment() {
        }
    }
}

