/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.CollapsedView;
import org.netbeans.lib.editor.view.GapMultiLineView;

class FoldMultiLineView
extends GapMultiLineView {
    private List foldAndEndLineElemList;

    FoldMultiLineView(Element firstLineElement, List foldAndEndLineElemList) {
        super(firstLineElement);
        this.foldAndEndLineElemList = foldAndEndLineElemList;
        int foldAndEndLineElemListSize = foldAndEndLineElemList.size();
        this.setLastLineElement((Element)foldAndEndLineElemList.get(foldAndEndLineElemList.size() - 1));
    }

    private JTextComponent getTextComponent() {
        return (JTextComponent)this.getContainer();
    }

    protected boolean useCustomReloadChildren() {
        return true;
    }

    protected void reloadChildren(int index, int removeLength, int startOffset, int endOffset) {
        index = 0;
        removeLength = this.getViewCount();
        Element lineElem = this.getElement();
        View[] added = null;
        ViewFactory f = this.getViewFactory();
        if (f != null) {
            int lineElemEndOffset = lineElem.getEndOffset();
            int lastViewEndOffset = lineElem.getStartOffset();
            int cnt = this.foldAndEndLineElemList.size();
            ArrayList<View> childViews = new ArrayList<View>();
            for (int i = 0; i < cnt; ++i) {
                Fold fold = (Fold)this.foldAndEndLineElemList.get(i);
                int foldStartOffset = fold.getStartOffset();
                int foldEndOffset = fold.getEndOffset();
                BaseDocument doc = (BaseDocument)lineElem.getDocument();
                try {
                    if (foldStartOffset > lastViewEndOffset) {
                        View lineView = f.create(lineElem);
                        View intraFrag = lineView.createFragment(lastViewEndOffset, foldStartOffset);
                        childViews.add(intraFrag);
                        lastViewEndOffset = foldStartOffset;
                    }
                    Position viewStartPos = doc.createPosition(foldStartOffset);
                    Position viewEndPos = doc.createPosition(foldEndOffset);
                    CollapsedView collapsedView = new CollapsedView(lineElem, viewStartPos, viewEndPos, fold.getDescription());
                    childViews.add(collapsedView);
                    lastViewEndOffset = foldEndOffset;
                }
                catch (BadLocationException e) {
                    throw new IllegalStateException("Failed to create view boundary positions");
                }
                lineElem = (Element)this.foldAndEndLineElemList.get(++i);
                lineElemEndOffset = lineElem.getEndOffset();
            }
            if (lastViewEndOffset < lineElemEndOffset) {
                View lineView = f.create(lineElem);
                View endingFrag = lineView.createFragment(lastViewEndOffset, lineElemEndOffset);
                childViews.add(endingFrag);
            }
            added = new View[childViews.size()];
            childViews.toArray(added);
        }
        this.replace(index, removeLength, added);
    }
}

