/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.io.File;
import java.util.Enumeration;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class Utilities {
    public static final String canUseFileName(File dir, String relativePath, String objectName, String extension) {
        String newObjectName = objectName;
        if (extension != null && extension.length() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(objectName);
            sb.append('.');
            sb.append(extension);
            newObjectName = sb.toString();
        }
        if (!Utilities.checkFileName(objectName)) {
            return NbBundle.getMessage(Utilities.class, (String)"MSG_invalid_filename", (Object)newObjectName);
        }
        FileObject folder = null;
        if (dir != null) {
            try {
                folder = FileUtil.toFileObject((File)dir);
            }
            catch (IllegalArgumentException ex) {
                return NbBundle.getMessage(Utilities.class, (String)"MSG_invalid_path", (Object)relativePath);
            }
        }
        if (folder != null) {
            if (!folder.canWrite()) {
                return NbBundle.getMessage(Utilities.class, (String)"MSG_fs_is_readonly");
            }
            if (folder.getFileObject(newObjectName) != null) {
                return NbBundle.getMessage(Utilities.class, (String)"MSG_file_already_exist", (Object)newObjectName);
            }
            if (org.openide.util.Utilities.isWindows() && Utilities.checkCaseInsensitiveName(folder, newObjectName)) {
                return NbBundle.getMessage(Utilities.class, (String)"MSG_file_already_exist", (Object)newObjectName);
            }
        }
        return null;
    }

    private static boolean checkCaseInsensitiveName(FileObject folder, String name) {
        Enumeration children = folder.getChildren(false);
        while (children.hasMoreElements()) {
            FileObject fo = (FileObject)children.nextElement();
            if (!name.equalsIgnoreCase(fo.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean checkFileName(String str) {
        char[] c = str.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\\') {
                return false;
            }
            if (c[i] != '/') continue;
            return false;
        }
        return true;
    }

    public static String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }
}

