/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.io.IOException;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.core.jsploader.TagLibParseSupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class JspLoader
extends UniFileLoader {
    private static final long serialVersionUID = 1549250022027438942L;
    public static final String JSP_EXTENSION = "jsp";
    public static final String JSPF_EXTENSION = "jspf";
    public static final String JSF_EXTENSION = "jsf";
    public static final String JSPX_EXTENSION = "jspx";
    public static final String TAG_FILE_EXTENSION = "tag";
    public static final String TAGF_FILE_EXTENSION = "tagf";
    public static final String TAGX_FILE_EXTENSION = "tagx";
    public static final String JSP_MIME_TYPE = "text/x-jsp";
    public static final String TAG_MIME_TYPE = "text/x-tag";

    public static String getMimeType(JspDataObject data) {
        if (data == null || !(data instanceof JspDataObject)) {
            return "";
        }
        String ext = data.getPrimaryFile().getExt();
        if (ext.equals(TAG_FILE_EXTENSION) || ext.equals(TAGF_FILE_EXTENSION) || ext.equals(TAGX_FILE_EXTENSION)) {
            return TAG_MIME_TYPE;
        }
        return JSP_MIME_TYPE;
    }

    protected void initialize() {
        super.initialize();
        ExtensionList ext = new ExtensionList();
        ext.addExtension(JSP_EXTENSION);
        ext.addExtension(JSPF_EXTENSION);
        ext.addExtension(JSF_EXTENSION);
        ext.addExtension(JSPX_EXTENSION);
        ext.addExtension(TAG_FILE_EXTENSION);
        ext.addExtension(TAGF_FILE_EXTENSION);
        ext.addExtension(TAGX_FILE_EXTENSION);
        this.setExtensions(ext);
    }

    protected String defaultDisplayName() {
        return NbBundle.getBundle(JspLoader.class).getString("PROP_JspLoader_Name");
    }

    protected String actionsContext() {
        return "Loaders/text/x-jsp/Actions/";
    }

    public JspLoader() {
        super("org.netbeans.modules.web.core.jsploader.JspDataObject");
    }

    protected JspLoader(Class clazz) {
        super(clazz);
    }

    protected JspLoader(String str) {
        super(str);
    }

    protected JspDataObject createJspObject(FileObject pf, UniFileLoader l) throws DataObjectExistsException {
        return new JspDataObject(pf, l);
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        JspDataObject obj = this.createJspObject(primaryFile, this);
        obj.getCookieSet0().add((Node.Cookie)new TagLibParseSupport(primaryFile));
        return obj;
    }
}

