/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.awt.Image;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.jsploader.JspParserAccess;
import org.netbeans.modules.web.core.jsploader.TagLibParseSupport;
import org.netbeans.modules.web.core.syntax.spi.JSPColoringData;
import org.netbeans.modules.web.core.syntax.spi.JspContextInfo;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.web.jsps.parserapi.JspParserFactory;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class JspContextInfoImpl
extends JspContextInfo {
    private static TagLibParseSupport getTagLibParseSupport(Document doc, FileObject fo) {
        TagLibParseSupport tlps = null;
        if (fo != null && fo.isValid()) {
            try {
                tlps = (TagLibParseSupport)DataObject.find((FileObject)fo).getCookie(TagLibParseSupport.class);
            }
            catch (DataObjectNotFoundException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return tlps;
    }

    public URLClassLoader getModuleClassLoader(Document doc, FileObject fo) {
        return JspParserFactory.getJspParser().getModuleClassLoader(JspParserAccess.getJspParserWM(WebModule.getWebModule((FileObject)fo)));
    }

    public Map getTaglibMap(Document doc, FileObject fo) {
        try {
            JspParserAPI parser = JspParserFactory.getJspParser();
            if (parser != null) {
                return parser.getTaglibMap(JspParserAccess.getJspParserWM(WebModule.getWebModule((FileObject)fo)));
            }
            ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException());
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return null;
    }

    public Image getIcon(Document doc, FileObject fo) {
        Image icon = null;
        try {
            icon = DataObject.find((FileObject)fo).getNodeDelegate().getIcon(1);
        }
        catch (DataObjectNotFoundException e) {
            e.printStackTrace(System.out);
        }
        return icon;
    }

    public JspParserAPI.ParseResult getCachedParseResult(Document doc, FileObject fo, boolean successfulOnly, boolean preferCurrent, boolean forceParse) {
        TagLibParseSupport sup = JspContextInfoImpl.getTagLibParseSupport(doc, fo);
        if (sup != null) {
            return sup.getCachedParseResult(successfulOnly, preferCurrent, forceParse);
        }
        return null;
    }

    public JspParserAPI.ParseResult getCachedParseResult(Document doc, FileObject fo, boolean successfulOnly, boolean preferCurrent) {
        return this.getCachedParseResult(doc, fo, successfulOnly, preferCurrent, false);
    }

    public JSPColoringData getJSPColoringData(Document doc, FileObject fo) {
        TagLibParseSupport sup = JspContextInfoImpl.getTagLibParseSupport(doc, fo);
        if (sup != null) {
            return sup.getJSPColoringData();
        }
        return null;
    }

    public JspParserAPI.JspOpenInfo getCachedOpenInfo(Document doc, FileObject fo, boolean preferCurrent) {
        TagLibParseSupport sup = JspContextInfoImpl.getTagLibParseSupport(doc, fo);
        if (sup != null) {
            return sup.getCachedOpenInfo(preferCurrent, true);
        }
        return null;
    }

    public FileObject guessWebModuleRoot(Document doc, FileObject fo) {
        WebModule wm = WebModule.getWebModule((FileObject)fo);
        if (wm != null) {
            return wm.getDocumentBase();
        }
        return null;
    }
}

