/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.netbeans.modules.options.keymap.ActionImpl;
import org.netbeans.modules.options.keymap.KeymapListRenderer;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.netbeans.modules.options.keymap.ShortcutsDialog;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class KeymapPanel
extends JPanel
implements ActionListener,
TreeSelectionListener,
ListSelectionListener {
    private JButton bDelete = new JButton();
    private JButton bClone = new JButton();
    private ButtonGroup bgViewAs = new ButtonGroup();
    private JComboBox cbProfiles = new JComboBox();
    private JRadioButton rbAction = new JRadioButton();
    private JRadioButton rbShortcut = new JRadioButton();
    private JTree tree = new JTree();
    private JList lShortcuts = new JList();
    private JButton bAddShortcut = new JButton();
    private JButton bRemoveShortcut = new JButton();
    private boolean listen = false;
    private boolean initialized = false;
    private KeymapViewModel model;

    public KeymapPanel() {
        KeymapPanel.loc(this.bClone, "Duplicate");
        KeymapPanel.loc(this.bDelete, "Delete");
        KeymapPanel.loc(this.rbAction, "Show_Actions");
        KeymapPanel.loc(this.rbShortcut, "Show_Shortcuts");
        this.lShortcuts.getAccessibleContext().setAccessibleName(KeymapPanel.loc("AN_Shortcuts"));
        this.lShortcuts.getAccessibleContext().setAccessibleDescription(KeymapPanel.loc("AD_Shortcuts"));
        this.tree.getAccessibleContext().setAccessibleName(KeymapPanel.loc("AN_Actions"));
        this.tree.getAccessibleContext().setAccessibleDescription(KeymapPanel.loc("AD_Actions"));
        this.cbProfiles.getAccessibleContext().setAccessibleName(KeymapPanel.loc("AN_Profiles"));
        this.cbProfiles.getAccessibleContext().setAccessibleDescription(KeymapPanel.loc("AD_Profiles"));
        this.bgViewAs.add(this.rbAction);
        this.bgViewAs.add(this.rbShortcut);
        this.bClone.addActionListener(this);
        this.bDelete.addActionListener(this);
        this.rbAction.setSelected(true);
        this.rbAction.addActionListener(this);
        this.rbShortcut.addActionListener(this);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeSelectionListener(this);
        JScrollPane spTree = new JScrollPane(this.tree);
        spTree.setPreferredSize(new Dimension(10, 10));
        this.cbProfiles.addActionListener(this);
        KeymapPanel.loc(this.bAddShortcut, "Add_Shortcut");
        KeymapPanel.loc(this.bRemoveShortcut, "Remove_Shortcut");
        this.bAddShortcut.addActionListener(this);
        this.bRemoveShortcut.addActionListener(this);
        this.lShortcuts.addListSelectionListener(this);
        JScrollPane spShortcuts = new JScrollPane(this.lShortcuts);
        spShortcuts.setPreferredSize(new Dimension(10, 10));
        this.bAddShortcut.setEnabled(false);
        this.bRemoveShortcut.setEnabled(false);
        JLabel lbShortcuts = new JLabel();
        KeymapPanel.loc(lbShortcuts, "Shortcuts");
        lbShortcuts.setLabelFor(this.lShortcuts);
        JLabel lTree = new JLabel();
        KeymapPanel.loc(lTree, "Actions");
        lTree.setLabelFor(this.tree);
        FormLayout layout = new FormLayout("p", "p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        CellConstraints lc = new CellConstraints();
        builder.add((Component)this.bAddShortcut, cc.xy(1, 1));
        builder.add((Component)this.bRemoveShortcut, cc.xy(1, 3));
        JPanel pButtons1 = builder.getPanel();
        JPanel pButtons2 = new JPanel(new GridLayout(1, 2, 3, 3));
        pButtons2.add(this.bClone);
        pButtons2.add(this.bDelete);
        layout = new FormLayout("p:g, 3dlu, p:g", "p, 1dlu, p");
        layout.setColumnGroups((int[][])new int[][]{{1, 3}});
        builder = new PanelBuilder(layout);
        builder.add((Component)lbShortcuts, lc.xy(1, 1));
        builder.add((Component)spShortcuts, cc.xy(1, 3, "f, f"));
        builder.add((Component)pButtons1, cc.xy(3, 3));
        JPanel shortcuts = builder.getPanel();
        layout = new FormLayout("p, 3dlu, p:g, 5dlu, p", "p, 3dlu, p, 1dlu, 50dlu:g, 5dlu, p");
        builder = new PanelBuilder(layout, (JPanel)this);
        builder.addLabel(KeymapPanel.loc("Keymap_Name"), lc.xy(1, 1), (Component)this.cbProfiles, cc.xy(3, 1));
        builder.add((Component)pButtons2, cc.xy(5, 1));
        builder.add((Component)lTree, lc.xyw(1, 3, 5));
        builder.add((Component)spTree, cc.xywh(1, 5, 5, 1, "f, f"));
        builder.add((Component)shortcuts, cc.xyw(1, 7, 5));
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.listen) {
            return;
        }
        Object source = e.getSource();
        if (source == this.bAddShortcut) {
            Object action = this.tree.getSelectionPath().getLastPathComponent();
            String shortcut = ShortcutsDialog.getShortcut(this.getModel());
            if (shortcut == null) {
                return;
            }
            this.getModel().addShortcut(this.tree.getSelectionPath(), shortcut);
            this.selectAction(action);
            if (this.lShortcuts.getModel().getSize() > 0) {
                this.lShortcuts.setSelectedIndex(0);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    KeymapPanel.this.lShortcuts.requestFocus();
                }
            });
        } else if (source == this.bRemoveShortcut) {
            int index = this.lShortcuts.getSelectedIndex();
            Object action = this.tree.getSelectionPath().getLastPathComponent();
            String shortcut = (String)this.lShortcuts.getSelectedValue();
            this.getModel().removeShortcut(this.tree.getSelectionPath(), shortcut);
            this.selectAction(action);
            if (this.lShortcuts.getModel().getSize() > index) {
                this.lShortcuts.setSelectedIndex(index);
            } else if (this.lShortcuts.getModel().getSize() > 0) {
                this.lShortcuts.setSelectedIndex(0);
            }
        } else if (source == this.bDelete) {
            this.deleteCurrentProfile();
        } else if (source == this.cbProfiles) {
            String profile = (String)this.cbProfiles.getSelectedItem();
            this.getModel().setCurrentProfile(profile);
            if (this.getModel().isCustomProfile(profile)) {
                KeymapPanel.loc(this.bDelete, "Delete");
            } else {
                KeymapPanel.loc(this.bDelete, "Restore");
            }
            this.refreshAction();
        } else if (source == this.bClone) {
            NotifyDescriptor.InputLine il = new NotifyDescriptor.InputLine(KeymapPanel.loc("CTL_Create_New_Profile_Message"), KeymapPanel.loc("CTL_Create_New_Profile_Title"));
            il.setInputText((String)this.cbProfiles.getSelectedItem());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)il);
            if (il.getValue() == NotifyDescriptor.OK_OPTION) {
                String newProfile = il.getInputText();
                Iterator it = this.getModel().getProfiles().iterator();
                while (it.hasNext()) {
                    if (!newProfile.equals(it.next())) continue;
                    NotifyDescriptor.Message md = new NotifyDescriptor.Message((Object)KeymapPanel.loc("CTL_Duplicate_Profile_Name"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)md);
                    return;
                }
                this.getModel().cloneProfile(newProfile);
                this.cbProfiles.addItem(il.getInputText());
                this.cbProfiles.setSelectedItem(il.getInputText());
            }
            return;
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (!this.listen) {
            return;
        }
        this.refreshAction();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.listen) {
            return;
        }
        int i = this.lShortcuts.getSelectedIndex();
        if (i < 0) {
            this.bRemoveShortcut.setEnabled(false);
            return;
        }
        this.bRemoveShortcut.setEnabled(true);
    }

    void update() {
        if (!this.initialized) {
            this.initialized = true;
            this.listen = false;
            this.tree.setCellRenderer(new KeymapListRenderer(this.getModel()));
            this.tree.setModel(this.getModel());
            List keymaps = this.getModel().getProfiles();
            this.cbProfiles.removeAllItems();
            int k = keymaps.size();
            for (int i = 0; i < k; ++i) {
                this.cbProfiles.addItem(keymaps.get(i));
            }
            this.listen = true;
        }
        this.cbProfiles.setSelectedItem(this.getModel().getCurrentProfile());
    }

    private void deleteCurrentProfile() {
        String currentProfile = (String)this.cbProfiles.getSelectedItem();
        this.getModel().deleteProfile(currentProfile);
        if (this.getModel().isCustomProfile(currentProfile)) {
            this.cbProfiles.removeItem(currentProfile);
            this.cbProfiles.setSelectedIndex(0);
        }
    }

    void applyChanges() {
        if (!this.initialized) {
            return;
        }
        this.getModel().apply();
    }

    void cancel() {
        if (this.model == null) {
            return;
        }
        this.model.cancel();
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        return this.getModel().isChanged();
    }

    KeymapViewModel getModel() {
        if (this.model == null) {
            this.model = new KeymapViewModel();
        }
        return this.model;
    }

    private static String loc(String key) {
        return NbBundle.getMessage((Class)KeymapPanel.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (!(c instanceof JLabel)) {
            c.getAccessibleContext().setAccessibleName(KeymapPanel.loc("AN_" + key));
            c.getAccessibleContext().setAccessibleDescription(KeymapPanel.loc("AD_" + key));
        }
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)KeymapPanel.loc("CTL_" + key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)KeymapPanel.loc("CTL_" + key));
        }
    }

    void refreshAction() {
        Object action = this.tree.getSelectionPath() == null ? null : this.tree.getSelectionPath().getLastPathComponent();
        this.selectAction(action);
        if (this.lShortcuts.getModel().getSize() > 0) {
            this.lShortcuts.setSelectedIndex(0);
        }
    }

    void selectAction(Object action) {
        if (action == null || action instanceof String) {
            this.lShortcuts.setModel(new DefaultListModel());
            this.bAddShortcut.setEnabled(false);
            this.bRemoveShortcut.setEnabled(false);
            return;
        }
        this.bAddShortcut.setEnabled(true);
        this.bRemoveShortcut.setEnabled(false);
        final String[] shortcuts = this.getModel().getShortcuts((ActionImpl)action);
        this.lShortcuts.setModel(new AbstractListModel(){

            public int getSize() {
                return shortcuts.length;
            }

            public Object getElementAt(int i) {
                return shortcuts[i];
            }
        });
    }
}

