/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.j2ee.xml;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMWriter {
    protected PrintWriter out;
    protected int indent = 0;
    protected String encodingTag;
    protected String docTypeString;
    protected String prefix;

    public void printIndent() {
        this.out.print(this.prefix);
        int i = 0;
        while (i < this.indent) {
            this.out.print(" ");
            ++i;
        }
    }

    public void print(Node node) {
        if (node != null) {
            XMLVisitor visitor = new XMLVisitor();
            visitor.visitNode(node);
        }
        this.out.flush();
    }

    protected String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = (s = s.trim()) != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    public DOMWriter(Document document, PrintWriter writer, String encodingTag, String docTypeString, String prefix) {
        this.prefix = prefix;
        this.indent = this.indent;
        this.encodingTag = encodingTag;
        this.docTypeString = docTypeString;
        this.out = writer;
        this.print(document);
    }

    public DOMWriter(Document document, String outfile, String encoding, String encodingTag, String docTypeString) {
        this.encodingTag = encodingTag;
        this.docTypeString = docTypeString;
        try {
            OutputStreamWriter writer = encoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(outfile), encoding) : new OutputStreamWriter((OutputStream)new FileOutputStream(outfile), "UTF8");
            this.out = new PrintWriter(new BufferedWriter(writer));
            this.print(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class XMLVisitor {
        public void visitAttr(Attr attr) {
            if (attr.getSpecified()) {
                DOMWriter.this.out.print(" ");
                DOMWriter.this.out.print(attr.getNodeName() + "=\"" + attr.getValue() + '\"');
            }
        }

        public void visitCDATASection(CDATASection cdataSection) {
        }

        public void visitComment(Comment comment) {
            DOMWriter.this.printIndent();
            DOMWriter.this.out.print("<!--");
            DOMWriter.this.out.print(DOMWriter.this.normalize(comment.getNodeValue()));
            DOMWriter.this.out.println("-->");
        }

        public void visitDocument(Document document) {
            if (DOMWriter.this.encodingTag != null && !DOMWriter.this.encodingTag.equals("")) {
                DOMWriter.this.out.println("<?xml version=\"1.0\" encoding=\"" + DOMWriter.this.encodingTag + "\"?>");
            }
            if (DOMWriter.this.docTypeString != null && !DOMWriter.this.docTypeString.equals("")) {
                DOMWriter.this.out.println(DOMWriter.this.docTypeString);
            }
            this.visitChildNodesHelper(document);
        }

        public void visitElement(Element element) {
            boolean currentElementHasChildElements = this.hasChildElements(element);
            DOMWriter.this.printIndent();
            DOMWriter.this.out.print('<' + element.getNodeName());
            this.visitAttributesHelper(element);
            DOMWriter.this.out.print(">");
            if (currentElementHasChildElements) {
                DOMWriter.this.out.print("\n");
            }
            DOMWriter.this.indent += 2;
            this.visitChildNodesHelper(element);
            DOMWriter.this.indent -= 2;
            if (currentElementHasChildElements) {
                DOMWriter.this.printIndent();
            }
            DOMWriter.this.out.println("</" + element.getNodeName() + ">");
        }

        public void visitAttributesHelper(Node node) {
            NamedNodeMap map = node.getAttributes();
            int i = 0;
            while (i < map.getLength()) {
                this.visitNode(map.item(i));
                ++i;
            }
        }

        public void visitChildNodesHelper(Node node) {
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                this.visitNode(children.item(i));
                ++i;
            }
        }

        public void visitNode(Node node) {
            switch (node.getNodeType()) {
                case 2: {
                    this.visitAttr((Attr)node);
                    break;
                }
                case 4: {
                    this.visitCDATASection((CDATASection)node);
                    break;
                }
                case 8: {
                    this.visitComment((Comment)node);
                    break;
                }
                case 9: {
                    this.visitDocument((Document)node);
                    break;
                }
                case 1: {
                    this.visitElement((Element)node);
                    break;
                }
                case 7: {
                    this.visitProcessingInstruction((ProcessingInstruction)node);
                    break;
                }
                case 3: {
                    this.visitText((Text)node);
                }
            }
        }

        public boolean hasChildElements(Node node) {
            boolean result = false;
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i).getNodeType() == 1) {
                    result = true;
                    break;
                }
                ++i;
            }
            return result;
        }

        public void visitProcessingInstruction(ProcessingInstruction pi) {
            DOMWriter.this.printIndent();
            DOMWriter.this.out.print("<?");
            DOMWriter.this.out.print(pi.getNodeName());
            DOMWriter.this.out.print(" ");
            DOMWriter.this.out.print(DOMWriter.this.normalize(pi.getNodeValue()));
            DOMWriter.this.out.println("?>");
        }

        public void visitText(Text text) {
            DOMWriter.this.out.print(DOMWriter.this.normalize(text.getNodeValue()));
        }
    }
}

