/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.simpletype;

import com.sun.xml.rpc.encoding.simpletype.EncoderUtils;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoderBase;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;

public class XSDHexBinaryEncoder
extends SimpleTypeEncoderBase {
    private static final SimpleTypeEncoder encoder = new XSDHexBinaryEncoder();
    private static final char[] encodeHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int[] decodeHex = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};

    private XSDHexBinaryEncoder() {
    }

    public static SimpleTypeEncoder getInstance() {
        return encoder;
    }

    public Object stringToObject(String str, XMLReader reader) throws Exception {
        if (str == null) {
            return null;
        }
        String encodedValue = EncoderUtils.collapseWhitespace(str);
        int valueLength = encodedValue.length() / 2;
        byte[] value = new byte[valueLength];
        int encodedIdx = 0;
        int i = 0;
        while (i < valueLength) {
            int nibble1 = decodeHex[encodedValue.charAt(encodedIdx++) - 48];
            int nibble2 = decodeHex[encodedValue.charAt(encodedIdx++) - 48];
            value[i] = (byte)(nibble1 << 4 | nibble2);
            ++i;
        }
        return value;
    }

    public String objectToString(Object obj, XMLWriter writer) throws Exception {
        if (obj == null) {
            return null;
        }
        byte[] value = (byte[])obj;
        if (value.length == 0) {
            return "";
        }
        StringBuffer encodedValue = new StringBuffer(value.length * 2);
        int i = 0;
        while (i < value.length) {
            encodedValue.append(encodeHex[value[i] >> 4 & 0xF]);
            encodedValue.append(encodeHex[value[i] & 0xF]);
            ++i;
        }
        return encodedValue.toString();
    }
}

