/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel.transientimpl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.transientimpl.CompensatingTransaction;
import org.netbeans.mdr.storagemodel.transientimpl.TransientIndex;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;
import org.netbeans.mdr.util.MapEntryImpl;

public class TransientSinglevaluedIndex
extends TransientIndex
implements SinglevaluedIndex {
    public TransientSinglevaluedIndex(MdrStorage storage, String name, Storage.EntryType keyType, Storage.EntryType valueType) {
        super(storage, name, keyType, valueType);
    }

    public void add(Object key, Object value) throws StorageException {
        this.addNoTx(key, value);
        this.handleAdd(key, value);
    }

    public Object get(Object key) throws StorageException, StorageBadRequestException {
        Object result = this.getIfExists(key);
        if (result == null) {
            throw new StorageBadRequestException();
        }
        return result;
    }

    public Object getIfExists(Object key) throws StorageException {
        if (this.map == null) {
            return null;
        }
        this.expungeStaleEntries();
        TransientIndex.Entry e = (TransientIndex.Entry)this.map.get(key);
        if (e == null) {
            return null;
        }
        if (!e.isValid()) {
            return null;
        }
        return e.getValue();
    }

    public Object getObject(Object key, SinglevaluedIndex repos) throws StorageException {
        Object result = this.getObjectIfExists(key, repos);
        if (result == null) {
            throw new StorageBadRequestException();
        }
        return result;
    }

    public Object getObjectIfExists(Object key, SinglevaluedIndex repos) throws StorageException {
        Object result = this.get(key);
        if (result == null) {
            return result;
        }
        return repos.get(repos);
    }

    protected void handleRemove(Object key, Object value) throws StorageException {
        MOFID val = ((TransientIndex.Entry)value).getValue();
        this.txlog.push(new CompensatingTransaction.RemoveCTx(key, val));
        ((TransientIndex.Entry)value).dispose();
    }

    public Set keySet() throws StorageException {
        if (this.map == null) {
            this.map = new HashMap();
        }
        return new SinglevaluedEntryKeySet();
    }

    public boolean put(Object key, Object value) throws StorageException {
        if (this.map == null) {
            this.map = new HashMap();
        } else {
            this.expungeStaleEntries();
        }
        TransientIndex.Entry e = new TransientIndex.Entry(key, value);
        TransientIndex.Entry oldValue = this.map.put(key, e);
        if (oldValue != null) {
            this.handleRemove(key, oldValue);
        }
        this.handleAdd(key, value);
        return oldValue != null;
    }

    public void replace(Object key, Object value) throws StorageException, StorageBadRequestException {
        if (this.map == null) {
            throw new StorageBadRequestException();
        }
        this.expungeStaleEntries();
        if (this.map.get(key) == null) {
            throw new StorageBadRequestException();
        }
        TransientIndex.Entry e = new TransientIndex.Entry(key, value);
        TransientIndex.Entry oldValue = this.map.put(key, e);
        this.handleRemove(key, oldValue);
        this.handleAdd(key, value);
    }

    public Collection values() throws StorageException {
        return new ValuesCollection();
    }

    public Collection queryByKeyPrefix(Object prefix, SinglevaluedIndex primaryIndex) throws StorageException {
        if (this.getKeyType() != Storage.EntryType.STRING) {
            throw new UnsupportedOperationException("Key type must be EntryType.STRING");
        }
        if (!(prefix instanceof String)) {
            throw new StorageBadRequestException("String object parameter expected.");
        }
        LinkedList<MapEntryImpl> result = new LinkedList<MapEntryImpl>();
        for (String key : this.keySet()) {
            if (!key.startsWith((String)prefix)) continue;
            result.add(new MapEntryImpl(key, this.getObject(key, primaryIndex)));
        }
        return result;
    }

    protected void expungeStaleEntries() {
        TransientIndex.KeyedReference ref = null;
        while ((ref = (TransientIndex.KeyedReference)this.refQueue.poll()) != null) {
            MOFID key = ref.getLookupKey();
            TransientIndex.Entry e = (TransientIndex.Entry)this.map.remove(key);
            if (e == null) continue;
            e.dispose();
        }
    }

    protected final void addNoTx(Object key, Object value) throws StorageException {
        if (this.map == null) {
            this.map = new HashMap();
        } else {
            this.expungeStaleEntries();
            if (this.map.get(key) != null) {
                throw new StorageBadRequestException();
            }
        }
        TransientIndex.Entry e = new TransientIndex.Entry(key, value);
        this.map.put(key, e);
    }

    protected final Object removeNoTx(Object key, Object value) throws StorageException {
        this.expungeStaleEntries();
        TransientIndex.Entry e = (TransientIndex.Entry)this.map.remove(key);
        MOFID result = e.getValue();
        e.dispose();
        return result;
    }

    protected class SinglevaluedIterator
    implements Iterator {
        private Iterator innerIt;
        private boolean isKey;
        private TransientIndex.Entry top;
        private TransientIndex.Entry last;

        public SinglevaluedIterator(boolean isKey) {
            this.innerIt = TransientSinglevaluedIndex.this.map.values().iterator();
            this.isKey = isKey;
        }

        public boolean hasNext() {
            while (this.top == null) {
                if (!this.innerIt.hasNext()) {
                    return false;
                }
                this.top = (TransientIndex.Entry)this.innerIt.next();
                if (this.top.isValid()) continue;
                this.top.dispose();
                this.top = null;
                this.innerIt.remove();
            }
            return true;
        }

        public Object next() {
            while (this.top == null) {
                this.top = (TransientIndex.Entry)this.innerIt.next();
                if (this.top.isValid()) continue;
                this.top.dispose();
                this.top = null;
                this.innerIt.remove();
            }
            this.last = this.top;
            this.top = null;
            if (this.isKey) {
                return this.last.getKey();
            }
            return this.last.getValue();
        }

        public void remove() {
            if (this.last != null) {
                this.innerIt.remove();
                try {
                    TransientSinglevaluedIndex.this.handleRemove(this.last.getKey(), this.last);
                }
                catch (StorageException se) {
                    Logger.getDefault().notify(1, (Throwable)se);
                }
            } else {
                throw new IllegalStateException();
            }
            this.last = null;
        }
    }

    protected class ValuesCollection
    implements Collection {
        protected ValuesCollection() {
        }

        public boolean add(Object obj) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            Iterator it = TransientSinglevaluedIndex.this.map.values().iterator();
            while (it.hasNext()) {
                TransientIndex.Entry entry = (TransientIndex.Entry)it.next();
                it.remove();
                try {
                    TransientSinglevaluedIndex.this.handleRemove(entry.getKey(), entry);
                }
                catch (StorageException se) {
                    Logger.getDefault().notify(1, (Throwable)se);
                }
            }
        }

        public boolean contains(Object obj) {
            Iterator it = TransientSinglevaluedIndex.this.map.values().iterator();
            while (it.hasNext()) {
                TransientIndex.Entry entry = (TransientIndex.Entry)it.next();
                MOFID value = entry.getValue();
                if (value == null) {
                    it.remove();
                    entry.dispose();
                    continue;
                }
                if (!((Object)value).equals(obj)) continue;
                return true;
            }
            return false;
        }

        public boolean containsAll(Collection collection) {
            boolean result = true;
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                result &= this.contains(it.next());
            }
            return result;
        }

        public boolean isEmpty() {
            TransientSinglevaluedIndex.this.expungeStaleEntries();
            return TransientSinglevaluedIndex.this.map.size() == 0;
        }

        public Iterator iterator() {
            return new SinglevaluedIterator(false);
        }

        public boolean remove(Object obj) {
            try {
                return TransientSinglevaluedIndex.this.remove(obj);
            }
            catch (StorageException se) {
                throw new DebugException(se.toString());
            }
        }

        public boolean removeAll(Collection collection) {
            boolean result = false;
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                result |= this.remove(it.next());
            }
            return result;
        }

        public boolean retainAll(Collection collection) {
            boolean result = false;
            Iterator it = TransientSinglevaluedIndex.this.map.values().iterator();
            while (it.hasNext()) {
                TransientIndex.Entry entry = (TransientIndex.Entry)it.next();
                if (!entry.isValid()) {
                    it.remove();
                    entry.dispose();
                    continue;
                }
                if (collection.contains(entry.getValue())) continue;
                it.remove();
                try {
                    TransientSinglevaluedIndex.this.handleRemove(entry.getKey(), entry);
                    result = true;
                }
                catch (StorageException se) {
                    Logger.getDefault().notify(1, (Throwable)se);
                }
            }
            return result;
        }

        public int size() {
            TransientSinglevaluedIndex.this.expungeStaleEntries();
            return TransientSinglevaluedIndex.this.map.size();
        }

        public Object[] toArray() {
            ArrayList result = this.collectValues();
            return result.toArray();
        }

        public Object[] toArray(Object[] obj) {
            ArrayList result = this.collectValues();
            return result.toArray(obj);
        }

        public ArrayList collectValues() {
            ArrayList<MOFID> result = new ArrayList<MOFID>();
            Iterator it = TransientSinglevaluedIndex.this.map.values().iterator();
            while (it.hasNext()) {
                TransientIndex.Entry entry = (TransientIndex.Entry)it.next();
                if (!entry.isValid()) {
                    it.remove();
                    entry.dispose();
                    continue;
                }
                result.add(entry.getValue());
            }
            return result;
        }
    }

    protected class SinglevaluedEntryKeySet
    extends TransientIndex.EntryKeySet {
        protected SinglevaluedEntryKeySet() {
        }

        protected ArrayList collectKeys() {
            ArrayList<MOFID> result = new ArrayList<MOFID>();
            for (TransientIndex.Entry entry : TransientSinglevaluedIndex.this.map.values()) {
                if (!entry.isValid()) continue;
                result.add(entry.getKey());
            }
            return result;
        }

        public Iterator iterator() {
            return new SinglevaluedIterator(true);
        }
    }
}

