/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPage;

public class CachedPageInputStream
extends InputStream {
    private PageDescriptor first;
    private PageDescriptor last;
    private PageDescriptor currentPage;
    private int currentOffset;
    private PageDescriptor markedPage;
    private int markedOffset;

    public void addPage(CachedPage pg, int offst, int len) {
        PageDescriptor newPage = new PageDescriptor(pg, offst, len);
        if (this.first == null) {
            this.currentPage = this.first = (this.last = newPage);
            this.currentOffset = offst;
        } else {
            this.last.next = newPage;
            this.last = newPage;
        }
    }

    public void close() throws IOException {
        try {
            this.unpinAll();
        }
        catch (StorageException ex) {
            StreamCorruptedException newEx = new StreamCorruptedException(ex.getMessage());
            throw newEx;
        }
        finally {
            this.currentPage = null;
            this.last = null;
            this.first = null;
            this.currentOffset = 0;
            super.close();
        }
    }

    public int read() {
        while (this.currentPage != null) {
            if (this.currentOffset < this.currentPage.end) {
                byte val = this.currentPage.page.contents[this.currentOffset++];
                return val & 0xFF;
            }
            this.currentPage = this.currentPage.next;
            if (this.currentPage == null) continue;
            this.currentOffset = this.currentPage.start;
        }
        return -1;
    }

    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int offset, int length) {
        int toCopy = length;
        int byteOffset = offset;
        while (this.currentPage != null) {
            int left = this.currentPage.end - this.currentOffset;
            if (left > 0) {
                int size = Math.min(left, toCopy);
                System.arraycopy(this.currentPage.page.contents, this.currentOffset, b, byteOffset, size);
                this.currentOffset += size;
                byteOffset += size;
                if ((toCopy -= size) != 0) continue;
                return length;
            }
            this.currentPage = this.currentPage.next;
            if (this.currentPage == null) continue;
            this.currentOffset = this.currentPage.start;
        }
        return toCopy == length ? -1 : length - toCopy;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readlimit) {
        this.markedPage = this.currentPage;
        this.markedOffset = this.currentOffset;
    }

    public int available() {
        if (this.currentPage == null) {
            return 0;
        }
        int total = this.currentPage.end - this.currentOffset;
        PageDescriptor p = this.currentPage.next;
        while (p != null) {
            total += p.end - p.start;
            p = p.next;
        }
        return total;
    }

    public void reset() {
        if (this.markedPage != null) {
            this.currentPage = this.markedPage;
            this.currentOffset = this.markedOffset;
        } else {
            this.currentPage = this.first;
            this.currentOffset = this.first != null ? this.first.start : 0;
        }
    }

    protected void finalize() throws StorageException {
        this.unpinAll();
    }

    private void unpinAll() throws StorageException {
        PageDescriptor p = this.first;
        while (p != null) {
            p.page.unpin();
            p = p.next;
        }
    }

    static class PageDescriptor {
        CachedPage page;
        int start;
        int end;
        PageDescriptor next;

        public PageDescriptor(CachedPage pg, int offset, int length) {
            this.page = pg;
            this.start = offset;
            this.end = offset + length;
        }
    }
}

