/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.netbeans.mdr.persistence.RuntimeStorageException;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.StoragePersistentDataException;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.MofidGenerator;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.ActiveBtreeExtent;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeExtent;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeStorage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPageInputStream;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.ContinuationBtreeExtent;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.Converter;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.DeletedBtreeExtent;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileCache;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileHeader;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.IntHolder;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.NormalBtreeExtent;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.UUID;

class BtreeDataFile
implements FileCache.NotifyOnCommit,
MofidGenerator {
    static final int BTREE_CHUNK_SIZE = 32;
    static final int BTREE_VERSION = 101;
    static final int BTREE_HEADER_SIZE = 2048;
    static final int MAX_CHUNKS_IN_EXTENT = 256;
    static final int MAX_BYTES_IN_EXTENT = 8192;
    private static final int MAGIC = -17973521;
    private FileCache cache;
    private int fileIndex;
    private int pageSize;
    private int chunksPerPage;
    private int magic;
    private int version;
    private String UUID;
    private long counter;
    private FileHeader fileHeader;
    private int eof;
    private int[] deletedExtents;
    private boolean dirty = false;
    private int numberOfObjects;
    int modificationLevel;
    private byte[] mofid = new byte[8];
    private BtreeStorage storage;
    public static final int DUMP_HEADER = 1;
    public static final int DUMP_DELETED_CHAINS = 2;
    public static final int DUMP_ACTIVE_CHAINS = 4;
    public static final int DUMP_EXTENT_HEADERS = 8;
    public static final int DUMP_CONSISTENTCY_INFO = 16;
    public static final int ITERATE_ALL_EXTENTS = 0;
    public static final int ITERATE_NORMAL_EXTENTS = 1;
    public static final int ITERATE_KEYS = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BtreeDataFile(BtreeStorage storage, FileCache theCache, int index) throws StorageException {
        this.storage = storage;
        this.cache = theCache;
        this.cache.addNotifier(this);
        this.fileIndex = index;
        this.pageSize = this.cache.getPageSize();
        BtreeDataFile.checkFit(this.pageSize);
        this.chunksPerPage = this.pageSize / 32;
        this.fileHeader = null;
        this.deletedExtents = new int[256];
        IntHolder offset = new IntHolder();
        CachedPage page = this.getChunk(0, offset);
        try {
            offset.setValue(offset.getValue() + 64);
            this.magic = Converter.readInt(page.contents, offset);
            this.eof = Converter.readInt(page.contents, offset);
            this.version = Converter.readInt(page.contents, offset);
            this.UUID = Converter.readString(page.contents, offset);
            if (this.magic != -17973521) {
                throw new StoragePersistentDataException("Bad magic number in data file");
            }
            if (this.version != 101) {
                throw new StoragePersistentDataException("Bad version number in data file");
            }
            for (int i = 0; i < 256; ++i) {
                this.deletedExtents[i] = Converter.readInt(page.contents, offset);
            }
            this.numberOfObjects = Converter.readInt(page.contents, offset);
            this.counter = Converter.readLong(page.contents, offset);
        }
        finally {
            page.unpin();
        }
        this.dirty = false;
    }

    private BtreeDataFile(BtreeStorage storage, FileHeader hdr, int vers) {
        this.storage = storage;
        this.magic = -17973521;
        this.version = vers;
        this.eof = 64;
        this.UUID = storage.storageUUID != null ? storage.storageUUID : new UUID().toString();
        this.counter = this.initialMofIdConter();
        this.fileHeader = hdr;
        this.deletedExtents = new int[256];
        this.cache = null;
        this.fileIndex = -1;
        this.pageSize = 0;
        this.chunksPerPage = 0;
    }

    static void create(BtreeStorage storage, String fileName, FileHeader hdr, int pgSize, boolean replace) throws StorageException {
        BtreeDataFile.checkFit(pgSize);
        File old = new File(fileName);
        if (old.exists()) {
            if (replace) {
                old.delete();
            } else {
                throw new StorageBadRequestException(MessageFormat.format("File {0} exists", fileName));
            }
        }
        BtreeDataFile dummy = new BtreeDataFile(storage, hdr, 101);
        byte[] buffer = new byte[pgSize];
        dummy.writeHeader(buffer, true);
        try {
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            file.write(buffer);
            file.close();
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    synchronized CachedPageInputStream get(int chunkNum, long key) throws StorageException {
        Converter.writeLong(this.mofid, 0, key);
        return this.get(chunkNum, this.mofid);
    }

    synchronized CachedPageInputStream get(int chunkNum, byte[] key) throws StorageException {
        return this.getStream(this.checkRecord(chunkNum, key));
    }

    private CachedPageInputStream getStream(NormalBtreeExtent ext) throws StorageException {
        CachedPageInputStream strm = new CachedPageInputStream();
        ext.addToStream(strm);
        int next = ext.getNext();
        while (next != 0) {
            ContinuationBtreeExtent cext = (ContinuationBtreeExtent)this.getExtent(next);
            cext.addToStream(strm);
            next = cext.getNext();
        }
        return strm;
    }

    synchronized int put(long key, byte[] record) throws StorageException {
        Converter.writeLong(this.mofid, 0, key);
        return this.put(this.mofid, record);
    }

    synchronized int put(byte[] key, byte[] record) throws StorageException {
        int toAllocate;
        NormalBtreeExtent first;
        ++this.modificationLevel;
        ActiveBtreeExtent previous = first = this.getNormalExtent(record.length, key, null);
        first.writeData(record, 0);
        int offset = first.getMyDataLength();
        if (toAllocate > 0) {
            int written;
            for (toAllocate = record.length - offset; toAllocate > 0; toAllocate -= written) {
                ContinuationBtreeExtent cext = this.getContinuationExtent(toAllocate, null);
                cext.writeData(record, offset);
                previous.setNext(cext);
                previous.writeHeader();
                previous = cext;
                written = cext.getMyDataLength();
                offset += written;
            }
        }
        previous.setNext(0);
        previous.writeHeader();
        ++this.numberOfObjects;
        return first.getOffset();
    }

    synchronized int replace(int chunkNum, long key, byte[] record) throws StorageException {
        Converter.writeLong(this.mofid, 0, key);
        return this.replace(chunkNum, this.mofid, record);
    }

    synchronized int replace(int chunkNum, byte[] key, byte[] record) throws StorageException {
        int toAllocate;
        NormalBtreeExtent first;
        ++this.modificationLevel;
        NormalBtreeExtent exist = this.checkRecord(chunkNum, key);
        ArrayList<ContinuationBtreeExtent> conts = null;
        int next = exist.getNext();
        if (next > 0) {
            conts = new ArrayList<ContinuationBtreeExtent>();
            while (next > 0) {
                ContinuationBtreeExtent ext = (ContinuationBtreeExtent)this.getExtent(next);
                conts.add(ext);
                next = ext.getNext();
            }
        }
        ActiveBtreeExtent previous = first = this.getNormalExtent(record.length, key, exist);
        first.writeData(record, 0);
        if (exist != first) {
            DeletedBtreeExtent dext = new DeletedBtreeExtent(exist);
            dext.writeHeader();
        }
        int offset = first.getMyDataLength();
        int contIndex = 0;
        if (toAllocate > 0) {
            int written;
            for (toAllocate = record.length - offset; toAllocate > 0; toAllocate -= written) {
                ContinuationBtreeExtent cext;
                ContinuationBtreeExtent candidate = null;
                if (conts != null && contIndex < conts.size()) {
                    candidate = (ContinuationBtreeExtent)conts.get(contIndex);
                }
                if ((cext = this.getContinuationExtent(toAllocate, candidate)) == candidate) {
                    ++contIndex;
                }
                cext.writeData(record, offset);
                previous.setNext(cext);
                previous.writeHeader();
                previous = cext;
                written = cext.getMyDataLength();
                offset += written;
            }
        }
        if (conts != null) {
            for (int i = contIndex; i < conts.size(); ++i) {
                DeletedBtreeExtent dext = new DeletedBtreeExtent((ContinuationBtreeExtent)conts.get(i));
                dext.writeHeader();
            }
        }
        previous.setNext(0);
        previous.writeHeader();
        return first.getOffset();
    }

    synchronized void remove(int chunkNum, long id) throws StorageException {
        Converter.writeLong(this.mofid, 0, id);
        this.remove(chunkNum, this.mofid);
    }

    synchronized void remove(int chunkNum, byte[] key) throws StorageException {
        ++this.modificationLevel;
        NormalBtreeExtent ext = this.checkRecord(chunkNum, key);
        DeletedBtreeExtent dext = new DeletedBtreeExtent(ext);
        dext.writeHeader();
        int next = ext.getNext();
        while (next != 0) {
            ContinuationBtreeExtent cex = (ContinuationBtreeExtent)this.getExtent(next);
            DeletedBtreeExtent dex = new DeletedBtreeExtent(cex);
            dex.writeHeader();
            next = cex.getNext();
        }
        --this.numberOfObjects;
    }

    int getPageSize() {
        return this.pageSize;
    }

    int size() {
        return this.numberOfObjects;
    }

    void deleteExtent(DeletedBtreeExtent extent) {
        int size = extent.getSize();
        extent.setNext(this.deletedExtents[size - 1]);
        this.deletedExtents[size - 1] = extent.getOffset();
        this.dirty = true;
    }

    private int computeMaxExtentSize(int numChunks) {
        int extra = Math.min((int)((double)numChunks * 0.2), 3);
        return Math.min(numChunks + extra, 256);
    }

    private DeletedBtreeExtent getDeletedExtent(int numChunks) throws StorageException {
        for (int i = numChunks; i <= this.computeMaxExtentSize(numChunks); ++i) {
            if (this.deletedExtents[i - 1] <= 0) continue;
            DeletedBtreeExtent ext = (DeletedBtreeExtent)this.getExtent(this.deletedExtents[i - 1]);
            this.deletedExtents[i - 1] = ext.getNext();
            this.dirty = true;
            return ext;
        }
        return null;
    }

    CachedPage getChunk(int chunkNum, IntHolder offset) throws StorageException {
        int pageNum = chunkNum / this.chunksPerPage;
        CachedPage page = this.cache.getPage(this.fileIndex, pageNum);
        offset.setValue(chunkNum % this.chunksPerPage * 32);
        return page;
    }

    CachedPage[] getChunks(int chunkNum, int numChunks, IntHolder offset) throws StorageException {
        int startPageNum = chunkNum / this.chunksPerPage;
        int endPageNum = (chunkNum + numChunks - 1) / this.chunksPerPage;
        CachedPage[] pages = this.cache.getPages(this.fileIndex, startPageNum, endPageNum - startPageNum + 1);
        offset.setValue(chunkNum % this.chunksPerPage * 32);
        return pages;
    }

    private BtreeExtent getExtent(int chunkNum) throws StorageException {
        return BtreeExtent.readExtent(this, chunkNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareToCommit() throws StorageException {
        if (!this.dirty) {
            return;
        }
        CachedPage page = this.cache.getPage(this.fileIndex, 0);
        try {
            page.setWritable();
            this.writeHeader(page.contents, false);
        }
        finally {
            page.unpin();
        }
    }

    public void copy(BtreeDataFile target) throws StorageException {
        Iterator iter = this.iterator(1);
        while (iter.hasNext()) {
            int read;
            NormalBtreeExtent ext = (NormalBtreeExtent)iter.next();
            CachedPageInputStream strm = this.get(ext.myChunkNum, ext.key);
            int offset = 0;
            int len = strm.available();
            byte[] data = new byte[len];
            do {
                read = strm.read(data, offset, len);
                offset += read;
            } while ((len -= read) > 0);
            target.put(ext.key, data);
        }
    }

    public synchronized long allocateObjects(int number) {
        this.counter += (long)number;
        this.dirty = true;
        return this.counter;
    }

    public String getMofidPrefix() {
        return this.UUID;
    }

    public long getNextMofid() {
        return this.allocateObjects(1);
    }

    long getMofIdCounter() {
        return this.counter;
    }

    void setMofIdCounter(long counter) {
        this.counter = counter;
        this.dirty = true;
    }

    long initialMofIdConter() {
        return 128 + this.UUID.hashCode() % 2048 + 2048;
    }

    public int dump(int level, int hdrLevel, PrintWriter strm) throws StorageException {
        return this.dump(level, hdrLevel, true, strm);
    }

    int dump(int level, int hdrLevel, boolean headAndTrail, PrintWriter strm) throws StorageException {
        int next;
        boolean doChecks;
        boolean doHeader = (level & 1) != 0;
        boolean doDelChains = (level & 2) != 0;
        boolean doActChains = (level & 4) != 0;
        boolean doExtHeaders = (level & 8) != 0;
        boolean bl = doChecks = (level & 0x10) != 0;
        if (strm == null) {
            strm = new PrintWriter(System.out);
        }
        if (headAndTrail) {
            strm.println("Btree data file dump:\n");
        }
        if (doHeader) {
            strm.println("Magic number: " + this.magic);
            strm.println("Btree version: " + this.version);
            strm.println("EOF chunk: " + this.eof);
            strm.println("" + this.numberOfObjects + " objects");
            strm.println();
        }
        if (doDelChains) {
            boolean sawDeleted = false;
            for (int i = 0; i < 256; ++i) {
                if (this.deletedExtents[i] <= 0) continue;
                if (!sawDeleted) {
                    strm.println("Deleted extents:");
                    sawDeleted = true;
                }
                strm.println("\t" + (i + 1) + " chunks:");
                next = this.deletedExtents[i];
                while (next > 0) {
                    strm.println("\t\t" + next);
                    BtreeExtent del = this.getExtent(next);
                    next = del.getNext();
                }
            }
            if (!sawDeleted) {
                strm.println("No deleted extents");
            }
            strm.println();
        }
        if (doActChains) {
            strm.println("Active chains:");
            Iterator iter = this.iterator(1);
            while (iter.hasNext()) {
                NormalBtreeExtent ext = (NormalBtreeExtent)iter.next();
                strm.println("\t" + ext.getOffset());
                next = ext.getNext();
                while (next > 0) {
                    strm.println("\t\t" + next);
                    next = this.getExtent(next).getNext();
                }
            }
            strm.println();
        }
        if (doExtHeaders) {
            strm.println("All extent headers:");
            Iterator iter = this.iterator(0);
            while (iter.hasNext()) {
                BtreeExtent ext = (BtreeExtent)iter.next();
                ext.dump(hdrLevel, strm);
                strm.println();
            }
            strm.println();
        }
        int numErrs = 0;
        if (doChecks) {
            int i;
            int WAS_SEEN = 4;
            strm.println("Consistentcy check:");
            byte[] extents = new byte[this.eof];
            Iterator iter = this.iterator(0);
            while (iter.hasNext()) {
                ActiveBtreeExtent aext;
                BtreeExtent ext = (BtreeExtent)iter.next();
                extents[ext.getOffset()] = ext.getType();
                if (!(ext instanceof ActiveBtreeExtent) || (aext = (ActiveBtreeExtent)ext).getNext() <= 0 || aext.getMyDataLength() >= aext.getAvailableDataLength()) continue;
                strm.println(aext.getTypeName() + " extent " + ext.getOffset() + " of size " + aext.getMyDataLength() + "has a successor extent");
            }
            int totalNormal = 0;
            for (i = 0; i < this.eof; ++i) {
                if ((extents[i] & 3) != 1) continue;
                ++totalNormal;
                int n = i;
                extents[n] = (byte)(extents[n] | 4);
                BtreeExtent ext = this.getExtent(i);
                int next2 = ext.getNext();
                while (next2 != 0) {
                    BtreeExtent cext = this.getExtent(next2);
                    byte type = cext.getType();
                    if (type != 2) {
                        strm.println(BtreeExtent.getTypeName(type) + " extent " + next2 + " is on active chain " + i);
                        ++numErrs;
                    } else if ((extents[next2] & 4) != 0) {
                        strm.println("extent " + next2 + " is on more than one chain");
                        ++numErrs;
                    }
                    int n2 = next2;
                    extents[n2] = (byte)(extents[n2] | 4);
                    next2 = cext.getNext();
                }
            }
            if (totalNormal != this.numberOfObjects) {
                strm.println("Repository has " + totalNormal + " normal extents, but thinks it has " + this.numberOfObjects + " objects");
                ++numErrs;
            }
            for (i = 0; i < 256; ++i) {
                int next3 = this.deletedExtents[i];
                while (next3 != 0) {
                    BtreeExtent ext = this.getExtent(next3);
                    byte type = ext.getType();
                    if (type != 3) {
                        strm.println(BtreeExtent.getTypeName(type) + " extent " + next3 + " is on deleted chain " + (i + 1));
                        ++numErrs;
                    } else {
                        int n = next3;
                        extents[n] = (byte)(extents[n] | 4);
                        int size = ext.getSize();
                        if (size != i + 1) {
                            strm.println("Deleted extent " + next3 + " of size " + size + " is on chain for size " + (i + 1));
                            ++numErrs;
                        }
                    }
                    next3 = ext.getNext();
                }
            }
            for (i = 0; i < this.eof; ++i) {
                boolean wasSeen = (extents[i] & 4) != 0;
                int type = extents[i] & 3;
                if (type <= 0 || wasSeen) continue;
                strm.println("Extent " + i + " is not on any chain");
                ++numErrs;
            }
            if (headAndTrail) {
                strm.println("" + numErrs + " error(s) detected.");
            }
            strm.println();
        }
        if (headAndTrail) {
            strm.println("End of tree data file dump\n");
        }
        strm.flush();
        return numErrs;
    }

    private NormalBtreeExtent getNormalExtent(int length, byte[] key, NormalBtreeExtent candidate) throws StorageException {
        if (candidate != null && (candidate.isMaximum() || candidate.getAvailableDataLength() >= length)) {
            candidate.setMyDataLength(length);
            return candidate;
        }
        int numChunks = NormalBtreeExtent.getNumChunks(key.length, length);
        DeletedBtreeExtent del = this.getDeletedExtent(numChunks);
        NormalBtreeExtent first = del != null ? new NormalBtreeExtent(del, key, length) : this.addNormalExtent(length, key);
        return first;
    }

    private ContinuationBtreeExtent getContinuationExtent(int length, ContinuationBtreeExtent candidate) throws StorageException {
        if (candidate != null && (candidate.isMaximum() || candidate.getAvailableDataLength() >= length)) {
            candidate.setMyDataLength(length);
            return candidate;
        }
        int nChunks = ContinuationBtreeExtent.getNumChunks(length);
        DeletedBtreeExtent dext = this.getDeletedExtent(nChunks);
        ContinuationBtreeExtent cext = dext != null ? new ContinuationBtreeExtent(dext, length) : this.addContinuationExtent(length);
        return cext;
    }

    private NormalBtreeExtent addNormalExtent(int length, byte[] key) throws StorageException {
        int numChunks = NormalBtreeExtent.getNumChunks(length, key.length);
        NormalBtreeExtent ext = new NormalBtreeExtent(this, this.eof, (short)this.computeMaxExtentSize(numChunks), length, key);
        this.eof += ext.getSize();
        this.dirty = true;
        return ext;
    }

    private ContinuationBtreeExtent addContinuationExtent(int length) {
        int numChunks = ContinuationBtreeExtent.getNumChunks(length);
        ContinuationBtreeExtent ext = new ContinuationBtreeExtent(this, this.eof, (short)this.computeMaxExtentSize(numChunks), length);
        this.eof += ext.getSize();
        this.dirty = true;
        return ext;
    }

    private void writeHeader(byte[] buffer, boolean writeFileHeader) {
        if (writeFileHeader) {
            this.fileHeader.write(buffer);
        }
        IntHolder offset = new IntHolder(64);
        Converter.writeInt(buffer, offset, this.magic);
        Converter.writeInt(buffer, offset, this.eof);
        Converter.writeInt(buffer, offset, this.version);
        Converter.writeString(buffer, offset, this.UUID);
        for (int i = 0; i < 256; ++i) {
            Converter.writeInt(buffer, offset, this.deletedExtents[i]);
        }
        Converter.writeInt(buffer, offset, this.numberOfObjects);
        Converter.writeLong(buffer, offset, this.counter);
    }

    private NormalBtreeExtent checkRecord(int chunkNum, byte[] key) throws StorageException {
        BtreeExtent ext = this.getExtent(chunkNum);
        if (!(ext instanceof NormalBtreeExtent)) {
            throw new StoragePersistentDataException(MessageFormat.format("Not a normal extent at offset {0}", new Integer(chunkNum)));
        }
        NormalBtreeExtent norm = (NormalBtreeExtent)ext;
        if (!Arrays.equals(key, norm.key)) {
            throw new StorageBadRequestException(MessageFormat.format("Incorrect key at offset {0}", new Integer(chunkNum)));
        }
        return norm;
    }

    private static void checkFit(int pageSz) throws StorageException {
        String msg = null;
        if (pageSz % 32 != 0) {
            msg = "File cache page size is not an even number of chunks";
        }
        if (msg != null) {
            throw new StorageBadRequestException(msg);
        }
    }

    Iterator iterator(int type) {
        return new BtreeDataFileIterator(type);
    }

    class BtreeDataFileIterator
    implements Iterator {
        private int iterModLevel;
        private BtreeExtent iterCurExtent;
        private int iterType;

        BtreeDataFileIterator(int type) {
            this.iterType = type;
            this.iterCurExtent = null;
            this.findNextExtent(true);
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported");
        }

        public boolean hasNext() {
            return this.iterCurExtent != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            BtreeDataFile btreeDataFile = BtreeDataFile.this;
            synchronized (btreeDataFile) {
                Object retval;
                this.checkModLevel();
                BtreeExtent ext = this.iterCurExtent;
                if (ext == null) {
                    throw new NoSuchElementException("At EOF");
                }
                this.findNextExtent(false);
                switch (this.iterType) {
                    case 2: {
                        try {
                            retval = BtreeDataFile.this.storage.readMOFIDData(new ByteArrayInputStream(((NormalBtreeExtent)ext).key));
                            break;
                        }
                        catch (StorageException ex) {
                            throw new RuntimeStorageException(ex);
                        }
                    }
                    default: {
                        retval = ext;
                    }
                }
                return retval;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void findNextExtent(boolean atStart) {
            BtreeDataFile btreeDataFile = BtreeDataFile.this;
            synchronized (btreeDataFile) {
                boolean allExtents;
                int offset;
                if (atStart) {
                    this.iterModLevel = BtreeDataFile.this.modificationLevel;
                    offset = 64;
                } else if (this.iterCurExtent != null) {
                    offset = this.iterCurExtent.getOffset() + this.iterCurExtent.getSize();
                } else {
                    return;
                }
                this.checkModLevel();
                boolean bl = allExtents = this.iterType == 0;
                while (offset < BtreeDataFile.this.eof) {
                    BtreeExtent ext;
                    try {
                        ext = BtreeDataFile.this.getExtent(offset);
                    }
                    catch (StorageException ex) {
                        throw new RuntimeStorageException(ex);
                    }
                    if (allExtents || ext instanceof NormalBtreeExtent) {
                        this.iterCurExtent = ext;
                        return;
                    }
                    offset += ext.getSize();
                }
                this.iterCurExtent = null;
            }
        }

        private void checkModLevel() {
            if (this.iterModLevel != BtreeDataFile.this.modificationLevel) {
                throw new ConcurrentModificationException("Data file had been modified");
            }
        }
    }
}

