/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.handlers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.RefStruct;
import javax.jmi.reflect.TypeMismatchException;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.handlers.MDRClassLoader;
import org.netbeans.mdr.handlers.StructGenerator;
import org.netbeans.mdr.storagemodel.DatatypeDescriptor;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.ImplClass;
import org.netbeans.mdr.util.Logger;

public abstract class StructImpl
extends ImplClass
implements RefStruct {
    private final List fields;
    private final Map values;
    private final List qualifiedName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class getStructClass(MDRClassLoader loader, Class ifc) throws IllegalArgumentException {
        StructImpl.check(loader, ifc);
        Map cache = StructImpl.getLoaderCache(loader);
        String className = StructImpl.getName(ifc);
        Class result = StructImpl.getFromCache(cache, ifc, className);
        if (result == null) {
            try {
                byte[] structClassFile = StructGenerator.generateStruct(className, ifc);
                result = loader.defineClass(className, structClassFile);
            }
            finally {
                StructImpl.releaseCache(cache, result, className);
            }
        }
        return result;
    }

    public static RefStruct newInstance(DatatypeDescriptor dataType, Object[] fieldValues) {
        try {
            HashMap values = new HashMap(fieldValues.length, 1.0f);
            int i = 0;
            Iterator types = dataType.getMemberTypes().iterator();
            Iterator it = dataType.getMembers().iterator();
            while (it.hasNext()) {
                Class type = (Class)types.next();
                if (fieldValues[i] != null && !type.isInstance(fieldValues[i])) {
                    throw new TypeMismatchException(type, fieldValues[i], null);
                }
                values.put(it.next(), fieldValues[i]);
                ++i;
            }
            return StructImpl.newInstance(BaseObjectHandler.resolveInterface(dataType.getIfcName()), dataType.getMembers(), values, dataType.getTypeName());
        }
        catch (ClassNotFoundException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    public static RefStruct newInstance(Class ifc, List fields, Map values, List qualifiedName) {
        MDRClassLoader loader = BaseObjectHandler.getDefaultClassLoader();
        Class cl = StructImpl.getStructClass(loader, ifc);
        try {
            Constructor cons = cl.getConstructor(List.class, Map.class, List.class);
            RefStruct struct = (RefStruct)cons.newInstance(fields, values, qualifiedName);
            return struct;
        }
        catch (NoSuchMethodException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    protected StructImpl(List fields, Map values, List qualifiedName) {
        this.values = values;
        this.qualifiedName = Collections.unmodifiableList(qualifiedName);
        this.fields = Collections.unmodifiableList(fields);
    }

    protected Object handleGet(String memberName) {
        return this.refGetValue(memberName);
    }

    public Object refGetValue(String memberName) {
        if (this.values.containsKey(memberName)) {
            return this.values.get(memberName);
        }
        throw new DebugException("Wrong item name: " + memberName);
    }

    public List refFieldNames() {
        return this.fields;
    }

    public List refTypeName() {
        return this.qualifiedName;
    }

    public int hashCode() {
        return ((Object)this.qualifiedName).hashCode() * 37 + ((Object)this.values).hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof RefStruct && ((Object)((RefStruct)other).refTypeName()).equals(this.qualifiedName)) {
            for (Object key : this.values.keySet()) {
                Object value = this.values.get(key);
                if (!(value == null ? ((RefStruct)other).refGetValue((String)key) != null : !value.equals(((RefStruct)other).refGetValue((String)key)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

