/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;

class CategorySelector
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager explorerManager = new ExplorerManager();

    CategorySelector() {
        this.explorerManager.setRootContext(this.getCategoryRootNode());
        ListView listView = new ListView();
        JScrollPane scrollPane = new JScrollPane();
        listView.setBorder(scrollPane.getBorder());
        listView.getAccessibleContext().setAccessibleDescription(PaletteUtils.getBundleString("ACSD_CTL_PaletteCategories"));
        listView.setPopupAllowed(false);
        listView.setTraversalAllowed(false);
        JLabel categoryLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)categoryLabel, (String)PaletteUtils.getBundleString("CTL_PaletteCategories"));
        categoryLabel.setLabelFor((Component)listView);
        this.getAccessibleContext().setAccessibleDescription(PaletteUtils.getBundleString("ACSD_PaletteCategoriesSelector"));
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)categoryLabel, "North");
        this.add((Component)listView, "Center");
    }

    private Node getCategoryRootNode() {
        AbstractNode root = new AbstractNode((Children)new Children.Array());
        Node[] paleteCategories = PaletteUtils.getCategoryNodes(PaletteUtils.getPaletteNode(), false);
        Node[] categoryNodes = new Node[paleteCategories.length];
        for (int i = 0; i < paleteCategories.length; ++i) {
            categoryNodes[i] = new FilterNode(paleteCategories[i], Children.LEAF);
        }
        root.getChildren().add(categoryNodes);
        this.getExplorerManager().setRootContext((Node)root);
        return root;
    }

    public static String selectCategory() {
        CategorySelector selector = new CategorySelector();
        selector.setBorder(new EmptyBorder(12, 12, 0, 11));
        DialogDescriptor dd = new DialogDescriptor((Object)selector, PaletteUtils.getBundleString("CTL_SelectCategory_Title"), true, null);
        DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
        return dd.getValue() == DialogDescriptor.OK_OPTION ? selector.getSelectedCategory() : null;
    }

    String getSelectedCategory() {
        Node[] selected = this.explorerManager.getSelectedNodes();
        return selected.length == 1 ? selected[0].getName() : null;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 300);
    }
}

