/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.swing.JComponent;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.delegates.AbsoluteLayoutSupport;
import org.openide.util.Utilities;

public class NullLayoutSupport
extends AbsoluteLayoutSupport {
    private static Method setBoundsMethod;
    private static String iconURL;
    private static String icon32URL;

    public Class getSupportedClass() {
        return null;
    }

    public Image getIcon(int type) {
        switch (type) {
            case 1: 
            case 3: {
                return Utilities.loadImage((String)iconURL);
            }
        }
        return Utilities.loadImage((String)icon32URL);
    }

    public CodeGroup getComponentCode(int index) {
        LayoutConstraints constr = this.getConstraints(index);
        if (constr instanceof AbsoluteLayoutSupport.AbsoluteLayoutConstraints) {
            AbsoluteLayoutSupport.AbsoluteLayoutConstraints absConstr = (AbsoluteLayoutSupport.AbsoluteLayoutConstraints)constr;
            if (absConstr.refComponent == null) {
                absConstr.refComponent = this.getLayoutContext().getPrimaryComponent(index);
            }
        }
        return super.getComponentCode(index);
    }

    public void setLayoutToContainer(Container container, Container containerDelegate) {
        containerDelegate.setLayout(null);
    }

    public void addComponentsToContainer(Container container, Container containerDelegate, Component[] components, int index) {
        for (int i = 0; i < components.length; ++i) {
            LayoutConstraints constr = this.getConstraints(i + index);
            if (!(constr instanceof AbsoluteLayoutSupport.AbsoluteLayoutConstraints)) continue;
            AbsoluteLayoutSupport.AbsoluteLayoutConstraints alc = (AbsoluteLayoutSupport.AbsoluteLayoutConstraints)constr;
            Component comp = components[i];
            Rectangle bounds = alc.getBounds();
            if (bounds.width == -1 || bounds.height == -1) {
                Dimension pref;
                Dimension dimension = pref = !(comp instanceof JComponent) && alc.refComponent != null ? alc.refComponent.getPreferredSize() : comp.getPreferredSize();
                if (bounds.width == -1) {
                    bounds.width = pref.width;
                }
                if (bounds.height == -1) {
                    bounds.height = pref.height;
                }
            }
            containerDelegate.add(comp, i + index);
            comp.setBounds(bounds);
        }
    }

    protected CodeExpression createInitLayoutCode(CodeGroup layoutCode) {
        return this.getCodeStructure().createNullExpression(LayoutManager.class);
    }

    protected CodeExpression readComponentCode(CodeStatement statement, CodeGroup componentCode) {
        if (NullLayoutSupport.getSimpleAddMethod().equals(statement.getMetaObject())) {
            CodeExpression compExp = statement.getStatementParameters()[0];
            componentCode.addStatement(statement);
            AbsoluteLayoutSupport.AbsoluteLayoutConstraints constr = new AbsoluteLayoutSupport.AbsoluteLayoutConstraints(0, 0, -1, -1);
            constr.nullMode = true;
            Iterator it = CodeStructure.getDefinedStatementsIterator(compExp);
            CodeStatement[] statements = CodeStructure.filterStatements(it, NullLayoutSupport.getSetBoundsMethod());
            if (statements.length > 0) {
                CodeStatement boundsStatement = statements[statements.length - 1];
                constr.readPropertyExpressions(boundsStatement.getStatementParameters(), 0);
                componentCode.addStatement(boundsStatement);
            }
            this.getConstraintsList().add(constr);
            return compExp;
        }
        return null;
    }

    protected void createComponentCode(CodeGroup componentCode, CodeExpression compExp, int index) {
        componentCode.addStatement(CodeStructure.createStatement(this.getActiveContainerCodeExpression(), NullLayoutSupport.getSimpleAddMethod(), new CodeExpression[]{compExp}));
        LayoutConstraints constr = this.getConstraints(index);
        if (constr instanceof AbsoluteLayoutSupport.AbsoluteLayoutConstraints) {
            AbsoluteLayoutSupport.AbsoluteLayoutConstraints absConstr = (AbsoluteLayoutSupport.AbsoluteLayoutConstraints)constr;
            absConstr.nullMode = true;
            absConstr.refComponent = this.getLayoutContext().getPrimaryComponent(index);
            componentCode.addStatement(CodeStructure.createStatement(compExp, NullLayoutSupport.getSetBoundsMethod(), absConstr.createPropertyExpressions(this.getCodeStructure(), 0)));
        }
    }

    private static Method getSetBoundsMethod() {
        if (setBoundsMethod == null) {
            try {
                setBoundsMethod = Component.class.getMethod("setBounds", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
        }
        return setBoundsMethod;
    }

    static {
        iconURL = "org/netbeans/modules/form/layoutsupport/resources/NullLayout.gif";
        icon32URL = "org/netbeans/modules/form/layoutsupport/resources/NullLayout32.gif";
    }
}

