/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.fakepeer;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.net.URL;
import org.netbeans.modules.form.fakepeer.FakeComponentPeer;
import org.netbeans.modules.form.fakepeer.FakePeerUtils;

class FakeCheckboxPeer
extends FakeComponentPeer {
    private static final int BOX_W = 16;
    private static final int BOX_H = 16;
    private static final int[] drCheckPosX_W = new int[]{4, 6, 10, 10, 6, 4, 4, 6, 10};
    private static final int[] drCheckPosY_W = new int[]{6, 8, 4, 5, 9, 7, 8, 10, 6};
    private static Image radButtIcon1 = null;
    private static Image radButtIcon2 = null;

    FakeCheckboxPeer(Checkbox target) {
        super(target);
    }

    Component createDelegate() {
        return new Delegate();
    }

    public void setState(boolean state) {
    }

    public void setCheckboxGroup(CheckboxGroup g) {
    }

    public void setLabel(String label) {
    }

    private class Delegate
    extends Component {
        Delegate() {
            this.setForeground(SystemColor.controlText);
        }

        public void paint(Graphics g) {
            Checkbox target = (Checkbox)FakeCheckboxPeer.this._target;
            Dimension sz = target.getSize();
            int bx = 0;
            int by = (sz.height - 16) / 2;
            g.setColor(target.getBackground());
            g.fillRect(0, 0, sz.width, sz.height);
            String label = target.getLabel();
            if (label != null) {
                g.setFont(target.getFont());
                FontMetrics fm = g.getFontMetrics();
                int h = fm.getHeight() - fm.getDescent();
                int x = 18;
                int y = (sz.height - h) / 2 + h - 2;
                if (target.isEnabled()) {
                    g.setColor(target.getForeground());
                } else {
                    g.setColor(SystemColor.controlLtHighlight);
                    g.drawString(label, x + 1, y + 1);
                    g.setColor(SystemColor.controlShadow);
                }
                g.drawString(label, x, y);
                by = y - h + 2;
            }
            if (target.getCheckboxGroup() == null) {
                g.setColor(SystemColor.window);
                FakePeerUtils.drawLoweredBox(g, bx, by, 16, 16);
                if (target.getState()) {
                    g.setColor(SystemColor.controlText);
                    for (int i = 1; i < drCheckPosX_W.length; ++i) {
                        g.drawLine(drCheckPosX_W[i - 1] + bx, drCheckPosY_W[i - 1] + by, drCheckPosX_W[i] + bx, drCheckPosY_W[i] + by);
                    }
                }
            } else {
                if (radButtIcon1 == null || radButtIcon2 == null) {
                    this.initRBImages();
                }
                g.drawImage(target.getState() ? radButtIcon2 : radButtIcon1, bx + 1, by + 1, this);
            }
        }

        public Dimension getMinimumSize() {
            String label = ((Checkbox)FakeCheckboxPeer.this._target).getLabel();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int w = fm.stringWidth(label);
            int h = fm.getHeight();
            return new Dimension(w + 6 + 16 + 4, h + 4);
        }

        void initRBImages() {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            URL source = this.getClass().getResource("radbutt1.gif");
            radButtIcon1 = toolkit.getImage(source);
            source = this.getClass().getResource("radbutt2.gif");
            radButtIcon2 = toolkit.getImage(source);
            MediaTracker mt = new MediaTracker(this);
            mt.addImage(radButtIcon1, 0);
            mt.addImage(radButtIcon2, 1);
            try {
                mt.waitForAll();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }
}

