/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class AlignAction
extends NodeAction {
    private JMenuItem[] items;
    private ActionListener menuItemListener;

    protected boolean enable(Node[] nodes) {
        List comps = FormUtils.getSelectedLayoutComponents(nodes);
        return comps != null && comps.size() > 1;
    }

    public String getName() {
        return NbBundle.getMessage(AlignAction.class, (String)"ACT_Align");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void performAction(Node[] activatedNodes) {
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        JMenu popupMenu = new JMenu(NbBundle.getMessage(AlignAction.class, (String)"ACT_Align"));
        popupMenu.setEnabled(this.isEnabled());
        HelpCtx.setHelpIDString((JComponent)popupMenu, (String)AlignAction.class.getName());
        popupMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                JMenu menu = (JMenu)e.getSource();
                AlignAction.this.createAlignSubmenu(menu);
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
        return popupMenu;
    }

    private void createAlignSubmenu(JMenu menu) {
        Node[] nodes = this.getActivatedNodes();
        List components = FormUtils.getSelectedLayoutComponents(nodes);
        if (menu.getMenuComponentCount() <= 0) {
            ResourceBundle bundle = NbBundle.getBundle(AlignAction.class);
            AlignMenuItem leftGroupItem = new AlignMenuItem(bundle.getString("CTL_GroupLeft"), components, 0);
            AlignMenuItem rightGroupItem = new AlignMenuItem(bundle.getString("CTL_GroupRight"), components, 1);
            AlignMenuItem upGroupItem = new AlignMenuItem(bundle.getString("CTL_GroupUp"), components, 2);
            AlignMenuItem downGroupItem = new AlignMenuItem(bundle.getString("CTL_GroupDown"), components, 3);
            AlignMenuItem leftItem = new AlignMenuItem(bundle.getString("CTL_AlignLeft"), components, 4);
            AlignMenuItem rightItem = new AlignMenuItem(bundle.getString("CTL_AlignRight"), components, 5);
            AlignMenuItem upItem = new AlignMenuItem(bundle.getString("CTL_AlignUp"), components, 6);
            AlignMenuItem downItem = new AlignMenuItem(bundle.getString("CTL_AlignDown"), components, 7);
            this.items = new JMenuItem[]{leftGroupItem, rightGroupItem, upGroupItem, downGroupItem, leftItem, rightItem, upItem, downItem};
            for (int i = 0; i < 8; ++i) {
                this.items[i].addActionListener(this.getMenuItemListener());
                this.items[i].setEnabled(false);
                HelpCtx.setHelpIDString((JComponent)this.items[i], (String)AlignAction.class.getName());
                menu.add(this.items[i]);
                if (i != 3) continue;
                menu.addSeparator();
            }
        }
        this.updateState(components);
    }

    private void updateState(List components) {
        if (components == null || components.size() < 2) {
            return;
        }
        RADComponent rc = (RADComponent)components.get(0);
        FormDesigner formDesigner = FormEditor.getFormDesigner(rc.getFormModel());
        for (int i = 0; i < 4; ++i) {
            Action a = (Action)formDesigner.getDesignerActions(true).toArray()[i];
            this.items[i].setEnabled(a.isEnabled());
            this.items[i + 4].setEnabled(a.isEnabled());
        }
    }

    private ActionListener getMenuItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new AlignMenuItemListener();
        }
        return this.menuItemListener;
    }

    private static class AlignMenuItemListener
    implements ActionListener {
        private AlignMenuItemListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (!(source instanceof AlignMenuItem)) {
                return;
            }
            AlignMenuItem mi = (AlignMenuItem)source;
            if (!mi.isEnabled()) {
                return;
            }
            int index = mi.getDirection();
            RADComponent radC = (RADComponent)mi.getRADComponents().get(0);
            FormModel fm = radC.getFormModel();
            FormDesigner fd = FormEditor.getFormDesigner(fm);
            ((Action)fd.getDesignerActions(false).toArray()[index]).actionPerformed(evt);
        }
    }

    private static class AlignMenuItem
    extends JMenuItem {
        private int direction;
        private List components;

        AlignMenuItem(String text, List components, int direction) {
            super(text);
            this.components = components;
            this.direction = direction;
        }

        int getDirection() {
            return this.direction;
        }

        List getRADComponents() {
            return this.components;
        }
    }
}

