/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JScrollPane;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.CopySupport;
import org.netbeans.modules.form.DefaultRADAction;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyCookie;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.InPlaceEditLayer;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentCookie;
import org.netbeans.modules.form.RADMenuComponent;
import org.netbeans.modules.form.RADMenuItemComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.actions.AddAction;
import org.netbeans.modules.form.actions.AlignAction;
import org.netbeans.modules.form.actions.ChooseSameSizeAction;
import org.netbeans.modules.form.actions.CustomizeEmptySpaceAction;
import org.netbeans.modules.form.actions.CustomizeLayoutAction;
import org.netbeans.modules.form.actions.DefaultSizeAction;
import org.netbeans.modules.form.actions.EditContainerAction;
import org.netbeans.modules.form.actions.EditFormAction;
import org.netbeans.modules.form.actions.EventsAction;
import org.netbeans.modules.form.actions.InPlaceEditAction;
import org.netbeans.modules.form.actions.PropertyAction;
import org.netbeans.modules.form.actions.SelectLayoutAction;
import org.netbeans.modules.form.actions.SetAnchoringAction;
import org.netbeans.modules.form.actions.SetResizabilityAction;
import org.netbeans.modules.form.actions.TestAction;
import org.netbeans.modules.form.layoutsupport.LayoutNode;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.ErrorManager;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.MoveDownAction;
import org.openide.actions.MoveUpAction;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ReorderAction;
import org.openide.explorer.propertysheet.editors.NodeCustomizer;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;

public class RADComponentNode
extends FormNode
implements RADComponentCookie,
FormPropertyCookie {
    private static final MessageFormat nodeNameFormat = new MessageFormat(FormUtils.getBundleString("FMT_ComponentNodeName"));
    private static final MessageFormat nodeNoNameFormat = new MessageFormat(FormUtils.getBundleString("FMT_UnnamedComponentNodeName"));
    private RADComponent component;
    private Action[] actions;
    private boolean highlightDisplayName;

    public RADComponentNode(RADComponent component) {
        this((Children)(component instanceof ComponentContainer ? new RADChildren((ComponentContainer)((Object)component)) : Children.LEAF), component);
    }

    public RADComponentNode(Children children, RADComponent component) {
        super(children, component.getFormModel());
        this.component = component;
        component.setNodeReference(this);
        if (component instanceof ComponentContainer) {
            this.getCookieSet().add((Node.Cookie)new ComponentsIndex());
        }
        this.updateName();
    }

    void updateName() {
        String compClassName = Utilities.getShortClassName((Class)this.component.getBeanClass());
        if (this.component == this.component.getFormModel().getTopRADComponent()) {
            this.setDisplayName(nodeNoNameFormat.format(new Object[]{compClassName}));
        } else {
            this.setDisplayName(nodeNameFormat.format(new Object[]{this.getName(), compClassName}));
        }
    }

    public void fireComponentPropertiesChange() {
        this.firePropertyChange(null, null, null);
    }

    public void fireComponentPropertySetsChange() {
        this.firePropertySetsChange(null, null);
    }

    public Image getIcon(int iconType) {
        Image icon = BeanSupport.getBeanIcon(this.component.getBeanClass(), iconType);
        if (icon != null) {
            return icon;
        }
        BeanInfo bi = this.component.getBeanInfo();
        if (bi != null && (icon = bi.getIcon(iconType)) != null) {
            return icon;
        }
        return super.getIcon(iconType);
    }

    public Image getOpenedIcon(int iconType) {
        return this.getIcon(iconType);
    }

    public HelpCtx getHelpCtx() {
        HelpCtx help = HelpCtx.findHelp((Object)this.component.getBeanInstance());
        return help != null ? help : new HelpCtx("gui.component-inspector");
    }

    public Node.PropertySet[] getPropertySets() {
        return this.component.getProperties();
    }

    public NewType[] getNewTypes() {
        return this.component.getNewTypes();
    }

    public Action getPreferredAction() {
        if (this.component instanceof RADVisualContainer) {
            return SystemAction.get(EditContainerAction.class);
        }
        return SystemAction.get(DefaultRADAction.class);
    }

    public Action[] getActions(boolean context) {
        if (this.actions == null) {
            int i;
            ArrayList<Object> actions = new ArrayList<Object>(20);
            RADComponent topComp = this.component.getFormModel().getTopRADComponent();
            if (this.component.isReadOnly()) {
                if (this.component == topComp) {
                    actions.add(SystemAction.get(TestAction.class));
                    actions.add(null);
                }
                Event[] events = this.component.getKnownEvents();
                for (i = 0; i < events.length; ++i) {
                    if (!events[i].hasEventHandlers()) continue;
                    actions.add(SystemAction.get(EventsAction.class));
                    actions.add(null);
                    break;
                }
                actions.add(SystemAction.get(CopyAction.class));
            } else {
                List actionProps = this.component.getActionProperties();
                for (RADProperty prop : actionProps) {
                    PropertyAction action = new PropertyAction(prop);
                    actions.add(action);
                }
                if (InPlaceEditLayer.supportsEditingFor(this.component.getBeanClass(), false)) {
                    actions.add(SystemAction.get(InPlaceEditAction.class));
                }
                if (this.component != topComp) {
                    actions.add(SystemAction.get(ChangeVariableNameAction.class));
                }
                if (this.component == topComp) {
                    actions.add(SystemAction.get(TestAction.class));
                }
                actions.add(SystemAction.get(EventsAction.class));
                actions.add(null);
                RADComponent parent = this.component.getParentComponent();
                actions.add(SystemAction.get(AlignAction.class));
                actions.add(SystemAction.get(SetAnchoringAction.class));
                actions.add(SystemAction.get(SetResizabilityAction.class));
                actions.add(SystemAction.get(ChooseSameSizeAction.class));
                actions.add(SystemAction.get(DefaultSizeAction.class));
                actions.add(SystemAction.get(CustomizeEmptySpaceAction.class));
                actions.add(null);
                if (this.component instanceof RADVisualContainer) {
                    if (!((RADVisualContainer)this.component).hasDedicatedLayoutSupport()) {
                        actions.add(SystemAction.get(EditContainerAction.class));
                        if (topComp != null && this.component != topComp) {
                            actions.add(SystemAction.get(EditFormAction.class));
                        }
                        actions.add(SystemAction.get(SelectLayoutAction.class));
                        actions.add(SystemAction.get(CustomizeLayoutAction.class));
                    }
                    actions.add(SystemAction.get(AddAction.class));
                }
                if (this.getNewTypes().length != 0) {
                    actions.add(null);
                    actions.add(SystemAction.get(NewAction.class));
                }
                if (this.component != topComp) {
                    actions.add(SystemAction.get(MoveUpAction.class));
                    actions.add(SystemAction.get(MoveDownAction.class));
                }
                if (this.component instanceof ComponentContainer) {
                    actions.add(SystemAction.get(ReorderAction.class));
                }
                actions.add(null);
                if (this.component != topComp) {
                    actions.add(SystemAction.get(CutAction.class));
                }
                actions.add(SystemAction.get(CopyAction.class));
                if (this.component instanceof ComponentContainer) {
                    actions.add(SystemAction.get(PasteAction.class));
                }
                if (this.component != topComp) {
                    actions.add(SystemAction.get(DeleteAction.class));
                }
            }
            actions.add(null);
            Action[] superActions = super.getActions(context);
            for (i = 0; i < superActions.length; ++i) {
                actions.add(superActions[i]);
            }
            this.actions = new Action[actions.size()];
            actions.toArray(this.actions);
        }
        return this.actions;
    }

    public String getName() {
        return this.component.getName();
    }

    public void setName(String s) {
        this.component.setName(s);
    }

    public boolean canRename() {
        return !this.component.isReadOnly() && this.component != this.component.getFormModel().getTopRADComponent();
    }

    public boolean canDestroy() {
        return !this.component.isReadOnly() && this.component != this.component.getFormModel().getTopRADComponent();
    }

    public void destroy() throws IOException {
        Object bean;
        RADComponent parent = this.component.getParentComponent();
        if (parent != null && (bean = parent.getBeanInstance()).getClass() == JScrollPane.class && parent.getAuxValue("autoScrollPane") != null) {
            this.component = parent;
        }
        if (EventQueue.isDispatchThread()) {
            this.component.getFormModel().removeComponent(this.component, true);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    RADComponentNode.this.component.getFormModel().removeComponent(RADComponentNode.this.component, true);
                }
            });
        }
        this.component.setNodeReference(null);
        super.destroy();
    }

    public boolean hasCustomizer() {
        return !this.component.isReadOnly() && this.component.getBeanInfo().getBeanDescriptor().getCustomizerClass() != null;
    }

    protected Component createCustomizer() {
        Object customizerObject;
        Class<?> customizerClass = this.component.getBeanInfo().getBeanDescriptor().getCustomizerClass();
        if (customizerClass == null) {
            return null;
        }
        try {
            customizerObject = customizerClass.newInstance();
        }
        catch (InstantiationException e) {
            ErrorManager.getDefault().notify(16, (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            ErrorManager.getDefault().notify(16, (Throwable)e);
            return null;
        }
        if (!(customizerObject instanceof Component) || !(customizerObject instanceof Customizer)) {
            return null;
        }
        if (customizerObject instanceof FormAwareEditor) {
            ((FormAwareEditor)customizerObject).setFormModel(this.component.getFormModel());
        }
        if (customizerObject instanceof NodeCustomizer) {
            ((NodeCustomizer)customizerObject).attach((Node)this.component.getNodeReference());
        }
        Customizer customizer = (Customizer)customizerObject;
        customizer.setObject(this.component.getBeanInstance());
        customizer.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void propertyChange(PropertyChangeEvent evt) {
                FormProperty[] properties;
                if (evt.getPropertyName() != null) {
                    RADProperty changedProperty = RADComponentNode.this.component.getBeanProperty(evt.getPropertyName());
                    if (changedProperty == null) return;
                    properties = new FormProperty[]{changedProperty};
                } else {
                    properties = RADComponentNode.this.component.getAllBeanProperties();
                    evt = null;
                }
                RADComponentNode.this.updatePropertiesFromCustomizer(properties, evt);
            }
        });
        return (Component)customizerObject;
    }

    private void updatePropertiesFromCustomizer(final FormProperty[] properties, final PropertyChangeEvent evt) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Object oldValue = evt != null ? evt.getOldValue() : null;
                Object newValue = evt != null ? evt.getNewValue() : null;
                for (int i = 0; i < properties.length; ++i) {
                    FormProperty prop = properties[i];
                    try {
                        prop.reinstateProperty();
                        prop.propertyValueChanged(oldValue, newValue);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                return null;
            }
        });
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return !this.component.isReadOnly() && this.component != this.component.getFormModel().getTopRADComponent();
    }

    public Transferable clipboardCopy() throws IOException {
        return new CopySupport.RADTransferable(CopySupport.getComponentCopyFlavor(), this.component);
    }

    public Transferable clipboardCut() throws IOException {
        return new CopySupport.RADTransferable(CopySupport.getComponentCutFlavor(), this.component);
    }

    protected void createPasteTypes(Transferable t, List s) {
        if (this.component.isReadOnly()) {
            return;
        }
        boolean copy = t.isDataFlavorSupported(CopySupport.getComponentCopyFlavor());
        boolean cut = t.isDataFlavorSupported(CopySupport.getComponentCutFlavor());
        if (copy || cut) {
            RADComponent transComp = null;
            try {
                Object data = t.getTransferData(t.getTransferDataFlavors()[0]);
                if (data instanceof RADComponent) {
                    transComp = (RADComponent)data;
                }
            }
            catch (UnsupportedFlavorException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
            if (!(transComp == null || cut && !CopySupport.canPasteCut(transComp, this.component.getFormModel(), this.component) || !MetaComponentCreator.canAddComponent(transComp.getBeanClass(), this.component) && (cut || !MetaComponentCreator.canApplyComponent(transComp.getBeanClass(), this.component)) || this.component instanceof RADMenuComponent && !(transComp instanceof RADMenuItemComponent))) {
                s.add(new CopySupport.RADPaste(t, this.component.getFormModel(), this.component));
            }
        } else {
            ClassSource classSource = CopySupport.getCopiedBeanClassSource(t);
            if (classSource != null) {
                s.add(new CopySupport.ClassPaste(t, classSource, this.component.getFormModel(), this.component));
            }
        }
    }

    public RADComponent getRADComponent() {
        return this.component;
    }

    public FormProperty getProperty(String name) {
        return (FormProperty)this.component.getPropertyByName(name, FormProperty.class, true);
    }

    public String getHtmlDisplayName() {
        if (this.highlightDisplayName) {
            return "<html><b>" + this.getDisplayName() + "</b></html>";
        }
        return "<html>" + this.getDisplayName() + "</html>";
    }

    void highlightDisplayName(boolean highlight) {
        if (highlight != this.highlightDisplayName) {
            this.highlightDisplayName = highlight;
            this.fireDisplayNameChange(null, this.getDisplayName());
        }
    }

    private static final class ChangeVariableNameAction
    extends RenameAction {
        private ChangeVariableNameAction() {
        }

        public String getName() {
            return NbBundle.getMessage(ChangeVariableNameAction.class, (String)"ChangeVariableNameAction");
        }
    }

    private final class ComponentsIndex
    extends Index.Support {
        private ComponentsIndex() {
        }

        public Node[] getNodes() {
            Object comps = RADComponentNode.this.component instanceof RADVisualContainer ? ((RADVisualContainer)RADComponentNode.this.component).getSubComponents() : (RADComponentNode.this.component instanceof ComponentContainer ? ((ComponentContainer)((Object)RADComponentNode.this.component)).getSubBeans() : null);
            Node[] nodes = new Node[comps != null ? ((RADVisualComponent[])comps).length : 0];
            for (int i = 0; i < ((RADComponent[])comps).length; ++i) {
                nodes[i] = comps[i].getNodeReference();
            }
            return nodes;
        }

        public int getNodesCount() {
            return this.getNodes().length;
        }

        public void reorder(int[] perm) {
            if (RADComponentNode.this.component instanceof ComponentContainer) {
                ComponentContainer cont = (ComponentContainer)((Object)RADComponentNode.this.component);
                cont.reorderSubComponents(perm);
                RADComponentNode.this.component.getFormModel().fireComponentsReordered(cont, perm);
            }
        }
    }

    public static class RADChildren
    extends FormNode.FormNodeChildren {
        private ComponentContainer container;
        private Object keyLayout;

        public RADChildren(ComponentContainer container) {
            this.container = container;
            this.updateKeys();
        }

        protected void updateKeys() {
            RADComponent[] subComps = this.container.getSubBeans();
            ArrayList<Object> keys = new ArrayList<Object>(subComps.length + 2);
            if (this.container instanceof RADVisualContainer) {
                RADVisualContainer visualCont = (RADVisualContainer)this.container;
                RADMenuComponent menuComp = visualCont.getContainerMenu();
                if (menuComp != null) {
                    keys.add(menuComp);
                }
                if (visualCont.shouldHaveLayoutNode()) {
                    this.keyLayout = visualCont.getLayoutSupport().getLayoutDelegate();
                    keys.add(this.keyLayout);
                }
                for (int i = 0; i < subComps.length; ++i) {
                    if (subComps[i] == menuComp) continue;
                    keys.add(subComps[i]);
                }
            } else {
                for (int i = 0; i < subComps.length; ++i) {
                    keys.add(subComps[i]);
                }
            }
            this.setKeys(keys);
        }

        protected Node[] createNodes(Object key) {
            FormNode node;
            if (key == this.keyLayout) {
                node = new LayoutNode((RADVisualContainer)this.container);
            } else {
                node = new RADComponentNode((RADComponent)key);
                node.getChildren().getNodes();
            }
            return new Node[]{node};
        }
    }
}

