/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementPartKind;
import org.netbeans.jmi.javamodel.ElementPartKindEnum;
import org.netbeans.jmi.javamodel.ElementReference;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.CallableFeatureImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.RefactoringModule;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.ui.SafeDeleteUI;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class SafeDeletePanel
extends CustomRefactoringPanel {
    private final transient Collection elements;
    private final transient SafeDeleteRefactoring refactoring;
    private boolean initialized = false;
    private String methodDeclaringClass = null;
    private ButtonGroup buttonGroup;
    private JPanel jPanel3;
    private JLabel label;
    private JCheckBox searchInComments;

    public SafeDeletePanel(SafeDeleteRefactoring refactoring, Collection selectedElements) {
        this.setName(NbBundle.getMessage((Class)SafeDeletePanel.class, (String)"LBL_SafeDel"));
        this.elements = selectedElements;
        this.refactoring = refactoring;
        this.initComponents();
    }

    String getMethodDeclaringClass() {
        return this.methodDeclaringClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        String labelText;
        this.searchInComments.setEnabled(true);
        if (this.initialized) {
            return;
        }
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            if (this.elements.size() > 1) {
                Iterator elementIterator = this.elements.iterator();
                Object elementToDelete = null;
                while (elementIterator.hasNext()) {
                    Object localElementToDelete = elementIterator.next();
                    if (!(localElementToDelete instanceof Resource)) continue;
                    elementToDelete = localElementToDelete;
                    break;
                }
                if (elementToDelete != null) {
                    String elementName = this.getElementName(elementToDelete);
                    labelText = NbBundle.getMessage((Class)SafeDeletePanel.class, (String)"LBL_SafeDelHeader", (Object)elementName);
                } else {
                    elementIterator = this.elements.iterator();
                    Element firstElement = (Element)elementIterator.next();
                    String firstElementName = this.getElementName(firstElement);
                    String secondElementName = this.getElementName((Element)elementIterator.next());
                    labelText = NbBundle.getMessage((Class)SafeDeletePanel.class, (String)"LBL_SafeDel_Elements", (Object)firstElementName, (Object)secondElementName);
                }
            } else {
                Element element = (Element)this.elements.iterator().next();
                labelText = this.getCustomString(element);
            }
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SafeDeletePanel.this.label.setText(labelText);
                SafeDeletePanel.this.validate();
            }
        });
        this.initialized = true;
    }

    public void requestFocus() {
        super.requestFocus();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jPanel3 = new JPanel();
        this.label = new JLabel();
        this.searchInComments = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.add((Component)this.label, "North");
        this.searchInComments.setSelected((Boolean)RefactoringModule.getOption("searchInComments.whereUsed", Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.searchInComments, (String)ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_SafeDelInComents"));
        this.searchInComments.setMargin(new Insets(10, 14, 2, 2));
        this.searchInComments.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SafeDeletePanel.this.searchInCommentsItemStateChanged(evt);
            }
        });
        this.jPanel3.add((Component)this.searchInComments, "South");
        this.searchInComments.getAccessibleContext().setAccessibleDescription(this.searchInComments.getText());
        this.add((Component)this.jPanel3, "North");
    }

    private void searchInCommentsItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption("searchInComments.whereUsed", b);
        this.refactoring.setCheckInComments(b);
    }

    public Dimension getPreferredSize() {
        Dimension orig = super.getPreferredSize();
        return new Dimension(orig.width + 30, orig.height + 30);
    }

    public boolean isSearchInComments() {
        return this.searchInComments.isSelected();
    }

    public String getHeader(CallableFeature call) {
        if (((CallableFeatureImpl)call).getParser() == null) {
            if (call instanceof Method) {
                return ((Method)call).getName();
            }
            if (call instanceof Constructor) {
                return this.getSimpleName(call.getDeclaringClass());
            }
            return "";
        }
        int s = ((MetadataElement)call).getPartStartOffset((ElementPartKind)ElementPartKindEnum.HEADER);
        int element = ((MetadataElement)call).getPartEndOffset((ElementPartKind)ElementPartKindEnum.HEADER);
        String result = call.getResource().getSourceText().substring(s, element);
        if (result.length() > 50) {
            result = result.substring(0, 49) + "...";
        }
        return CheckUtils.htmlize(result);
    }

    public String getSimpleName(ClassDefinition clazz) {
        if (clazz instanceof JavaClass) {
            return ((JavaClass)clazz).getSimpleName();
        }
        return NbBundle.getMessage((Class)SafeDeleteUI.class, (String)"LBL_AnonymousClass");
    }

    private String getCustomString(Object refElement) {
        if (refElement instanceof ElementReference) {
            NamedElement referredElement = ((ElementReference)refElement).getElement();
            return NbBundle.getMessage((Class)SafeDeleteUI.class, (String)"LBL_SafeDelRefWarning", (Object)referredElement.getName());
        }
        if (refElement instanceof Method) {
            return NbBundle.getMessage((Class)SafeDeleteUI.class, (String)"LBL_SafeDelMethod", (Object)this.getHeader((CallableFeature)refElement), (Object)this.getSimpleName(((CallableFeature)refElement).getDeclaringClass()));
        }
        if (refElement instanceof Constructor) {
            return NbBundle.getMessage((Class)SafeDeleteUI.class, (String)"LBL_SafeDelConstructor", (Object)this.getHeader((CallableFeature)refElement), (Object)this.getSimpleName(((CallableFeature)refElement).getDeclaringClass()));
        }
        if (refElement instanceof Field) {
            return NbBundle.getMessage((Class)SafeDeleteUI.class, (String)"LBL_SafeDelField", (Object)((Field)refElement).getName(), (Object)this.getSimpleName(((Field)refElement).getDeclaringClass()));
        }
        if (refElement instanceof Variable) {
            return NbBundle.getMessage((Class)SafeDeleteUI.class, (String)"LBL_SafeDelVariable", (Object)((Variable)refElement).getName());
        }
        if (refElement instanceof NamedElement) {
            String typeName = ((NamedElement)refElement).getName();
            return NbBundle.getMessage((Class)SafeDeleteUI.class, (String)"LBL_SafeDelHeader", (Object)typeName);
        }
        return NbBundle.getMessage((Class)SafeDeleteUI.class, (String)"LBL_SafeDelHeader", (Object)refElement);
    }

    private String getElementName(Element element) {
        if (element instanceof Resource) {
            FileObject fileObject = JavaModel.getFileObject((Resource)((Resource)element));
            return fileObject.getNameExt();
        }
        return element.toString();
    }
}

