/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.ui.RefactoringUIBypass;
import org.netbeans.modules.refactoring.ui.RenameAction;
import org.netbeans.modules.refactoring.ui.RenamePanel;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class RenameRefactoringUI
implements RefactoringUI,
RefactoringUIBypass {
    private final AbstractRefactoring refactoring;
    private final String oldName;
    private final String dispOldName;
    private String newName;
    private RenamePanel panel;
    private boolean fromListener = false;
    private RefObject jmiObject;
    private FileObject byPassFolder;
    private boolean byPassPakageRename;
    private boolean pkgRename = true;

    RenameRefactoringUI(RefObject jmiObject, FileObject folder, boolean packageRename) {
        this.jmiObject = jmiObject;
        this.pkgRename = packageRename;
        if (jmiObject == null || jmiObject instanceof JavaPackage) {
            String packageName;
            if (folder == null && (folder = JavaMetamodel.getManager().getClassPath().findResource(((JavaPackage)jmiObject).getName().replace('.', '/'))) == null) {
                Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
                DataObject dob = (DataObject)nodes[0].getCookie(DataObject.class);
                folder = dob.getFolder().getPrimaryFile();
            }
            this.refactoring = this.createMoveClassRefactoring(folder, packageRename);
            String string = packageName = jmiObject != null ? ((JavaPackage)jmiObject).getName() : null;
            this.oldName = !packageRename ? folder.getName() : (packageName != null ? ("".equals(packageName) ? NbBundle.getBundle((String)"org.netbeans.modules.java.project.Bundle").getString("LBL_DefaultPackage") : packageName) : ClassPath.getClassPath((FileObject)folder, (String)"classpath/source").getResourceName(folder).replace('/', '.'));
        } else if (jmiObject instanceof JavaClass) {
            this.refactoring = new RenameRefactoring(jmiObject);
            RefFeatured comp = jmiObject.refImmediateComposite();
            if (comp instanceof Resource) {
                FileObject fo = JavaModel.getFileObject((Resource)((Resource)comp));
                String name = fo.getName();
                Iterator iter = ((Resource)comp).getClassifiers().iterator();
                while (iter.hasNext()) {
                    String sName;
                    Object obj = iter.next();
                    if (!(obj instanceof JavaClass) || !name.equals(sName = ((JavaClass)obj).getSimpleName())) continue;
                    name = ((JavaClass)jmiObject).getSimpleName();
                    break;
                }
                this.oldName = name;
            } else {
                this.oldName = ((JavaClass)jmiObject).getSimpleName();
            }
        } else {
            this.refactoring = new RenameRefactoring(jmiObject);
            this.oldName = jmiObject instanceof NamedElement ? (jmiObject instanceof Resource ? JavaMetamodel.getManager().getDataObject((Resource)jmiObject).getName() : ((NamedElement)jmiObject).getName()) : "";
        }
        this.dispOldName = this.oldName;
    }

    public RenameRefactoringUI(RefObject jmiObject) {
        this(jmiObject, (FileObject)null, true);
    }

    private MoveClassRefactoring createMoveClassRefactoring(FileObject folder, boolean packageRename) {
        return new MoveClassRefactoring(folder, packageRename);
    }

    RenameRefactoringUI(RefObject jmiObject, String newName) {
        this.refactoring = new RenameRefactoring(jmiObject);
        this.jmiObject = jmiObject;
        this.oldName = newName;
        this.dispOldName = newName;
        this.fromListener = true;
    }

    RenameRefactoringUI(FileObject folder, String newName, boolean packageRename) {
        this.refactoring = this.createMoveClassRefactoring(folder, packageRename);
        this.pkgRename = packageRename;
        this.oldName = newName;
        this.dispOldName = newName;
        this.fromListener = true;
        this.byPassFolder = folder;
        this.byPassPakageRename = packageRename;
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ParametersPanel parent) {
        if (this.panel == null) {
            String name = this.oldName;
            String suffix = "";
            if (this.jmiObject instanceof JavaClass) {
                suffix = ((JavaClass)this.jmiObject).isInterface() ? RenameRefactoringUI.getString("LBL_Interface") : RenameRefactoringUI.getString("LBL_Class");
            } else if (this.jmiObject instanceof Method) {
                suffix = RenameRefactoringUI.getString("LBL_Method");
            } else if (this.jmiObject instanceof Field) {
                suffix = RenameRefactoringUI.getString("LBL_Field");
            } else if (this.jmiObject instanceof LocalVariable) {
                suffix = RenameRefactoringUI.getString("LBL_LocalVar");
            } else if (this.jmiObject instanceof JavaPackage || this.jmiObject == null && this.fromListener) {
                suffix = this.pkgRename ? RenameRefactoringUI.getString("LBL_Package") : RenameRefactoringUI.getString("LBL_Folder");
            } else if (this.jmiObject instanceof Parameter) {
                suffix = RenameRefactoringUI.getString("LBL_Parameter");
            }
            suffix = suffix + " " + name;
            this.panel = new RenamePanel(name, parent, NbBundle.getMessage((Class)RenamePanel.class, (String)"LBL_Rename") + " " + suffix, !this.fromListener, this.fromListener && !this.byPassPakageRename);
        }
        return this.panel;
    }

    private static String getString(String key) {
        return NbBundle.getMessage((Class)RenameRefactoringUI.class, (String)key);
    }

    public Problem setParameters() {
        this.newName = this.panel.getNameValue();
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(this.newName);
            ((RenameRefactoring)this.refactoring).setSearchInComments(this.panel.searchJavadoc());
        } else {
            ((MoveClassRefactoring)this.refactoring).setTargetPackageName(this.newName);
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        this.newName = this.panel.getNameValue();
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(this.newName);
        } else {
            ((MoveClassRefactoring)this.refactoring).setTargetPackageName(this.newName);
        }
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return new MessageFormat(NbBundle.getMessage((Class)RenameAction.class, (String)"DSC_Rename")).format(new Object[]{this.dispOldName, this.newName});
    }

    public String getName() {
        return NbBundle.getMessage((Class)RenameAction.class, (String)"LBL_Rename");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        String postfix = this.jmiObject instanceof JavaPackage ? ".JavaPackage" : (this.jmiObject instanceof JavaClass ? ".JavaClass" : (this.jmiObject instanceof Method ? ".Method" : (this.jmiObject instanceof Field ? ".Field" : "")));
        return new HelpCtx(RenameRefactoringUI.class.getName() + postfix);
    }

    public boolean isRefactoringBypassRequired() {
        return !this.panel.isUpdateReferences();
    }

    public void doRefactoringBypass() throws IOException {
        Object dob = this.byPassFolder != null ? DataFolder.findFolder((FileObject)this.byPassFolder) : JMManager.getManager().getDataObject(((Element)((RenameRefactoring)this.refactoring).getRefactoredObject()).getResource());
        dob.rename(this.panel.getNameValue());
    }
}

