/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import javax.jmi.reflect.RefFeatured;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.modules.refactoring.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.ui.UIUtilities;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PullUpPanel
extends CustomRefactoringPanel {
    private static final String[] COLUMN_NAMES = new String[]{"LBL_PullUp_Selected", "LBL_PullUp_Member", "LBL_PullUp_MakeAbstract"};
    private static final Class[] COLUMN_CLASSES = new Class[]{Boolean.class, NamedElement.class, Boolean.class};
    private final PullUpRefactoring refactoring;
    private final TableModel tableModel;
    private Set selectedMembers;
    private JavaClass targetType;
    private Object[][] members = new Object[0][0];
    private JLabel chooseLabel;
    private JTable membersTable;
    private JScrollPane scrollPane;
    private JComboBox supertypeCombo;
    private JLabel supertypeLabel;
    private JPanel supertypePanel;

    public PullUpPanel(PullUpRefactoring refactoring, Set selectedMembers, final ParametersPanel parent) {
        this.refactoring = refactoring;
        this.tableModel = new TableModel();
        this.selectedMembers = selectedMembers;
        this.initComponents();
        this.setPreferredSize(new Dimension(420, 380));
        this.membersTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                parent.stateChanged(null);
            }
        });
    }

    public void initialize() {
        JavaClass[] supertypes = this.refactoring.collectSupertypes();
        this.supertypeCombo.setRenderer(new UIUtilities.JavaElementListCellRenderer(){

            protected String extractText(Object value) {
                RefFeatured current;
                JavaClass topLevel = (JavaClass)value;
                while ((current = topLevel.refImmediateComposite()) instanceof JavaClass) {
                    topLevel = (JavaClass)current;
                }
                String packageName = topLevel.getName();
                packageName = packageName.substring(0, packageName.length() - topLevel.getSimpleName().length());
                String className = ((JavaClass)value).getName().substring(packageName.length());
                if (packageName.length() > 0) {
                    packageName = " (" + packageName.substring(0, packageName.length() - 1) + ")";
                }
                return className.concat(packageName);
            }
        });
        this.supertypeCombo.setModel(new ComboModel(supertypes));
        this.membersTable.setDefaultRenderer(COLUMN_CLASSES[1], new UIUtilities.JavaElementTableCellRenderer(){

            protected String extractText(Object value) {
                String displayValue = super.extractText(value);
                if (value instanceof MultipartId) {
                    displayValue = "implements " + displayValue;
                }
                return displayValue;
            }
        });
        this.membersTable.getColumnModel().getColumn(2).setCellRenderer(new UIUtilities.BooleanTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Object object = table.getModel().getValueAt(row, 1);
                if (object instanceof Method && (PullUpPanel.this.targetType.isInterface() && !Modifier.isStatic(((Method)object).getModifiers()) || Modifier.isAbstract(((Method)object).getModifiers()))) {
                    value = Boolean.TRUE;
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        this.scrollPane.setBackground(this.membersTable.getBackground());
        this.scrollPane.getViewport().setBackground(this.membersTable.getBackground());
        this.membersTable.setRowHeight(18);
        if (UIManager.getColor("control") != null) {
            this.membersTable.setGridColor(UIManager.getColor("control"));
        }
        UIUtilities.initColumnWidth(this.membersTable, 0, Boolean.TRUE, 4);
        UIUtilities.initColumnWidth(this.membersTable, 2, Boolean.TRUE, 4);
    }

    public JavaClass getTargetType() {
        return this.targetType;
    }

    public PullUpRefactoring.MemberInfo[] getMembers() {
        ArrayList<PullUpRefactoring.MemberInfo> list = new ArrayList<PullUpRefactoring.MemberInfo>();
        boolean targetIsInterface = this.targetType.isInterface();
        for (int i = 0; i < this.members.length; ++i) {
            if (!this.members[i][0].equals(Boolean.TRUE)) continue;
            Object element = this.members[i][1];
            PullUpRefactoring.MemberInfo member = element instanceof Field ? new PullUpRefactoring.MemberInfo((Field)element) : (element instanceof JavaClass ? new PullUpRefactoring.MemberInfo((JavaClass)element) : (element instanceof MultipartId ? new PullUpRefactoring.MemberInfo((MultipartId)element) : new PullUpRefactoring.MemberInfo((Method)element, targetIsInterface || (Boolean)this.members[i][2] != false)));
            list.add(member);
        }
        return list.toArray(new PullUpRefactoring.MemberInfo[list.size()]);
    }

    private void initComponents() {
        this.supertypePanel = new JPanel();
        this.supertypeCombo = new JComboBox();
        this.supertypeLabel = new JLabel();
        this.chooseLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.membersTable = new JTable();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setName(NbBundle.getMessage((Class)PullUpPanel.class, (String)"LBL_PullUpHeader", (Object[])new Object[]{UIUtilities.getDisplayText((NamedElement)this.refactoring.getSourceType())}));
        this.supertypePanel.setLayout(new BorderLayout(12, 0));
        this.supertypePanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.supertypePanel.add((Component)this.supertypeCombo, "Center");
        this.supertypeLabel.setLabelFor(this.supertypeCombo);
        Mnemonics.setLocalizedText((JLabel)this.supertypeLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_PullUp_Supertype"));
        this.supertypePanel.add((Component)this.supertypeLabel, "West");
        this.supertypeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PullUpPanel.class, (String)"ACSD_DestinationSupertypeName"));
        this.supertypeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PullUpPanel.class, (String)"ACSD_DestinationSupertypeDescription"));
        this.chooseLabel.setLabelFor(this.membersTable);
        Mnemonics.setLocalizedText((JLabel)this.chooseLabel, (String)NbBundle.getMessage((Class)PullUpPanel.class, (String)"LBL_PullUpLabel"));
        this.chooseLabel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.supertypePanel.add((Component)this.chooseLabel, "South");
        this.add((Component)this.supertypePanel, "North");
        this.membersTable.setModel(this.tableModel);
        this.membersTable.setAutoResizeMode(1);
        this.scrollPane.setViewportView(this.membersTable);
        this.membersTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PullUpPanel.class, (String)"ACSD_MembersToPullUp"));
        this.membersTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PullUpPanel.class, (String)"ACSD_MembersToPullUpDescription"));
        this.add((Component)this.scrollPane, "Center");
    }

    static /* synthetic */ Object[][] access$402(PullUpPanel x0, Object[][] x1) {
        x0.members = x1;
        return x1;
    }

    private class ComboModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final JavaClass[] supertypes;

        ComboModel(JavaClass[] supertypes) {
            this.supertypes = supertypes;
            if (supertypes.length > 0) {
                this.setSelectedItem(supertypes[0]);
            }
        }

        public void setSelectedItem(Object anItem) {
            if (PullUpPanel.this.targetType != anItem) {
                PullUpPanel.this.targetType = (JavaClass)anItem;
                this.fireContentsChanged(this, -1, -1);
                ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
                classes.add(PullUpPanel.this.refactoring.getSourceType());
                for (int i = 0; i < this.supertypes.length; ++i) {
                    if (this.supertypes[i].equals(PullUpPanel.this.targetType) || !this.supertypes[i].isSubTypeOf((ClassDefinition)PullUpPanel.this.targetType)) continue;
                    classes.add(this.supertypes[i]);
                }
                PullUpPanel.this.tableModel.update(classes.toArray(new JavaClass[classes.size()]));
            }
        }

        public Object getSelectedItem() {
            return PullUpPanel.this.targetType;
        }

        public Object getElementAt(int index) {
            return this.supertypes[index];
        }

        public int getSize() {
            return this.supertypes.length;
        }
    }

    private class TableModel
    extends AbstractTableModel {
        private TableModel() {
        }

        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        public String getColumnName(int column) {
            return UIUtilities.getColumnName(NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$PullUpPanel == null ? (class$org$netbeans$modules$refactoring$ui$PullUpPanel = PullUpPanel.class$("org.netbeans.modules.refactoring.ui.PullUpPanel")) : class$org$netbeans$modules$refactoring$ui$PullUpPanel), (String)COLUMN_NAMES[column]));
        }

        public Class getColumnClass(int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        public int getRowCount() {
            return PullUpPanel.this.members.length;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return PullUpPanel.this.members[rowIndex][columnIndex];
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            ((PullUpPanel)PullUpPanel.this).members[rowIndex][columnIndex] = value;
            this.fireTableDataChanged();
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 2) {
                if (PullUpPanel.this.members[rowIndex][2] == null) {
                    return false;
                }
                Object element = PullUpPanel.this.members[rowIndex][1];
                return !PullUpPanel.this.targetType.isInterface() && !Modifier.isStatic(((Method)element).getModifiers()) && !Modifier.isAbstract(((Method)element).getModifiers());
            }
            return columnIndex == 0;
        }

        void update(JavaClass[] classes) {
            Object[] value;
            int i;
            HashMap<Object, Object[]> map = new HashMap<Object, Object[]>();
            for (i = 0; i < classes.length; ++i) {
                Iterator it = classes[i].getInterfaceNames().iterator();
                while (it.hasNext()) {
                    Object ifcName = it.next();
                    map.put(ifcName, new Object[]{Boolean.FALSE, ifcName, null});
                }
                Object[] features = classes[i].getFeatures().toArray();
                for (int j = 0; j < features.length; ++j) {
                    if (!(features[j] instanceof JavaClass) && !(features[j] instanceof Field) && !(features[j] instanceof Method)) continue;
                    map.put(features[j], new Object[]{Boolean.FALSE, features[j], features[j] instanceof Method ? Boolean.FALSE : null});
                }
            }
            if (PullUpPanel.this.selectedMembers != null) {
                Iterator it = PullUpPanel.this.selectedMembers.iterator();
                while (it.hasNext()) {
                    value = (Object[])map.get(it.next());
                    if (value == null) continue;
                    value[0] = Boolean.TRUE;
                }
                PullUpPanel.this.selectedMembers = null;
            } else {
                for (i = 0; i < PullUpPanel.this.members.length; ++i) {
                    value = (Object[])map.get(PullUpPanel.this.members[i][1]);
                    if (value == null) continue;
                    map.put(value[1], PullUpPanel.this.members[i]);
                }
            }
            TreeMap<Object, Object[]> treeMap = new TreeMap<Object, Object[]>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    NamedElement ne1 = (NamedElement)o1;
                    NamedElement ne2 = (NamedElement)o2;
                    int result = ne1.getClass().getName().compareTo(ne2.getClass().getName());
                    if (result == 0) {
                        result = UIUtilities.getDisplayText(ne1).compareTo(UIUtilities.getDisplayText(ne2));
                    }
                    if (result == 0) {
                        result = ne1.refMofId().compareTo(ne2.refMofId());
                    }
                    return result;
                }
            });
            treeMap.putAll(map);
            PullUpPanel.access$402(PullUpPanel.this, new Object[treeMap.size()][]);
            int i2 = 0;
            Iterator it = treeMap.values().iterator();
            while (it.hasNext()) {
                ((PullUpPanel)PullUpPanel.this).members[i2] = (Object[])it.next();
                ++i2;
            }
            this.fireTableDataChanged();
        }
    }
}

