/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.Image;
import org.netbeans.api.java.queries.AccessibilityQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class PackageDisplayUtils {
    private static final Image PACKAGE = Utilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/package.gif");
    private static final Image PACKAGE_EMPTY = Utilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/packageEmpty.gif");
    private static final Image PACKAGE_PRIVATE = Utilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/packagePrivate.gif");
    private static final Image PACKAGE_PUBLIC = Utilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/packagePublic.gif");

    private PackageDisplayUtils() {
    }

    public static String getDisplayLabel(FileObject pkg, String pkgname) {
        if (pkgname.length() == 0) {
            return NbBundle.getMessage((Class)PackageDisplayUtils.class, (String)"LBL_DefaultPackage_PDU");
        }
        return pkgname;
    }

    public static Image getIcon(FileObject pkg, String pkgname) {
        Boolean b;
        if (PackageDisplayUtils.isEmpty(pkg)) {
            return PACKAGE_EMPTY;
        }
        Boolean bl = b = pkg.isValid() ? AccessibilityQuery.isPubliclyAccessible((FileObject)pkg) : null;
        if (b != null) {
            if (b.booleanValue()) {
                return PACKAGE_PUBLIC;
            }
            return PACKAGE_PRIVATE;
        }
        return PACKAGE;
    }

    private static boolean isEmpty(FileObject pkg) {
        FileObject[] kids = pkg.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            if (!kids[i].isData()) continue;
            return false;
        }
        return true;
    }

    public static boolean isSignificant(FileObject pkg) throws IllegalArgumentException {
        if (!pkg.isFolder()) {
            throw new IllegalArgumentException("Not a folder");
        }
        if (!VisibilityQuery.getDefault().isVisible(pkg)) {
            return false;
        }
        FileObject[] kids = pkg.getChildren();
        boolean subpackages = false;
        for (int i = 0; i < kids.length; ++i) {
            if (!VisibilityQuery.getDefault().isVisible(kids[i])) continue;
            if (kids[i].isData()) {
                return true;
            }
            subpackages = true;
        }
        return !subpackages;
    }
}

