/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.InnerToOuterRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.ui.InnerToOuterAction;
import org.netbeans.modules.refactoring.ui.InnerToOuterPanel;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class InnerToOuterRefactoringUI
implements RefactoringUI {
    private final InnerToOuterRefactoring refactoring;
    private final JavaClass sourceType;
    private InnerToOuterPanel panel;

    public InnerToOuterRefactoringUI(Element selectedElement) {
        this.sourceType = InnerToOuterRefactoringUI.getSourceType(selectedElement);
        this.refactoring = new InnerToOuterRefactoring(this.sourceType);
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ParametersPanel parent) {
        if (this.panel == null) {
            this.panel = new InnerToOuterPanel(this.refactoring, parent);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.captureParameters();
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        this.captureParameters();
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return NbBundle.getMessage((Class)InnerToOuterAction.class, (String)"DSC_InnerToOuter", (Object)this.sourceType.getSimpleName());
    }

    public String getName() {
        return NbBundle.getMessage((Class)InnerToOuterAction.class, (String)"LBL_InnerToOuter");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(InnerToOuterRefactoringUI.class.getName());
    }

    private void captureParameters() {
        this.refactoring.setClassName(this.panel.getClassName());
        this.refactoring.setReferenceName(this.panel.getReferenceName());
    }

    private static JavaClass getSourceType(Element element) {
        JavaClass result = null;
        while (element != null && !(element instanceof Resource)) {
            if (element instanceof JavaClass) {
                result = (JavaClass)element;
                break;
            }
            element = (Element)element.refImmediateComposite();
        }
        if (result != null && result.getDeclaringClass() == null) {
            result = null;
        }
        return result;
    }
}

