/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.javahelp.Help;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.InvalidationListener;
import org.netbeans.modules.refactoring.RefactoringModule;
import org.netbeans.modules.refactoring.UndoWatcher;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.ui.ErrorPanel;
import org.netbeans.modules.refactoring.ui.RefactoringPanel;
import org.netbeans.modules.refactoring.ui.RefactoringUIBypass;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ParametersPanel
extends JPanel
implements ProgressListener,
ChangeListener,
InvalidationListener {
    private RefactoringSession result;
    private final RefactoringUI rui;
    private final CustomRefactoringPanel customPanel;
    private transient JDialog dialog = null;
    private ArrayList components = null;
    private Problem problem;
    private ErrorPanel errorPanel;
    private final int PRE_CHECK = 0;
    private final int INPUT_PARAMETERS = 1;
    private final int POST_CHECK = 2;
    private transient int currentState = 1;
    private boolean cancelRequest = false;
    private JButton back;
    private JPanel buttonsPanel;
    public JButton cancel;
    private JPanel checkBoxPanel;
    private JPanel containerPanel;
    private JPanel controlsPanel;
    private JButton help;
    private JPanel innerPanel;
    private JLabel label;
    private JButton next;
    private JLabel pleaseWait;
    private JCheckBox previewAll;
    private JPanel progressPanel;
    private ProgressBar progressBar;
    private ProgressHandle progressHandle;
    private boolean isIndeterminate;

    public void setPreviewEnabled(boolean enabled) {
        RefactoringPanel.checkEventThread();
        this.next.setEnabled(enabled);
    }

    public ParametersPanel(RefactoringUI rui) {
        RefactoringPanel.checkEventThread();
        this.rui = rui;
        this.initComponents();
        this.innerPanel.setBorder(null);
        this.label.setText(" ");
        this.customPanel = rui.getPanel(this);
        this.errorPanel = new ErrorPanel(rui);
        this.calculatePrefferedSize();
        this.setButtonsEnabled(false);
    }

    private void calculatePrefferedSize() {
        Dimension cpDim = new Dimension(0, 0);
        Dimension ppDim = this.progressPanel.getPreferredSize();
        Dimension epDim = new Dimension(0, 0);
        if (this.customPanel != null) {
            cpDim = this.customPanel.getPreferredSize();
        }
        if (this.errorPanel != null) {
            epDim = this.errorPanel.getPreferredSize();
        }
        this.setPreferredSize(new Dimension(Math.max(Math.max(cpDim.width, ppDim.width), epDim.width), Math.max(cpDim.height, epDim.height) + ppDim.height));
        if (this.dialog != null && this.rui.isQuery()) {
            this.dialog.setSize(this.getPreferredSize());
        }
    }

    private void initComponents() {
        this.progressPanel = new JPanel();
        this.innerPanel = new JPanel();
        this.label = new JLabel();
        this.controlsPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.back = new JButton();
        this.next = new JButton();
        this.cancel = new JButton();
        this.help = new JButton();
        this.checkBoxPanel = new JPanel();
        this.previewAll = new JCheckBox();
        this.containerPanel = new JPanel();
        this.pleaseWait = new JLabel();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.setName(ResourceBundle.getBundle("org/netbeans/modules/refactoring/spi/ui/Bundle").getString("LBL_FindUsagesDialog"));
        this.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/refactoring/spi/ui/Bundle").getString("LBL_FindUsagesDialog"));
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/spi/ui/Bundle").getString("ACSD_FindUsagesDialog"));
        this.progressPanel.setLayout(new BorderLayout());
        this.progressPanel.setBorder(new EmptyBorder(new Insets(0, 12, 0, 11)));
        this.progressPanel.setOpaque(false);
        this.innerPanel.setLayout(new BorderLayout());
        this.innerPanel.setBorder(new LineBorder(Color.gray));
        this.label.setHorizontalAlignment(4);
        this.innerPanel.add((Component)this.label, "West");
        this.progressPanel.add((Component)this.innerPanel, "Center");
        this.controlsPanel.setLayout(new BorderLayout());
        this.controlsPanel.setBorder(new EmptyBorder(new Insets(5, 0, 5, 0)));
        this.buttonsPanel.setLayout(new GridLayout(1, 0, 5, 0));
        this.buttonsPanel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.back.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/refactoring/spi/ui/Bundle").getString("MNEM_Back").charAt(0));
        this.back.setLabel(ResourceBundle.getBundle("org/netbeans/modules/refactoring/spi/ui/Bundle").getString("CTL_Back"));
        this.back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParametersPanel.this.backActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.back);
        this.back.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/spi/ui/Bundle").getString("ACSD_Back"));
        this.next.setLabel(ResourceBundle.getBundle("org/netbeans/modules/refactoring/spi/ui/Bundle").getString("CTL_Finish"));
        this.next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParametersPanel.this.nextActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.next);
        this.next.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/spi/ui/Bundle").getString("ACSD_finish"));
        this.cancel.setLabel(ResourceBundle.getBundle("org/netbeans/modules/refactoring/spi/ui/Bundle").getString("CTL_Cancel"));
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParametersPanel.this.cancelActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.cancel);
        this.cancel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/spi/ui/Bundle").getString("ACSD_cancel"));
        Mnemonics.setLocalizedText((AbstractButton)this.help, (String)NbBundle.getMessage((Class)ParametersPanel.class, (String)"CTL_Help"));
        this.help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParametersPanel.this.helpActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.help);
        this.help.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/spi/ui/Bundle").getString("ACSD_help"));
        this.controlsPanel.add((Component)this.buttonsPanel, "East");
        this.checkBoxPanel.setLayout(new BorderLayout());
        this.checkBoxPanel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.previewAll.setSelected((Boolean)RefactoringModule.getOption(this.getPreviewKeyName(), Boolean.TRUE));
        Mnemonics.setLocalizedText((AbstractButton)this.previewAll, (String)NbBundle.getMessage((Class)ParametersPanel.class, (String)"CTL_PreviewAll"));
        this.previewAll.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ParametersPanel.this.previewAllItemStateChanged(evt);
            }
        });
        this.checkBoxPanel.add((Component)this.previewAll, "West");
        this.previewAll.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/spi/ui/Bundle").getString("ACSD_PreviewAll"));
        this.controlsPanel.add((Component)this.checkBoxPanel, "Center");
        this.progressPanel.add((Component)this.controlsPanel, "South");
        this.add((Component)this.progressPanel, "South");
        this.containerPanel.setLayout(new BorderLayout());
        this.containerPanel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.pleaseWait.setHorizontalAlignment(0);
        this.containerPanel.add((Component)this.pleaseWait, "Center");
        this.add((Component)this.containerPanel, "Center");
    }

    private void previewAllItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption(this.getPreviewKeyName(), b);
    }

    private String getPreviewKeyName() {
        return "previewAll." + this.rui.getRefactoring().getClass().getName();
    }

    private void helpActionPerformed(ActionEvent evt) {
        Help help = (Help)Lookup.getDefault().lookup(Help.class);
        help.showHelp(this.getHelpCtx());
    }

    private void backActionPerformed(ActionEvent evt) {
        this.placeCustomPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelActionPerformed(ActionEvent evt) {
        ParametersPanel parametersPanel = this;
        synchronized (parametersPanel) {
            this.rui.getRefactoring().cancelRequest();
            this.result = null;
            this.dialog.setVisible(false);
            this.cancelRequest = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextActionPerformed(ActionEvent evt) {
        if (this.currentState == 0) {
            this.placeCustomPanel();
            return;
        }
        this.setPanelEnabled(false);
        this.cancel.setEnabled(true);
        RequestProcessor rp = new RequestProcessor();
        final int inputState = this.currentState;
        if (this.currentState != 0) {
            if (this.rui instanceof RefactoringUIBypass && ((RefactoringUIBypass)((Object)this.rui)).isRefactoringBypassRequired()) {
                try {
                    ((RefactoringUIBypass)((Object)this.rui)).doRefactoringBypass();
                }
                catch (IOException ioe) {
                    this.currentState = 2;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ParametersPanel.this.placeErrorPanel(new Problem(true, ioe.getMessage()));
                        }
                    });
                }
                finally {
                    if (inputState == this.currentState) {
                        this.setVisibleLater(false);
                    }
                    return;
                }
            }
            this.result = RefactoringSession.create(this.rui.getName());
            rp.post((Runnable)new Prepare());
        }
        rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (inputState == ParametersPanel.this.currentState) {
                    try {
                        if (!ParametersPanel.this.previewAll.isSelected()) {
                            UndoWatcher.watch(ParametersPanel.this.result, ParametersPanel.this);
                            ParametersPanel.this.result.addProgressListener(ParametersPanel.this);
                            ParametersPanel.this.result.doRefactoring(true);
                            UndoWatcher.stopWatching(ParametersPanel.this);
                        }
                    }
                    finally {
                        if (!ParametersPanel.this.previewAll.isSelected()) {
                            ParametersPanel.this.result = null;
                        }
                        if (inputState == ParametersPanel.this.currentState) {
                            ParametersPanel.this.setVisibleLater(false);
                        }
                    }
                }
            }
        });
    }

    private void setVisibleLater(final boolean visible) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ParametersPanel.this.dialog.setVisible(visible);
            }
        });
    }

    private void setPanelEnabled(boolean enabled) {
        RefactoringPanel.checkEventThread();
        this.setButtonsEnabled(enabled);
        if (enabled) {
            if (this.components == null) {
                return;
            }
            Iterator it = this.components.iterator();
            while (it.hasNext()) {
                ((Component)it.next()).setEnabled(true);
            }
            this.components = null;
        } else {
            if (this.components != null) {
                return;
            }
            this.components = new ArrayList();
            this.disableComponents(this.customPanel);
        }
    }

    private void disableComponents(Container c) {
        RefactoringPanel.checkEventThread();
        Component[] children = c.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isEnabled()) {
                children[i].setEnabled(false);
                this.components.add(children[i]);
            }
            if (!(children[i] instanceof Container)) continue;
            this.disableComponents((Container)children[i]);
        }
    }

    public synchronized RefactoringSession showDialog() {
        RefactoringPanel.checkEventThread();
        if (this.rui != null) {
            this.rui.getRefactoring().addProgressListener(this);
        }
        String title = this.customPanel != null && this.customPanel.getName() != null && !"".equals(this.customPanel.getName()) ? this.customPanel.getName() : this.rui.getName();
        DialogDescriptor descriptor = new DialogDescriptor((Object)this, title, true, new Object[0], null, 0, null, null);
        this.dialog = (JDialog)DialogDisplayer.getDefault().createDialog(descriptor);
        this.dialog.validate();
        if (this.customPanel != null) {
            this.dialog.getAccessibleContext().setAccessibleName(this.rui.getName());
            this.dialog.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/spi/ui/Bundle").getString("ACSD_FindUsagesDialog"));
        }
        this.setCancelStuff();
        this.dialog.pack();
        RequestProcessor.Task task = RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                MDRepository rep = JavaModel.getJavaRepository();
                rep.beginTrans(true);
                try {
                    ParametersPanel.this.problem = ParametersPanel.this.rui.getRefactoring().preCheck();
                }
                catch (RuntimeException e) {
                    ParametersPanel.this.setVisibleLater(false);
                    throw e;
                }
                finally {
                    rep.endTrans();
                }
                if (ParametersPanel.this.problem != null) {
                    ParametersPanel.this.currentState = 0;
                    if (!ParametersPanel.this.problem.isFatal()) {
                        ParametersPanel.this.customPanel.initialize();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ParametersPanel.this.placeErrorPanel(ParametersPanel.this.problem);
                            ParametersPanel.this.dialog.setVisible(true);
                        }
                    });
                } else {
                    if (ParametersPanel.this.customPanel != null) {
                        ParametersPanel.this.customPanel.initialize();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ParametersPanel.this.placeCustomPanel();
                        }
                    });
                    if (!ParametersPanel.this.rui.hasParameters()) {
                        ParametersPanel.this.result = RefactoringSession.create(ParametersPanel.this.rui.getName());
                        rep.beginTrans(true);
                        try {
                            ParametersPanel.this.rui.getRefactoring().prepare(ParametersPanel.this.result);
                        }
                        finally {
                            rep.endTrans();
                            ParametersPanel.this.setVisibleLater(false);
                        }
                    }
                }
            }
        });
        this.dialog.setVisible(true);
        this.dialog.dispose();
        if (this.rui != null) {
            this.rui.getRefactoring().removeProgressListener(this);
        }
        if (!this.cancelRequest) {
            task.waitFinished();
        }
        return this.result;
    }

    private final void setCancelStuff() {
        KeyStroke k = KeyStroke.getKeyStroke(27, 0);
        String actionKey = "cancel";
        this.getRootPane().getInputMap(1).put(k, actionKey);
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent ev) {
                if (ParametersPanel.this.cancel.isEnabled()) {
                    ParametersPanel.this.cancelActionPerformed(ev);
                }
            }
        };
        this.getRootPane().getActionMap().put(actionKey, cancelAction);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                if (ParametersPanel.this.cancel.isEnabled()) {
                    ParametersPanel.this.cancelActionPerformed(null);
                }
            }
        });
    }

    private void placeErrorPanel(Problem problem) {
        this.containerPanel.removeAll();
        this.errorPanel = new ErrorPanel(problem, this.rui);
        this.errorPanel.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        this.containerPanel.add((Component)this.errorPanel, "Center");
        this.next.setEnabled(!problem.isFatal());
        this.dialog.getRootPane().setDefaultButton(this.next);
        if (this.currentState == 0) {
            Mnemonics.setLocalizedText((AbstractButton)this.next, (String)NbBundle.getMessage((Class)ParametersPanel.class, (String)"CTL_Next"));
            this.back.setVisible(false);
        } else {
            this.back.setVisible(true);
            this.back.setEnabled(true);
            this.dialog.getRootPane().setDefaultButton(this.back);
        }
        this.cancel.setEnabled(true);
        this.previewAll.setVisible(false);
        this.repaint();
    }

    private void placeCustomPanel() {
        if (this.customPanel == null) {
            return;
        }
        Mnemonics.setLocalizedText((AbstractButton)this.next, (String)NbBundle.getMessage((Class)ParametersPanel.class, (String)"CTL_Finish"));
        this.customPanel.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        this.containerPanel.removeAll();
        this.containerPanel.add((Component)this.customPanel, "Center");
        this.back.setVisible(false);
        this.previewAll.setVisible(!this.rui.isQuery());
        this.currentState = 1;
        this.setPanelEnabled(true);
        this.cancel.setEnabled(true);
        this.dialog.getRootPane().setDefaultButton(this.next);
        this.customPanel.requestFocus();
        this.repaint();
    }

    public void start(final ProgressEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String text;
                ParametersPanel.this.progressPanel.remove(ParametersPanel.this.innerPanel);
                ParametersPanel.this.progressBar = ProgressBar.create(ParametersPanel.this.progressHandle = ProgressHandleFactory.createHandle((String)""));
                ParametersPanel.this.progressPanel.add((Component)ParametersPanel.this.progressBar, "Center");
                if (event.getCount() == -1) {
                    ParametersPanel.this.isIndeterminate = true;
                    ParametersPanel.this.progressHandle.start();
                    ParametersPanel.this.progressHandle.switchToIndeterminate();
                } else {
                    ParametersPanel.this.isIndeterminate = false;
                    ParametersPanel.this.progressHandle.start(event.getCount());
                }
                switch (event.getOperationType()) {
                    case 2: {
                        text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$spi$ui$ParametersPanel == null ? (class$org$netbeans$modules$refactoring$spi$ui$ParametersPanel = ParametersPanel.class$("org.netbeans.modules.refactoring.spi.ui.ParametersPanel")) : class$org$netbeans$modules$refactoring$spi$ui$ParametersPanel), (String)"LBL_ParametersCheck");
                        break;
                    }
                    case 3: {
                        text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$spi$ui$ParametersPanel == null ? (class$org$netbeans$modules$refactoring$spi$ui$ParametersPanel = ParametersPanel.class$("org.netbeans.modules.refactoring.spi.ui.ParametersPanel")) : class$org$netbeans$modules$refactoring$spi$ui$ParametersPanel), (String)"LBL_Prepare");
                        break;
                    }
                    case 1: {
                        text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$spi$ui$ParametersPanel == null ? (class$org$netbeans$modules$refactoring$spi$ui$ParametersPanel = ParametersPanel.class$("org.netbeans.modules.refactoring.spi.ui.ParametersPanel")) : class$org$netbeans$modules$refactoring$spi$ui$ParametersPanel), (String)"LBL_PreCheck");
                        break;
                    }
                    default: {
                        text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$spi$ui$ParametersPanel == null ? (class$org$netbeans$modules$refactoring$spi$ui$ParametersPanel = ParametersPanel.class$("org.netbeans.modules.refactoring.spi.ui.ParametersPanel")) : class$org$netbeans$modules$refactoring$spi$ui$ParametersPanel), (String)"LBL_Usages");
                    }
                }
                ParametersPanel.this.progressBar.setString(text);
                ParametersPanel.this.progressPanel.setVisible(true);
                ParametersPanel.this.setButtonsEnabled(false);
            }
        });
    }

    public void step(final ProgressEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ParametersPanel.this.progressHandle.progress(ParametersPanel.this.isIndeterminate ? -2 : event.getCount());
            }
        });
    }

    public void stop(ProgressEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ParametersPanel.this.progressHandle.finish();
                ParametersPanel.this.progressPanel.remove(ParametersPanel.this.progressBar);
                ParametersPanel.this.progressPanel.add((Component)ParametersPanel.this.innerPanel, "Center");
            }
        });
    }

    public void stateChanged(ChangeEvent e) {
        this.showProblem(this.rui.checkParameters());
    }

    private void showProblem(Problem problem) {
        if (problem == null) {
            this.label.setText(" ");
            this.innerPanel.setBorder(null);
            this.next.setEnabled(true);
            return;
        }
        this.innerPanel.setBorder(new LineBorder(Color.gray));
        this.progressPanel.setVisible(true);
        if (problem.isFatal()) {
            this.displayError(problem.getMessage());
        } else {
            this.displayWarning(problem.getMessage());
        }
    }

    private void displayError(String error) {
        this.next.setEnabled(false);
        this.label.setText("<html><font color=\"red\">" + NbBundle.getMessage((Class)ParametersPanel.class, (String)"LBL_Error") + ": </font>" + error + "</html>");
    }

    private void displayWarning(String warning) {
        this.next.setEnabled(true);
        this.label.setText("<html><font color=\"red\">" + NbBundle.getMessage((Class)ParametersPanel.class, (String)"LBL_Warning") + ": </font>" + warning + "</html>");
    }

    private void setButtonsEnabled(boolean enabled) {
        this.next.setEnabled(enabled);
        this.back.setEnabled(enabled);
        this.previewAll.setEnabled(enabled);
    }

    public HelpCtx getHelpCtx() {
        return this.rui.getHelpCtx();
    }

    public void invalidateObject() {
    }

    private static class ProgressBar
    extends JPanel {
        private JLabel label;

        private static ProgressBar create(ProgressHandle handle) {
            ProgressBar instance = new ProgressBar();
            instance.setLayout(new BorderLayout());
            instance.label = new JLabel();
            instance.label.setBorder(new EmptyBorder(0, 0, 2, 0));
            instance.add((Component)instance.label, "North");
            JComponent progress = ProgressHandleFactory.createProgressComponent((ProgressHandle)handle);
            instance.add((Component)progress, "Center");
            return instance;
        }

        public void setString(String value) {
            this.label.setText(value);
        }

        private ProgressBar() {
        }
    }

    private class Prepare
    implements Runnable {
        private Prepare() {
        }

        public void run() {
            if (ParametersPanel.this.currentState != 2) {
                ParametersPanel.this.problem = ParametersPanel.this.rui.setParameters();
                if (ParametersPanel.this.problem != null) {
                    ParametersPanel.this.currentState = 2;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ParametersPanel.this.placeErrorPanel(ParametersPanel.this.problem);
                        }
                    });
                    return;
                }
            }
            MDRepository rep = JavaModel.getJavaRepository();
            rep.beginTrans(true);
            try {
                ParametersPanel.this.problem = ParametersPanel.this.rui.getRefactoring().prepare(ParametersPanel.this.result);
            }
            catch (RuntimeException e) {
                ParametersPanel.this.setVisibleLater(false);
                throw e;
            }
            finally {
                rep.endTrans();
            }
            if (ParametersPanel.this.problem != null) {
                ParametersPanel.this.currentState = 2;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ParametersPanel.this.placeErrorPanel(ParametersPanel.this.problem);
                    }
                });
            }
        }
    }
}

