/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.api;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.ProgressSupport;
import org.netbeans.modules.refactoring.SPIAccessor;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.classpath.RefactoringClassPathImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;

public final class RefactoringSession {
    private final LinkedList internalList = new LinkedList();
    private final RefactoringElementsBag bag = SPIAccessor.DEFAULT.createBag(this, this.internalList);
    private final Collection refactoringElements;
    private final String description;
    private ProgressSupport progressSupport;

    private RefactoringSession(String description) {
        this.description = description;
        this.refactoringElements = new ElementsCollection();
    }

    public static RefactoringSession create(String description) {
        return new RefactoringSession(description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem doRefactoring(boolean saveAfterDone) {
        Iterator it = this.internalList.iterator();
        this.fireProgressListenerStart(0, this.internalList.size() + 1);
        try {
            MDRepository repository = JavaModel.getJavaRepository();
            boolean fail = true;
            repository.beginTrans(true);
            JavaMetamodel.getUndoManager().setUndoDescription(this.description);
            try {
                JavaModel.setClassPath((ClassPath)RefactoringClassPathImplementation.getDefault());
                while (it.hasNext()) {
                    this.fireProgressListenerStep();
                    RefactoringElementImplementation element = (RefactoringElementImplementation)it.next();
                    if (!element.isEnabled() || element.getStatus() == 2 || element.getStatus() == 3) continue;
                    element.performChange();
                }
                fail = false;
            }
            finally {
                repository.endTrans(fail);
            }
            if (saveAfterDone) {
                JavaMetamodel.getUndoManager().saveAll();
            }
            this.fireProgressListenerStep();
        }
        finally {
            this.fireProgressListenerStop();
        }
        return null;
    }

    public Collection getRefactoringElements() {
        return this.refactoringElements;
    }

    public synchronized void addProgressListener(ProgressListener listener) {
        if (this.progressSupport == null) {
            this.progressSupport = new ProgressSupport();
        }
        this.progressSupport.addProgressListener(listener);
    }

    public synchronized void removeProgressListener(ProgressListener listener) {
        if (this.progressSupport != null) {
            this.progressSupport.removeProgressListener(listener);
        }
    }

    RefactoringElementsBag getElementsBag() {
        return this.bag;
    }

    private void fireProgressListenerStart(int type, int count) {
        if (this.progressSupport != null) {
            this.progressSupport.fireProgressListenerStart(this, type, count);
        }
    }

    private void fireProgressListenerStep() {
        if (this.progressSupport != null) {
            this.progressSupport.fireProgressListenerStep(this);
        }
    }

    private void fireProgressListenerStop() {
        if (this.progressSupport != null) {
            this.progressSupport.fireProgressListenerStop(this);
        }
    }

    private class ElementsCollection
    extends AbstractCollection {
        private ElementsCollection() {
        }

        public Iterator iterator() {
            return new Iterator(){
                private final Iterator inner;
                {
                    this.inner = RefactoringSession.this.internalList.iterator();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public Object next() {
                    return new RefactoringElement((RefactoringElementImplementation)this.inner.next());
                }

                public boolean hasNext() {
                    return this.inner.hasNext();
                }
            };
        }

        public int size() {
            return RefactoringSession.this.internalList.size();
        }
    }
}

