/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.classpath.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public final class MoveClassRefactoring
extends AbstractRefactoring {
    private Collection resources;
    private Collection otherDataObjects = Collections.EMPTY_LIST;
    private FileObject folder = null;
    private Map packagePostfix;
    private Collection dataObjects = Collections.EMPTY_LIST;
    private Map checkedSourcesMap;
    private boolean packageRename;
    private boolean isPackageRename = false;
    private String newPackageName;
    private FileObject target;

    public MoveClassRefactoring(FileObject sourceFolder, boolean isPackage) {
        this.isPackageRename = true;
        this.packageRename = isPackage;
        if (this.packageRename) {
            this.folder = sourceFolder;
            DataObject[] children = DataFolder.findFolder((FileObject)this.folder).getChildren();
            this.resources = new HashSet();
            this.otherDataObjects = new HashSet();
            for (int i = 0; i < children.length; ++i) {
                if (children[i] instanceof JavaDataObject) {
                    this.resources.add(JavaModel.getResource((FileObject)children[i].getPrimaryFile()));
                    continue;
                }
                if (children[i] instanceof DataFolder) continue;
                this.otherDataObjects.add(children[i]);
            }
        } else {
            this.folder = sourceFolder;
            LinkedList<DataObject> children = new LinkedList<DataObject>(Arrays.asList(DataFolder.findFolder((FileObject)this.folder).getChildren()));
            this.resources = new HashSet();
            this.otherDataObjects = new HashSet();
            while (!children.isEmpty()) {
                DataObject dob = children.removeFirst();
                if (dob instanceof JavaDataObject) {
                    this.resources.add(JavaModel.getResource((FileObject)dob.getPrimaryFile()));
                    continue;
                }
                if (dob instanceof DataFolder) {
                    if (!VisibilityQuery.getDefault().isVisible(dob.getPrimaryFile())) continue;
                    children.addAll(Arrays.asList(((DataFolder)dob).getChildren()));
                    continue;
                }
                this.otherDataObjects.add(dob);
            }
        }
    }

    public MoveClassRefactoring(JavaClass javaClass) {
        this.resources = new ArrayList(1);
        this.resources.add(javaClass.getResource());
    }

    public MoveClassRefactoring(Collection resources) {
        this.resources = resources;
    }

    public MoveClassRefactoring(Collection dataObjects, FileObject target) {
        this.target = target;
        this.resources = new ArrayList(1);
        this.packagePostfix = new HashMap(dataObjects.size());
        this.otherDataObjects = new HashSet();
        this.dataObjects = dataObjects;
        this.setup(dataObjects, "");
    }

    public FileObject getSourceFolder() {
        return this.folder;
    }

    protected void setClassPath() {
        Util.setClassPath(this.resources);
    }

    public Collection getResources() {
        return this.resources;
    }

    public String getTargetPackageName() {
        return this.newPackageName;
    }

    public String getTargetPackageName(Resource r) {
        return this.getTargetPackageName(JavaModel.getFileObject((Resource)r));
    }

    public String getTargetPackageName(FileObject fo) {
        if (this.isPackageRename) {
            if (this.packageRename) {
                return this.newPackageName;
            }
            ClassPath cp = ClassPath.getClassPath((FileObject)this.folder, (String)"classpath/source");
            FileObject root = cp.findOwnerRoot(this.folder);
            String prefix = FileUtil.getRelativePath((FileObject)root, (FileObject)this.folder.getParent()).replace('/', '.');
            String postfix = FileUtil.getRelativePath((FileObject)this.folder, (FileObject)fo.getParent()).replace('/', '.');
            String t = this.concat(prefix, this.newPackageName, postfix);
            return t;
        }
        if (this.packagePostfix != null) {
            String postfix = (String)this.packagePostfix.get(fo);
            String packageName = this.concat(null, this.newPackageName, postfix);
            return packageName;
        }
        return this.newPackageName;
    }

    public Collection getOtherDataObjects() {
        return this.otherDataObjects;
    }

    public FileObject getTargetClassPathRoot() {
        FileObject f = this.isPackageRename ? this.folder : this.target;
        return ClassPath.getClassPath((FileObject)f, (String)"classpath/source").findOwnerRoot(f);
    }

    public void setTargetClassPathRoot(FileObject target) {
        this.target = target;
    }

    public void setTargetPackageName(String name) {
        this.newPackageName = name;
    }

    public Collection getSelectedDataObjects() {
        if (this.isPackageRename) {
            try {
                if (!this.packageRename) {
                    return Collections.singletonList(DataObject.find((FileObject)this.folder));
                }
                FileObject f = this.folder;
                FileObject cpRoot = this.getTargetClassPathRoot();
                if (f != cpRoot) {
                    while (f.getParent() != cpRoot) {
                        f = f.getParent();
                    }
                }
                return Collections.singletonList(DataObject.find((FileObject)f));
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return this.dataObjects;
    }

    private void setup(Collection dataObjects, String postfix) {
        Iterator i = dataObjects.iterator();
        while (i.hasNext()) {
            DataObject o = (DataObject)i.next();
            FileObject fo = o.getPrimaryFile();
            if (o instanceof JavaDataObject) {
                Resource r = JavaModel.getResource((FileObject)fo);
                this.resources.add(r);
                this.packagePostfix.put(fo, postfix.replace('/', '.'));
                continue;
            }
            if (!(o instanceof DataFolder)) {
                this.otherDataObjects.add(o);
                this.packagePostfix.put(fo, postfix.replace('/', '.'));
                continue;
            }
            if (!VisibilityQuery.getDefault().isVisible(((DataFolder)o).getPrimaryFile())) continue;
            boolean addDot = !"".equals(postfix);
            ArrayList col = new ArrayList();
            Enumeration en = ((DataFolder)o).children();
            while (en.hasMoreElements()) {
                col.add(en.nextElement());
            }
            this.setup(col, postfix + (addDot ? "." : "") + o.getName());
        }
    }

    private String concat(String s1, String s2, String s3) {
        String result = "";
        if (s1 != null && !"".equals(s1)) {
            result = result + s1 + ".";
        }
        result = result + s2;
        if (s3 != null && !"".equals(s3)) {
            result = result + ("".equals(result) ? "" : ".") + s3;
        }
        return result;
    }
}

