/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.errorstripe.caret;

import java.util.Collections;
import java.util.List;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.editor.errorstripe.caret.CaretMark;
import org.netbeans.modules.editor.errorstripe.privatespi.Mark;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProvider;
import org.openide.text.NbDocument;

public class CaretMarkProvider
extends MarkProvider
implements CaretListener {
    private Mark mark;
    private JTextComponent component;

    public CaretMarkProvider(JTextComponent component) {
        this.component = component;
        component.addCaretListener(this);
        this.mark = this.createMark();
    }

    private Mark createMark() {
        int offset = this.component.getCaretPosition();
        Document doc = this.component.getDocument();
        int line = 0;
        if (doc instanceof StyledDocument) {
            line = NbDocument.findLineNumber((StyledDocument)((StyledDocument)doc), (int)offset);
        }
        return new CaretMark(line);
    }

    public synchronized List getMarks() {
        return Collections.singletonList(this.mark);
    }

    public void caretUpdate(CaretEvent e) {
        List old = this.getMarks();
        this.mark = this.createMark();
        List nue = this.getMarks();
        this.firePropertyChange("marks", old, nue);
    }
}

