/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.palette.items;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.html.palette.HTMLPaletteUtilities;
import org.netbeans.modules.html.palette.items.INPUTCustomizer;
import org.openide.text.ActiveEditorDrop;

public class INPUT
implements ActiveEditorDrop {
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_PASS = "password";
    public static final String TYPE_HIDDEN = "hidden";
    public static final String STATE_DISABLED = "disabled";
    public static final String STATE_READONLY = "readonly";
    private String name = "";
    private String value = "";
    private String type = "text";
    private boolean disabled = false;
    private boolean hidden = false;
    private boolean readonly = false;
    private String width = "";

    public boolean handleTransfer(JTextComponent targetComponent) {
        INPUTCustomizer c = new INPUTCustomizer(this);
        boolean accept = c.showDialog();
        if (accept) {
            String body = this.createBody();
            try {
                HTMLPaletteUtilities.insert(body, targetComponent);
            }
            catch (BadLocationException ble) {
                accept = false;
            }
        }
        return accept;
    }

    private String createBody() {
        String strType = " type=\"" + this.type + "\"";
        String strName = " name=\"" + this.name + "\"";
        String strValue = " value=\"" + this.value + "\"";
        String strReadOnly = this.readonly ? " readonly=\"readonly\"" : "";
        String strDisabled = this.disabled ? " disabled=\"disabled\"" : "";
        String strWidth = "";
        if (this.width.length() > 0) {
            strWidth = " size=\"" + this.width + "\"";
        }
        String inputBody = "<input" + strType + strName + strValue + strWidth + strReadOnly + strDisabled + " />";
        return inputBody;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }
}

