/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.palette.items;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.html.palette.HTMLPaletteUtilities;
import org.netbeans.modules.html.palette.items.IMGCustomizer;
import org.openide.text.ActiveEditorDrop;

public class IMG
implements ActiveEditorDrop {
    private String location = "";
    private String width = "";
    private String height = "";
    private String alttext = "";

    public boolean handleTransfer(JTextComponent targetComponent) {
        IMGCustomizer c = new IMGCustomizer(this, targetComponent);
        boolean accept = c.showDialog();
        if (accept) {
            String body = this.createBody();
            try {
                HTMLPaletteUtilities.insert(body, targetComponent);
            }
            catch (BadLocationException ble) {
                accept = false;
            }
        }
        return accept;
    }

    private String createBody() {
        String strLoc = " src=\"\"";
        if (this.location.length() > 0) {
            strLoc = " src=\"" + this.location + "\"";
        }
        String strWidth = "";
        if (this.width.length() > 0) {
            strWidth = " width=\"" + this.width + "\"";
        }
        String strHeight = "";
        if (this.height.length() > 0) {
            strHeight = " height=\"" + this.height + "\"";
        }
        String strAlt = "";
        if (this.alttext.length() > 0) {
            strAlt = " alt=\"" + this.alttext + "\"";
        }
        String imgBody = "<img" + strLoc + strWidth + strHeight + strAlt + "/>\n";
        return imgBody;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getAlttext() {
        return this.alttext;
    }

    public void setAlttext(String alttext) {
        this.alttext = alttext;
    }
}

