/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.persistence.rules.member;

import java.util.Arrays;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIHelper;
import org.netbeans.modules.j2ee.verification.persistence.predicates.member.AnnotatedAsIdOrEmbeddedIdPred;

public class NoIdOnEntitySubclass
extends AbstractRule {
    public NoIdOnEntitySubclass() {
        super(null, Arrays.asList(new AnnotatedAsIdOrEmbeddedIdPred()));
    }

    public String getId() {
        return "NoIdOnEntitySubclass";
    }

    protected String getMessageKey() {
        return "MSG_EntitySubclassHasId";
    }

    protected boolean isApplicable(Element subject, ProblemFinderContext ctx) {
        return (ctx.isIsEntityClass() || ctx.isMappedSuperclass()) && super.isApplicable(subject, ctx);
    }

    public Problem apply(Element subject, ProblemFinderContext ctx) {
        JavaClass javaClass;
        JavaClass entityRoot;
        if (this.isApplicable(subject, ctx) && (entityRoot = PersistenceAPIHelper.findEntityRootClass(javaClass = ctx.getMainJavaClass())) != null && entityRoot != javaClass) {
            return this.createProblem(ctx, subject);
        }
        return null;
    }
}

