/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.ejb.rules.clazz;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.ejb.predicates.clazz.AnnotatedAsLocal;
import org.netbeans.modules.javacore.api.JavaModel;

public class BeanUsesRBIasRBI
extends AbstractRule {
    List<String> incorrectRBIs = new ArrayList<String>();

    public String getId() {
        return "BeanUsesRBIasRBI";
    }

    protected String getMessageKey() {
        return "MSG_BeanUsesLBIasRBI";
    }

    protected Object[] getMessageParameters() {
        return this.incorrectRBIs.toArray();
    }

    protected boolean isApplicable(Element subject, ProblemFinderContext ctx) {
        return ctx.isSessionBean() && super.isApplicable(subject, ctx);
    }

    public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (this.isApplicable(subject, ctx)) {
            Set<String> rbis = ctx.getRBIs();
            for (String rbi : rbis) {
                JavaClass jc;
                Type type = JavaModel.getDefaultExtent().getType().resolve(rbi);
                if (!(type instanceof JavaClass) || !new AnnotatedAsLocal().evaluate((Object)(jc = (JavaClass)JavaClass.class.cast(type)))) continue;
                this.incorrectRBIs.add(rbi);
            }
            if (!this.incorrectRBIs.isEmpty()) {
                return this.createProblem(ctx, subject);
            }
        }
        return null;
    }

    public void reset() {
        this.incorrectRBIs.clear();
    }
}

