/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.ejb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.ArrayInitialization;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.ClassExpression;
import org.netbeans.jmi.javamodel.InitialValue;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.verification.JEEVerificationAnnotationProvider;
import org.netbeans.modules.j2ee.verification.ProblemFindingUtils;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBApiHelper {
    public static org.netbeans.modules.j2ee.dd.api.ejb.EjbJar getEjbJar(JavaClass javaClass) {
        FileObject fileObject = JavaModel.getFileObject((Resource)javaClass.getResource());
        if (fileObject != null) {
            try {
                EjbJar apiEjbJar = EjbJar.getEjbJar((FileObject)fileObject);
                if (apiEjbJar != null) {
                    return DDProvider.getDefault().getMergedDDRoot(apiEjbJar.getMetadataUnit());
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return null;
    }

    public static boolean isSessionBean(JavaClass javaClass) {
        TreeSet<String> annotations = new TreeSet<String>(Arrays.asList("javax.ejb.Stateful", "javax.ejb.Stateless"));
        return ProblemFindingUtils.findFirstAnnotationFromGivenSet((AnnotableElement)javaClass, annotations) != null;
    }

    public static boolean isStateless(JavaClass javaClass) {
        Set<String> annotations = Collections.singleton("javax.ejb.Stateless");
        return ProblemFindingUtils.findFirstAnnotationFromGivenSet((AnnotableElement)javaClass, annotations) != null;
    }

    public static boolean isStateful(JavaClass javaClass) {
        Set<String> annotations = Collections.singleton("javax.ejb.Stateful");
        return ProblemFindingUtils.findFirstAnnotationFromGivenSet((AnnotableElement)javaClass, annotations) != null;
    }

    public static boolean isRBI(JavaClass javaClass) {
        Session[] sbs;
        EnterpriseBeans ejbs;
        boolean isAnnotated;
        if (!javaClass.isInterface()) {
            return false;
        }
        boolean bl = isAnnotated = ProblemFindingUtils.findAnnotation((AnnotableElement)javaClass, "javax.ejb.Remote") != null;
        if (isAnnotated) {
            return true;
        }
        org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar = EJBApiHelper.getEjbJar(javaClass);
        if (ejbJar != null && (ejbs = ejbJar.getEnterpriseBeans()) != null && (sbs = ejbs.getSession()) != null) {
            String inputName = javaClass.getName();
            for (Session sb : sbs) {
                if (!inputName.equals(EJBApiHelper.getBusinessRemote(sb))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isLBI(JavaClass javaClass) {
        Session[] sbs;
        EnterpriseBeans ejbs;
        boolean isAnnotated;
        if (!javaClass.isInterface()) {
            return false;
        }
        boolean bl = isAnnotated = ProblemFindingUtils.findAnnotation((AnnotableElement)javaClass, "javax.ejb.Local") != null;
        if (isAnnotated) {
            return true;
        }
        org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar = EJBApiHelper.getEjbJar(javaClass);
        if (ejbJar != null && (ejbs = ejbJar.getEnterpriseBeans()) != null && (sbs = ejbs.getSession()) != null) {
            String inputName = javaClass.getName();
            for (Session sb : sbs) {
                if (!inputName.equals(EJBApiHelper.getBusinessLocal(sb))) continue;
                return true;
            }
        }
        return false;
    }

    public static void getBusinessInterfaces(JavaClass javaClass, Set<String> lbis, Set<String> rbis) {
        List<JavaClass> interfaces = EJBApiHelper.getNonStandardInterfaces(javaClass);
        Annotation lNN = ProblemFindingUtils.findAnnotation((AnnotableElement)javaClass, "javax.ejb.Local");
        Annotation rNN = ProblemFindingUtils.findAnnotation((AnnotableElement)javaClass, "javax.ejb.Remote");
        List<JavaClass> lNNValues = null;
        List<JavaClass> rNNValues = null;
        if (lNN != null) {
            lNNValues = EJBApiHelper.readValueForRemoteOrLocal(lNN);
        }
        if (rNN != null) {
            rNNValues = EJBApiHelper.readValueForRemoteOrLocal(rNN);
        }
        switch (interfaces.size()) {
            case 0: {
                EJBApiHelper.getBusinessInterfaces0(javaClass, lbis, rbis, lNNValues, rNNValues);
                break;
            }
            case 1: {
                EJBApiHelper.getBusinessInterfaces1(javaClass, lbis, rbis, lNNValues, rNNValues, interfaces);
                break;
            }
            default: {
                EJBApiHelper.getBusinessInterfacesN(javaClass, lbis, rbis, lNNValues, rNNValues, interfaces);
            }
        }
        StringBuilder sb = new StringBuilder(javaClass.getName() + " has following local business interface(s) [ ");
        for (String jc : lbis) {
            sb.append(jc).append(" ");
        }
        sb.append("] and following remote business interface(s) [ ");
        for (String jc : rbis) {
            sb.append(jc).append(" ");
        }
        sb.append("]");
        JEEVerificationAnnotationProvider.tmpDbg(sb.toString());
    }

    private static void getBusinessInterfaces0(JavaClass javaClass, Set<String> lbis, Set<String> rbis, List<JavaClass> lNNValues, List<JavaClass> rNNValues) {
        if (lNNValues != null) {
            for (JavaClass c : lNNValues) {
                lbis.add(c.getName());
            }
        }
        if (rNNValues != null) {
            for (JavaClass c : rNNValues) {
                rbis.add(c.getName());
            }
        }
    }

    private static void getBusinessInterfaces1(JavaClass javaClass, Set<String> lbis, Set<String> rbis, List<JavaClass> lNNValues, List<JavaClass> rNNValues, List<JavaClass> interfaces) {
        assert (interfaces.size() == 1);
        JavaClass i = interfaces.get(0);
        String iName = i.getName();
        if (rNNValues != null) {
            if (rNNValues.isEmpty()) {
                rbis.add(iName);
            } else {
                for (JavaClass c : rNNValues) {
                    rbis.add(c.getName());
                }
            }
        }
        if (ProblemFindingUtils.findAnnotation((AnnotableElement)i, "javax.ejb.Remote") != null) {
            rbis.add(iName);
        }
        if (lNNValues != null) {
            if (lNNValues.isEmpty()) {
                lbis.add(iName);
            } else {
                for (JavaClass c : lNNValues) {
                    lbis.add(c.getName());
                }
            }
        }
        if (ProblemFindingUtils.findAnnotation((AnnotableElement)i, "javax.ejb.Local") != null) {
            lbis.add(iName);
        } else if (!rbis.contains(iName)) {
            lbis.add(iName);
        }
    }

    private static void getBusinessInterfacesN(JavaClass javaClass, Set<String> lbis, Set<String> rbis, List<JavaClass> lNNValues, List<JavaClass> rNNValues, List<JavaClass> interfaces) {
        assert (interfaces.size() > 1);
        if (rNNValues != null) {
            if (rNNValues.isEmpty()) {
                ErrorManager.getDefault().log(1, "@Stateless @Remote class Foo implements I1, I2{} pattern detected");
            } else {
                for (JavaClass c : rNNValues) {
                    rbis.add(c.getName());
                }
            }
        }
        for (JavaClass i : interfaces) {
            if (ProblemFindingUtils.findAnnotation((AnnotableElement)i, "javax.ejb.Remote") == null) continue;
            rbis.add(i.getName());
        }
        if (lNNValues != null) {
            if (lNNValues.isEmpty()) {
                ErrorManager.getDefault().log(1, "@Stateless @Local class Foo implements I1, I2{} pattern detected");
            } else {
                for (JavaClass c : lNNValues) {
                    lbis.add(c.getName());
                }
            }
        }
        for (JavaClass i : interfaces) {
            if (ProblemFindingUtils.findAnnotation((AnnotableElement)i, "javax.ejb.Local") == null) continue;
            lbis.add(i.getName());
        }
    }

    private static List<JavaClass> getNonStandardInterfaces(JavaClass javaClass) {
        ArrayList<JavaClass> result = new ArrayList<JavaClass>();
        for (JavaClass i : javaClass.getInterfaces()) {
            String name = i.getName();
            if ("java.io.Serializable".equals(name) || "java.io.Externalizable".equals(name) || name.startsWith("javax.ejb")) continue;
            result.add(i);
        }
        return result;
    }

    private static List<JavaClass> readValueForRemoteOrLocal(Annotation annotation) {
        ArrayList<JavaClass> result = new ArrayList<JavaClass>();
        if (annotation.isValid()) {
            for (AttributeValue attr : annotation.getAttributeValues()) {
                InitialValue value = attr.getValue();
                if (value instanceof ArrayInitialization) {
                    List elementValues = ((ArrayInitialization)ArrayInitialization.class.cast(value)).getElementValues();
                    for (Object o : elementValues) {
                        if (!(o instanceof ClassExpression)) continue;
                        ClassExpression ce = (ClassExpression)ClassExpression.class.cast(o);
                        result.add((JavaClass)JavaClass.class.cast(ce.getClassName().getType()));
                    }
                    continue;
                }
                if (!(value instanceof ClassExpression)) continue;
                ClassExpression ce = (ClassExpression)ClassExpression.class.cast(value);
                result.add((JavaClass)JavaClass.class.cast(ce.getClassName().getType()));
            }
        } else {
            ErrorManager.getDefault().log(1, "Invalid annotation: " + annotation);
        }
        return result;
    }

    private static String getBusinessRemote(Session session) {
        ErrorManager.getDefault().log(65536, "EJBApiHelper.getBusinessRemote() is not yet implemented.");
        return null;
    }

    private static String getBusinessLocal(Session session) {
        ErrorManager.getDefault().log(65536, "EJBApiHelper.getBusinessLocal() is not yet implemented.");
        return null;
    }
}

