/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import org.openide.src.JavaDocMemoryImpl;
import org.openide.src.JavaDocTag;

class JavaDocTagMemoryImpl
implements JavaDocTag {
    String name;
    String text;

    JavaDocTagMemoryImpl(String name, String text) {
        this.name = name;
        this.text = JavaDocMemoryImpl.convertNewLines(text);
    }

    public String toString() {
        return this.name + " " + this.text;
    }

    public String name() {
        return this.name;
    }

    public String kind() {
        return this.name;
    }

    public String text() {
        return this.text;
    }

    String[] divideAtWhite() {
        String[] sa = new String[2];
        int len = this.text.length();
        sa[0] = this.text;
        sa[1] = "";
        block0: for (int inx = 0; inx < len; ++inx) {
            char ch = this.text.charAt(inx);
            if (!Character.isWhitespace(ch)) continue;
            sa[0] = this.text.substring(0, inx);
            while (inx < len) {
                ch = this.text.charAt(inx);
                if (!Character.isWhitespace(ch)) {
                    sa[1] = this.text.substring(inx, len);
                    break block0;
                }
                ++inx;
            }
            break;
        }
        return sa;
    }

    static class SerialField
    extends JavaDocTagMemoryImpl
    implements JavaDocTag.SerialField {
        private String fieldName;
        private String fieldType;
        private String description;

        SerialField(String name, String text) {
            super(name, text);
            this.parseSerialFieldString(text);
        }

        public String fieldName() {
            return this.fieldName;
        }

        public String fieldType() {
            return this.fieldType;
        }

        public String description() {
            return this.description;
        }

        public String kind() {
            return "@serialField";
        }

        public String toString() {
            return this.name + " " + this.fieldName() + " " + this.fieldType() + " " + this.description();
        }

        private void parseSerialFieldString(String text) {
            int inx;
            int len = text.length();
            for (inx = 0; inx < len && Character.isWhitespace(text.charAt(inx)); ++inx) {
            }
            if (inx == len) {
                this.fieldName = "";
                this.fieldType = "";
                this.description = "";
                return;
            }
            int first = inx;
            int last = inx;
            if (!Character.isJavaIdentifierStart(text.charAt(inx))) {
                return;
            }
            while (inx < len && Character.isJavaIdentifierPart(text.charAt(inx))) {
                ++inx;
            }
            if (inx < len && !Character.isWhitespace(text.charAt(inx))) {
                return;
            }
            last = inx;
            this.fieldName = text.substring(first, last);
            while (inx < len && Character.isWhitespace(text.charAt(inx))) {
                ++inx;
            }
            first = inx;
            last = inx;
            while (inx < len && !Character.isWhitespace(text.charAt(inx))) {
                ++inx;
            }
            if (inx < len && !Character.isWhitespace(text.charAt(inx))) {
                return;
            }
            last = inx;
            this.fieldType = text.substring(first, last);
            while (inx < len && Character.isWhitespace(text.charAt(inx))) {
                ++inx;
            }
            this.description = text.substring(inx);
        }
    }

    static class Throws
    extends JavaDocTagMemoryImpl
    implements JavaDocTag.Throws {
        private String exceptionName;
        private String exceptionComment;

        Throws(String name, String text) {
            super(name, text);
            String[] sa = this.divideAtWhite();
            this.exceptionName = sa[0];
            this.exceptionComment = sa[1];
        }

        public String exceptionName() {
            return this.exceptionName;
        }

        public String exceptionComment() {
            return this.exceptionComment;
        }

        public String kind() {
            return "@throws";
        }

        public String toString() {
            return this.name + " " + this.exceptionName() + " " + this.exceptionComment();
        }
    }

    static class Param
    extends JavaDocTagMemoryImpl
    implements JavaDocTag.Param {
        private String parameterName;
        private String parameterComment;

        Param(String name, String text) {
            super(name, text);
            String[] sa = this.divideAtWhite();
            this.parameterName = sa[0];
            this.parameterComment = sa[1];
        }

        public String parameterName() {
            return this.parameterName;
        }

        public String parameterComment() {
            return this.parameterComment;
        }

        public String kind() {
            return "@param";
        }

        public String toString() {
            return this.name + " " + this.parameterName() + " " + this.parameterComment();
        }
    }

    static class See
    extends JavaDocTagMemoryImpl
    implements JavaDocTag.See {
        private String label = "";
        private String where;
        private String what;

        See(String name, String text) {
            super(name, text);
            this.parseSeeString();
        }

        public String label() {
            return this.label;
        }

        public String referencedClassName() {
            return this.where;
        }

        public String referencedMemberName() {
            return this.what;
        }

        public String kind() {
            return "@see";
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(100);
            sb.append(this.name).append(" ").append(this.text);
            return sb.toString();
        }

        private void parseSeeString() {
            int sharp;
            int start;
            int len = this.text.length();
            if (len == 0) {
                return;
            }
            switch (this.text.charAt(0)) {
                case '\"': 
                case '<': {
                    return;
                }
            }
            int parens = 0;
            int commentstart = 0;
            block10: for (int i = start = 0; i < len; ++i) {
                char ch = this.text.charAt(i);
                switch (ch) {
                    case '(': {
                        ++parens;
                        continue block10;
                    }
                    case ')': {
                        --parens;
                        continue block10;
                    }
                    case '#': 
                    case '.': 
                    case '[': 
                    case ']': {
                        continue block10;
                    }
                    case ',': {
                        if (parens > 0) continue block10;
                        return;
                    }
                    case '\t': 
                    case '\n': 
                    case ' ': {
                        if (parens != 0) continue block10;
                        commentstart = i;
                        i = len;
                        continue block10;
                    }
                    default: {
                        if (Character.isJavaIdentifierPart(ch)) continue block10;
                        return;
                    }
                }
            }
            if (parens != 0) {
                return;
            }
            String seetext = "";
            String labeltext = "";
            if (commentstart > 0) {
                seetext = this.text.substring(start, commentstart);
                labeltext = this.text.substring(commentstart + 1);
                for (int i = 0; i < labeltext.length(); ++i) {
                    char ch = labeltext.charAt(i);
                    if (ch == ' ' || ch == '\t' || ch == '\n') continue;
                    this.label = labeltext.substring(i);
                    break;
                }
            } else {
                seetext = this.text;
                this.label = "";
            }
            if ((sharp = seetext.indexOf(35)) >= 0) {
                this.where = seetext.substring(0, sharp);
                this.what = seetext.substring(sharp + 1);
            } else if (seetext.indexOf(40) >= 0) {
                this.where = "";
                this.what = seetext;
            } else {
                this.where = seetext;
                this.what = null;
            }
        }
    }
}

