/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.comparators;

import java.util.Comparator;
import org.netbeans.api.java.comparators.IdentifierComparator;
import org.netbeans.api.java.comparators.JavaElementComparator;
import org.openide.src.Type;

class TypeComparator
extends JavaElementComparator {
    private Comparator idComparator;
    private static final int T_BOOLEAN = 1;
    private static final int T_INT = 2;
    private static final int T_CHAR = 3;
    private static final int T_BYTE = 4;
    private static final int T_SHORT = 5;
    private static final int T_LONG = 6;
    private static final int T_FLOAT = 7;
    private static final int T_DOUBLE = 8;
    private static final int T_VOID = 9;
    private static final int T_CLASS = 16;
    private static final int T_ARRAY = 32;

    protected TypeComparator(int type) {
        super(type);
    }

    private int getKind(Type t) {
        if (t.isArray()) {
            return 32;
        }
        if (t.isClass()) {
            return 16;
        }
        if (t == Type.BOOLEAN) {
            return 1;
        }
        if (t == Type.BYTE) {
            return 4;
        }
        if (t == Type.CHAR) {
            return 3;
        }
        if (t == Type.DOUBLE) {
            return 8;
        }
        if (t == Type.FLOAT) {
            return 7;
        }
        if (t == Type.INT) {
            return 2;
        }
        if (t == Type.LONG) {
            return 6;
        }
        if (t == Type.SHORT) {
            return 5;
        }
        if (t == Type.VOID) {
            return 9;
        }
        return 0;
    }

    public int compare(Object o1, Object o2) {
        int t2_kind;
        Type t1 = (Type)o1;
        Type t2 = (Type)o2;
        int t1_kind = this.getKind(t1);
        if (t1_kind != (t2_kind = this.getKind(t2))) {
            if (t1_kind > t2_kind) {
                return 1;
            }
            return -1;
        }
        if (t1.isArray()) {
            return this.compare(t1.getElementType(), t2.getElementType());
        }
        if (t1.isClass()) {
            if (this.idComparator == null) {
                this.idComparator = IdentifierComparator.createComparator(this.type);
            }
            return this.idComparator.compare(t1.getClassName(), t2.getClassName());
        }
        return 0;
    }

    static Comparator createComparator(int type) {
        return new TypeComparator(type);
    }
}

