/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mdr;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import org.netbeans.modules.mdr.MDRDescriptor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;

public class MDRDataObject
extends MultiDataObject {
    private final String name;
    private final MDRDescriptor descriptor;
    private static final String TAG_START = "{";
    private static final String TAG_END = "}";
    private static final String TAG_BODY_FOLDER = "folder.";

    public MDRDataObject(FileObject primaryFile, MultiFileLoader fl) throws DataObjectExistsException {
        super(primaryFile, fl);
        String fileName = primaryFile.getName();
        int pos = fileName.indexOf(91);
        int pos2 = fileName.indexOf(93);
        this.name = fileName.substring(0, pos);
        String className = fileName.substring(pos + 1, pos2).replace('-', '.');
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Enumeration en = primaryFile.getAttributes();
        while (en.hasMoreElements()) {
            String attrName = (String)en.nextElement();
            attributes.put(attrName, this.resolveTags(primaryFile.getAttribute(attrName)));
        }
        this.descriptor = new MDRDescriptor(className, attributes);
    }

    public MDRDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCopyAllowed() {
        return false;
    }

    public boolean isDeleteAllowed() {
        return false;
    }

    public boolean isMoveAllowed() {
        return false;
    }

    public boolean isRenameAllowed() {
        return false;
    }

    public boolean isShadowAllowed() {
        return false;
    }

    public Node createNodeDelegate() {
        DataNode dataNode = (DataNode)super.createNodeDelegate();
        dataNode.setIconBase("/org/netbeans/modules/mdr/resources/repository");
        return dataNode;
    }

    private Object resolveTags(Object attrValue) {
        if (attrValue instanceof String) {
            int pos;
            String value = (String)attrValue;
            ErrorManager.getDefault().log(1, "tag: " + value);
            StringBuffer result = new StringBuffer(value.length());
            int ppos = 0;
            while ((pos = value.indexOf(TAG_START, ppos)) > -1) {
                ErrorManager.getDefault().log(1, "tag found at pos: " + pos);
                result.append(value.substring(ppos, pos));
                ErrorManager.getDefault().log("temp. result: " + result);
                ppos = value.indexOf(TAG_END, pos);
                ErrorManager.getDefault().log("tag end found at: " + ppos);
                if (ppos == -1) {
                    ppos = pos;
                    break;
                }
                result.append(this.getTagValue(value.substring(pos + 1, ppos)));
                ErrorManager.getDefault().log(1, "added tag value, temp. result: " + result);
                ++ppos;
            }
            result.append(value.substring(ppos));
            ErrorManager.getDefault().log(1, "finished, result: " + result);
            return result.toString();
        }
        return attrValue;
    }

    private String getTagValue(String tagName) {
        ErrorManager.getDefault().log(1, "replacing tag: " + tagName);
        if (tagName.startsWith(TAG_BODY_FOLDER)) {
            String folder = tagName.substring(TAG_BODY_FOLDER.length()).replace('\\', '/');
            ErrorManager.getDefault().log(1, "found folder: " + folder);
            String resultFolder = System.getProperty("netbeans.user") + "/var/cache/" + folder;
            try {
                File result = new File(resultFolder);
                result.mkdirs();
                return resultFolder;
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return "";
            }
        }
        return TAG_START + tagName + TAG_END;
    }
}

