/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.util.StringTokenizer;
import org.netbeans.modules.java.ui.wizard.JavaPackageIterator;
import org.openide.loaders.TemplateWizard;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;
import org.openide.src.Type;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class Util {
    static TemplateWizard.Iterator packageIt;

    static String getString(String key) {
        return NbBundle.getMessage((Class)Util.class, (String)key);
    }

    static boolean isValidPackageName(String str) {
        if (str.length() > 0 && str.charAt(0) == '.') {
            return false;
        }
        StringTokenizer tukac = new StringTokenizer(str, ".");
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            if ("".equals(token)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)token)) continue;
            return false;
        }
        return true;
    }

    static boolean isValidTypeIdentifier(String ident) {
        if (ident == null || "".equals(ident)) {
            return false;
        }
        try {
            Type t = Type.parse((String)ident);
            return t.isClass();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static boolean implementsInterface(ClassElement clazz, Identifier id) {
        Identifier[] implemented = clazz.getInterfaces();
        for (int i = 0; i < implemented.length; ++i) {
            if (!implemented[i].equals((Object)id)) continue;
            return true;
        }
        return false;
    }

    public static TemplateWizard.Iterator createPackageIterator() {
        if (packageIt == null) {
            packageIt = JavaPackageIterator.create();
        }
        return packageIt;
    }
}

