/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.tools;

import java.awt.Image;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Utilities;

public class BadgeCache
extends AbstractNode {
    private Map badges;
    private static Map cacheRegister;

    public BadgeCache(String underlyingIconBase) {
        super(Children.LEAF);
        this.setIconBase(underlyingIconBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BadgeCache createCache(String baseIconID) {
        if (cacheRegister == null) {
            Class clazz = BadgeCache.class;
            synchronized (clazz) {
                if (cacheRegister == null) {
                    cacheRegister = new HashMap(7);
                }
            }
        }
        BadgeCache c = new BadgeCache(baseIconID);
        cacheRegister.put(baseIconID, new SoftReference<BadgeCache>(c));
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BadgeCache getCache(String baseIconID) {
        if (cacheRegister == null) {
            return BadgeCache.createCache(baseIconID);
        }
        Class clazz = BadgeCache.class;
        synchronized (clazz) {
            Reference r = (Reference)cacheRegister.get(baseIconID);
            BadgeCache bc = r == null ? null : (BadgeCache)((Object)r.get());
            if (bc == null) {
                return BadgeCache.createCache(baseIconID);
            }
            return bc;
        }
    }

    public synchronized void registerBadge(String id, String iconBase, int x, int y) {
        if (this.badges == null) {
            this.badges = new HashMap(7);
        }
        BadgeNode b = this.badges.put(id, new BadgeNode(iconBase, x, y));
    }

    public Image getIcon(int type, String[] badgeIds) {
        return this.createCompositeImage(this.getIcon(type), badgeIds);
    }

    public Image getIcon(Image base, String[] badgeIds) {
        if (badgeIds == null || badgeIds.length == 0) {
            return base;
        }
        return this.createCompositeImage(base, badgeIds);
    }

    protected final Image createCompositeImage(Image baseImage, String[] badgeIds) {
        if (badgeIds == null || badgeIds.length == 0) {
            return baseImage;
        }
        for (int i = 0; i < badgeIds.length; ++i) {
            BadgeNode bn = (BadgeNode)this.badges.get(badgeIds[i]);
            if (bn == null) continue;
            Image image = Utilities.loadImage((String)(bn.getIconBase() + ".gif"));
            if (image == null) {
                System.err.println("[Badging] Badge " + bn.getIconBase() + " cannot be loaded");
                continue;
            }
            baseImage = Utilities.mergeImages((Image)baseImage, (Image)image, (int)bn.getX(), (int)bn.getY());
        }
        return baseImage;
    }

    protected final Image createCompositeImage(int type, String[] badgeIds) {
        Image baseImage = this.getIcon(type);
        return this.createCompositeImage(baseImage, badgeIds);
    }

    private static class BadgeNode {
        int x;
        int y;
        String iconBase;

        public BadgeNode(String iconBase, int x, int y) {
            this.x = x;
            this.y = y;
            this.iconBase = iconBase;
        }

        public String getIconBase() {
            return this.iconBase;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

