/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.codegen;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.java.bridge.Binding;
import org.netbeans.modules.java.bridge.ImportElement;
import org.netbeans.modules.java.codegen.Clazz;
import org.netbeans.modules.java.codegen.DocumentBinding;
import org.netbeans.modules.java.codegen.ElementBinding;
import org.netbeans.modules.java.codegen.ExceptionRunnable;
import org.netbeans.modules.java.codegen.FieldB;
import org.netbeans.modules.java.codegen.ImportB;
import org.netbeans.modules.java.codegen.Initializer;
import org.netbeans.modules.java.codegen.Method;
import org.netbeans.modules.java.codegen.SourceB;
import org.openide.ErrorManager;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.FieldElement;
import org.openide.src.InitializerElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;

public class SourceText
implements DocumentBinding {
    int isAtomicAsUser;
    CloneableEditorSupport editSupport;
    DocumentBinding.Env environment;
    boolean generatorEnabled;
    Object treeLock;
    Reference refSourceRoot;
    Map bindingMap;

    public SourceText(DocumentBinding.Env sourceEnvironment) {
        this.environment = sourceEnvironment;
        this.treeLock = new Object();
    }

    public Element getElement() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SourceB getRoot() {
        SourceText sourceText = this;
        synchronized (sourceText) {
            if (this.refSourceRoot == null) {
                return null;
            }
            Object r = this.refSourceRoot.get();
            if (r == null) {
                this.refSourceRoot = null;
            }
            return (SourceB)r;
        }
    }

    public CloneableEditorSupport getEditorSupport() {
        if (this.editSupport == null) {
            this.editSupport = this.environment.findEditorSupport();
        }
        return this.editSupport;
    }

    protected synchronized void registerBinding(Element el, ElementBinding b) {
        if (this.bindingMap == null) {
            this.bindingMap = new WeakHashMap(37);
        }
        this.bindingMap.put(el, new WeakReference<ElementBinding>(b));
    }

    public void enableAtomicAsUser(boolean enable) {
        this.isAtomicAsUser = enable ? ++this.isAtomicAsUser : --this.isAtomicAsUser;
    }

    public void enableGenerator(boolean enable) {
        this.generatorEnabled = enable;
    }

    public boolean isGeneratorEnabled() {
        return this.generatorEnabled;
    }

    public StyledDocument getDocument() throws SourceException {
        try {
            return this.getEditorSupport().openDocument();
        }
        catch (IOException ex) {
            SourceText.rethrowException(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element findElement(int position) {
        SourceB sb = this.getRoot();
        if (sb == null) {
            return null;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            ElementBinding b = sb.findBindingAt(position);
            if (b == null) {
                return null;
            }
            return b.getElement();
        }
    }

    public boolean isAtomicAsUser() {
        return this.isAtomicAsUser > 0;
    }

    public void runAtomic(Runnable r) throws SourceException {
        this.runAtomic(null, r);
    }

    private void checkWritable(Element el) throws IOException {
        this.environment.takeLock();
    }

    private void runAtomic(Element el, Runnable r) throws SourceException {
        Exception[] exc = new Exception[1];
        try {
            this.checkWritable(el);
            if (this.isAtomicAsUser()) {
                NbDocument.runAtomicAsUser((StyledDocument)this.getDocument(), (Runnable)r);
            } else {
                NbDocument.runAtomic((StyledDocument)this.getDocument(), (Runnable)r);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            exc[0] = ex;
        }
        SourceText.rethrowException(el, exc[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBindings(Runnable r) {
        Object object = this.getTreeLock();
        synchronized (object) {
            r.run();
        }
    }

    protected Object getTreeLock() {
        return this.treeLock;
    }

    protected static void rethrowException(Exception ex) throws SourceException {
        SourceText.rethrowException(null, ex);
    }

    protected static void rethrowException(Element el, Exception ex) throws SourceException {
        Object x;
        if (ex == null) {
            return;
        }
        ErrorManager man = ErrorManager.getDefault();
        if (ex instanceof BadLocationException) {
            x = new SourceException.Protection(el);
            man.annotate((Throwable)x, 256, null, ex.getLocalizedMessage(), (Throwable)ex, null);
        } else if (ex instanceof IOException) {
            x = new SourceException.IO((IOException)ex);
            man.annotate((Throwable)x, 256, null, ex.getLocalizedMessage(), (Throwable)ex, null);
        } else if (ex instanceof SourceException) {
            x = (SourceException)((Object)ex);
        } else {
            x = new SourceException();
            man.annotate((Throwable)x, (Throwable)ex);
        }
        throw x;
    }

    public void runAtomic(Element el, final ExceptionRunnable r) throws SourceException {
        final Exception[] exc = new Exception[1];
        try {
            this.checkWritable(el);
        }
        catch (IOException ex) {
            SourceText.rethrowException(el, ex);
        }
        Runnable r2 = new Runnable(){

            public void run() {
                try {
                    r.run();
                }
                catch (Exception ex) {
                    exc[0] = ex;
                    throw new IllegalStateException();
                }
            }
        };
        StyledDocument doc = this.getDocument();
        if (this.isAtomicAsUser()) {
            try {
                NbDocument.runAtomicAsUser((StyledDocument)doc, (Runnable)r2);
            }
            catch (BadLocationException ex) {
                exc[0] = ex;
            }
            catch (IllegalStateException ex) {}
        } else {
            try {
                NbDocument.runAtomic((StyledDocument)doc, (Runnable)r2);
            }
            catch (IllegalStateException ex) {
                // empty catch block
            }
        }
        SourceText.rethrowException(el, exc[0]);
    }

    protected PositionRef createPos(int offset, Position.Bias bias) {
        return this.getEditorSupport().createPositionRef(offset, bias);
    }

    protected synchronized ElementBinding findBinding(Element e) {
        if (this.bindingMap == null) {
            return null;
        }
        Reference r = (Reference)this.bindingMap.get(e);
        if (r == null) {
            return null;
        }
        return (ElementBinding)r.get();
    }

    protected boolean canWriteInside(PositionBounds bounds) {
        return this.environment.findFreePosition(bounds) != null;
    }

    protected PositionRef findFreePosition(PositionBounds bounds) {
        return this.environment.findFreePosition(bounds);
    }

    public Binding.Field bindField(FieldElement impl) {
        return new FieldB(impl, this);
    }

    public Binding.Method bindMethod(MethodElement impl) {
        return new Method((ConstructorElement)impl, this);
    }

    public Binding.Method bindConstructor(ConstructorElement impl) {
        return new Method(impl, this);
    }

    public Binding.Class bindClass(ClassElement impl) {
        return new Clazz(impl, this);
    }

    public Binding.Initializer bindInitializer(InitializerElement impl) {
        return new Initializer(impl, this);
    }

    public Binding.Import bindImport(ImportElement impl) {
        return new ImportB(impl, this);
    }

    public Binding.Source bindSource(SourceElement impl) {
        SourceB sb = new SourceB(impl, this);
        this.refSourceRoot = new WeakReference<SourceB>(sb);
        return sb;
    }

    public void dumpDocument() {
        System.err.println("Document dump:");
        final StyledDocument doc = this.getEditorSupport().getDocument();
        doc.render(new Runnable(){

            public void run() {
                try {
                    String s = doc.getText(0, doc.getLength());
                    System.err.println(s);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

