/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.bridge;

import java.beans.PropertyChangeEvent;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.modules.java.bridge.DefaultLangModel;
import org.netbeans.modules.java.bridge.ElementImpl;
import org.netbeans.modules.java.bridge.ImportElement;
import org.netbeans.modules.java.bridge.SourceElementImpl;
import org.openide.src.Element;
import org.openide.src.Identifier;
import org.openide.src.SourceException;

public class ImportImpl
extends ElementImpl
implements ImportElement.Impl {
    SourceElementImpl sourceImpl;
    private ElementImpl.ElementListener importListener;
    private static final long serialVersionUID = -3319955190266278185L;

    ImportImpl(DefaultLangModel model, Import imp) {
        super(model, (RefObject)imp);
    }

    public void connectListener() {
        this.importListener = new ImportListener(this);
        this.importListener.connect();
    }

    protected void createFromModel(Element model) throws SourceException {
        ImportElement i = (ImportElement)model;
        this.setImport(i.getImport());
    }

    public void setParent(ElementImpl impl) {
        this.sourceImpl = (SourceElementImpl)impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.openide.src.Import getImport() {
        this.repository.beginTrans(false);
        try {
            if (this.javaElement.isValid()) {
                this.setClassPath();
                Import importStatement = (Import)this.javaElement;
                String impName = importStatement.getName();
                if (impName == null) {
                    impName = "";
                }
                Identifier id = Identifier.create((String)impName);
                org.openide.src.Import import_ = new org.openide.src.Import(id, importStatement.getImportedNamespace() instanceof JavaPackage);
                return import_;
            }
            org.openide.src.Import import_ = null;
            return import_;
        }
        finally {
            this.repository.endTrans(false);
        }
    }

    public SourceElementImpl findSource() {
        return this.sourceImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImport(org.openide.src.Import imp) throws SourceException {
        this.checkWritable(false);
        this.checkDocument();
        Import importStatement = (Import)this.javaElement;
        boolean failed = true;
        this.repository.beginTrans(true);
        try {
            if (this.javaElement.isValid()) {
                this.setClassPath();
                boolean isNamed = !importStatement.getName().endsWith(".*");
                String impName = importStatement.getName();
                if (isNamed == imp.isClass() && imp.getIdentifier().getSourceName().equals(impName)) {
                    failed = false;
                    return;
                }
                org.openide.src.Import old = new org.openide.src.Import(Identifier.create((String)impName), !isNamed);
                PropertyChangeEvent evt = new PropertyChangeEvent(this.getElement(), "import", old, imp);
                this.checkVetoablePropertyChange(evt);
                failed = false;
            } else {
                failed = false;
                this.throwIsInvalid();
            }
        }
        finally {
            this.repository.endTrans(failed);
        }
    }

    protected Element cloneSelf() {
        ImportElement.MemoryImpl impl = new ImportElement.MemoryImpl();
        try {
            impl.setImport(this.getImport());
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
        return new ImportElement(impl, null);
    }

    public void fireImportChange(org.openide.src.Import oldValue, org.openide.src.Import newValue) {
        if (oldValue.equals((Object)newValue)) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this.getElement(), "import", oldValue, newValue);
        this.fireOwnPropertyChange(evt);
        ImportElement old = (ImportElement)this.cloneSelf();
        try {
            old.setImport(oldValue);
        }
        catch (SourceException e) {
            e.printStackTrace();
        }
        this.notifyConnectionChange(old);
    }

    public Object readResolve() {
        return null;
    }

    public Object writeReplace() {
        return null;
    }

    protected boolean parentValid() {
        return this.sourceImpl != null && this.sourceImpl.isValid();
    }

    protected void checkWritable(boolean unsafeOp) throws SourceException {
        if (this.sourceImpl != null) {
            this.sourceImpl.checkWritable(unsafeOp);
        }
    }

    static class ImportListener
    extends ElementImpl.ElementListener {
        org.openide.src.Import value;

        ImportListener(ImportImpl impl) {
            super(impl);
            this.value = impl.getImport();
        }

        public void doChange(MDRChangeEvent event) {
            AttributeEvent attrEvent;
            String attrName;
            super.doChange(event);
            if (this.source == this.javaElement && event instanceof AttributeEvent && (attrName = (attrEvent = (AttributeEvent)event).getAttributeName()).equals("name")) {
                String name = (String)attrEvent.getNewElement();
                if (name == null) {
                    name = "";
                }
                boolean isClass = true;
                if (name.endsWith(".*")) {
                    isClass = false;
                    name = name.substring(0, name.length() - 2);
                }
                org.openide.src.Import old = this.value;
                this.value = new org.openide.src.Import(Identifier.create((String)name), isClass);
                ((ImportImpl)this.impl).fireImportChange(old, this.value);
            }
        }
    }
}

