/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.jmi.reflect.InvalidObjectException;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import org.netbeans.api.mdr.MDRObject;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.TransactionEvent;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.java.JavaEditor;
import org.netbeans.modules.java.OverrideAnnotation;
import org.netbeans.modules.java.settings.JavaSettings;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.TypeClassImpl;
import org.openide.ErrorManager;
import org.openide.cookies.LineCookie;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.RequestProcessor;

final class OverrideAnnotationSupport {
    private final JavaEditor editor;
    private WMDRChangeListener overriddenListener;
    private Request currentRequest;
    private List overrideAnnotations = new ArrayList();
    private boolean isSuspended = false;
    private static final RequestProcessor QUEUE = new RequestProcessor("Overriddens Queue", 1);
    static /* synthetic */ Class class$org$openide$cookies$LineCookie;
    static /* synthetic */ Class class$org$netbeans$modules$java$OverrideAnnotationSupport;

    public OverrideAnnotationSupport(JavaEditor editor) {
        this.editor = editor;
        this.overriddenListener = new WMDRChangeListener(this);
    }

    public void processOverriddenAnnotation() {
        this.processOverriddenAnnotation(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOverriddenAnnotation(boolean recompute) {
        if (!this.isEnabled()) {
            return;
        }
        OverrideAnnotationSupport overrideAnnotationSupport = this;
        synchronized (overrideAnnotationSupport) {
            if (this.isSuspended) {
                return;
            }
            if (this.currentRequest != null && !this.currentRequest.cancel()) {
                this.currentRequest.followMe = true;
                return;
            }
            this.currentRequest = new Request();
            QUEUE.post((Runnable)this.currentRequest, 200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        OverrideAnnotationSupport overrideAnnotationSupport = this;
        synchronized (overrideAnnotationSupport) {
            if (this.isSuspended) {
                return;
            }
            this.isSuspended = true;
            if (this.currentRequest != null && !this.currentRequest.cancel()) {
                this.currentRequest.followMe = false;
            }
        }
        Request clean = new Request(1);
        QUEUE.post((Runnable)clean);
    }

    private void dispose() {
        if (this.overriddenListener != null) {
            this.overriddenListener.removeAllElements();
        }
        OverrideAnnotationSupport.detachAnnotations(this.overrideAnnotations);
        this.overrideAnnotations.clear();
    }

    private boolean isEnabled() {
        return JavaSettings.getDefault().getShowOverriding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOverriddenAnnotation(Resource rsc, boolean recompute) {
        List unchangedOverrideAnnotations;
        if (JMManager.PERF_DEBUG) {
            Thread.dumpStack();
        }
        List originalAnnotations = recompute ? this.copyAnnotations() : this.overrideAnnotations;
        List overrideAnnotations = recompute ? this.findOverriddenMethods(rsc) : this.overrideAnnotations;
        final List addedOverrideAnnotations = recompute ? new ArrayList(overrideAnnotations) : Collections.EMPTY_LIST;
        List removedOverrideAnnotations = recompute ? new ArrayList(originalAnnotations) : Collections.EMPTY_LIST;
        List list = unchangedOverrideAnnotations = recompute ? new ArrayList(originalAnnotations) : this.overrideAnnotations;
        if (this.isSuspended) {
            return;
        }
        if (recompute) {
            addedOverrideAnnotations.removeAll(originalAnnotations);
            removedOverrideAnnotations.removeAll(overrideAnnotations);
            unchangedOverrideAnnotations.retainAll(overrideAnnotations);
            OverrideAnnotationSupport.detachAnnotations(removedOverrideAnnotations);
        }
        if (!(!this.editor.isDocumentLoaded() || addedOverrideAnnotations.isEmpty() && overrideAnnotations.isEmpty())) {
            StyledDocument doc = this.editor.getDocument();
            Runnable docRenderer = new Runnable(){

                public void run() {
                    OverrideAnnotation ann;
                    LineCookie cookie = (LineCookie)OverrideAnnotationSupport.this.editor.getDataObject().getCookie(class$org$openide$cookies$LineCookie == null ? (class$org$openide$cookies$LineCookie = OverrideAnnotationSupport.class$("org.openide.cookies.LineCookie")) : class$org$openide$cookies$LineCookie);
                    Line.Set lines = cookie.getLineSet();
                    Iterator it = addedOverrideAnnotations.iterator();
                    while (it.hasNext()) {
                        ann = (OverrideAnnotation)((Object)it.next());
                        ann.attachToLineSet(lines);
                    }
                    it = unchangedOverrideAnnotations.iterator();
                    while (it.hasNext()) {
                        ann = (OverrideAnnotation)((Object)it.next());
                        ann.updateLine(lines);
                    }
                }
            };
            if (doc != null) {
                JavaMetamodel.getDefaultRepository().beginTrans(false);
                try {
                    doc.render(docRenderer);
                }
                finally {
                    JavaMetamodel.getDefaultRepository().endTrans();
                }
            } else {
                SwingUtilities.invokeLater(docRenderer);
            }
        }
        List computedAnnotations = unchangedOverrideAnnotations;
        computedAnnotations.addAll(addedOverrideAnnotations);
        this.syncAnnotations(computedAnnotations);
    }

    private synchronized List copyAnnotations() {
        return new ArrayList(this.overrideAnnotations);
    }

    private synchronized void syncAnnotations(List l) {
        this.overrideAnnotations = l;
    }

    private void processOverriddenAnnotationImpl(boolean recompute) {
        Resource rsc = this.editor.getResource();
        if (rsc != null) {
            this.processOverriddenAnnotation(rsc, recompute);
        }
    }

    private List findOverriddenMethods(JavaClass cls, Map methods) {
        if (methods.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        ArrayList interfaces = new ArrayList();
        interfaces.addAll(cls.getInterfaces());
        JavaClass parent = cls.getSuperClass();
        HashSet<JavaClass> visited = new HashSet<JavaClass>();
        while (parent != null && visited.add(parent)) {
            if (this.isSuspended) {
                return Collections.EMPTY_LIST;
            }
            if (Modifier.isFinal(parent.getModifiers())) break;
            if (this.findOverridenMethods(parent, interfaces, methods, result)) {
                return result;
            }
            cls = parent;
            parent = cls.getSuperClass();
        }
        while (!interfaces.isEmpty()) {
            JavaClass ifc = (JavaClass)interfaces.remove(0);
            if (!visited.add(ifc) || !this.findOverridenMethods(ifc, interfaces, methods, result)) continue;
            return result;
        }
        return result;
    }

    private boolean findOverridenMethods(JavaClass parent, List interfaces, Map methods, List result) {
        this.overriddenListener.addElement(parent);
        interfaces.addAll(parent.getInterfaces());
        Iterator it = parent.getContents().iterator();
        while (it.hasNext()) {
            Method m;
            int modifiers;
            ClassMember tmp = (ClassMember)it.next();
            if (!(tmp instanceof Method) || Modifier.isStatic(modifiers = tmp.getModifiers()) || Modifier.isFinal(modifiers) || !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) || (m = (Method)methods.get(tmp)) == null) continue;
            methods.remove(m);
            result.add(new OverrideAnnotation.Descriptor((Method)tmp, m));
            if (!methods.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private Map createMethodMap(JavaClass cls, Set classes) {
        TreeMap<ClassMember, ClassMember> methods = new TreeMap<ClassMember, ClassMember>(new Comparator(){

            public int compare(Object o1, Object o2) {
                int result;
                Method m1 = (Method)o1;
                Method m2 = (Method)o2;
                int n = result = m1.getName() == null ? -1 : m1.getName().compareTo(m2.getName());
                if (result == 0) {
                    List p1 = m1.getParameters();
                    List p2 = m2.getParameters();
                    Iterator it2 = p2.iterator();
                    Iterator it1 = p1.iterator();
                    while (it1.hasNext() && result == 0) {
                        Type param1 = ((Parameter)it1.next()).getType();
                        if (it2.hasNext()) {
                            Type param2 = ((Parameter)it2.next()).getType();
                            result = OverrideAnnotationSupport.compareTypes(param1, param2);
                            continue;
                        }
                        result = -1;
                    }
                    if (result == 0 && it2.hasNext()) {
                        result = 1;
                    }
                }
                return result;
            }
        });
        Iterator it = cls.getContents().iterator();
        while (it.hasNext()) {
            ClassMember tmp = (ClassMember)it.next();
            if (tmp instanceof Method) {
                int modifiers = tmp.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers)) continue;
                methods.put(tmp, tmp);
                continue;
            }
            if (!(tmp instanceof JavaClass)) continue;
            classes.add(tmp);
        }
        return methods;
    }

    private static int compareTypes(Type type1, Type type2) {
        if (type1 == null || type1 instanceof UnresolvedClass || type1 instanceof ParameterizedType && ((ParameterizedType)type1).getDefinition() instanceof UnresolvedClass) {
            return -1;
        }
        if (type2 == null || type2 instanceof UnresolvedClass || type2 instanceof ParameterizedType && ((ParameterizedType)type2).getDefinition() instanceof UnresolvedClass) {
            return 1;
        }
        if (type1.equals(type2)) {
            return 0;
        }
        type1 = TypeClassImpl.getRawType((Type)type1);
        type2 = TypeClassImpl.getRawType((Type)type2);
        return type1.getName() == null ? -1 : type1.getName().compareTo(type2.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List findOverriddenMethods(Resource rsc) {
        JavaMetamodel.getDefaultRepository().beginTrans(false);
        try {
            JMManager m = (JMManager)JavaMetamodel.getManager();
            m.setClassPath(rsc);
            m.setSafeTrans(true);
            this.overriddenListener.addElement(rsc);
            HashSet classes = new HashSet(rsc.getClassifiers());
            ArrayList<OverrideAnnotation> result = new ArrayList<OverrideAnnotation>();
            while (!classes.isEmpty()) {
                Iterator tmp = classes.iterator();
                JavaClass cls = (JavaClass)tmp.next();
                tmp.remove();
                this.overriddenListener.addElement(cls);
                List methodsDescriptor = this.findOverriddenMethods(cls, this.createMethodMap(cls, classes));
                if (this.isSuspended) {
                    ArrayList<OverrideAnnotation> arrayList = result;
                    return arrayList;
                }
                Iterator it = methodsDescriptor.iterator();
                while (it.hasNext()) {
                    OverrideAnnotation.Descriptor descriptor = (OverrideAnnotation.Descriptor)it.next();
                    result.add(OverrideAnnotation.forDescriptor(descriptor));
                }
            }
            ArrayList<OverrideAnnotation> arrayList = result;
            return arrayList;
        }
        catch (InvalidObjectException e) {
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            JavaMetamodel.getDefaultRepository().endTrans();
        }
    }

    private static void detachAnnotations(Collection anns) {
        Iterator i = anns.iterator();
        while (i.hasNext()) {
            Annotation ann = (Annotation)i.next();
            try {
                ann.detach();
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
            }
        }
    }

    private static class WMDRChangeListener
    implements MDRChangeListener {
        private boolean refresh = false;
        private boolean recompute = false;
        OverrideAnnotationSupport support;
        private Map containers;
        private Resource rsc;

        public WMDRChangeListener(OverrideAnnotationSupport support) {
            this.support = support;
        }

        public synchronized void addElement(JavaClass cls) {
            ArrayList methods;
            if (this.containers == null || this.support.isSuspended) {
                this.containers = new HashMap();
            }
            if ((methods = (ArrayList)this.containers.get(cls)) == null) {
                methods = new ArrayList();
                Iterator it = cls.getContents().iterator();
                while (it.hasNext()) {
                    Object tmp = it.next();
                    if (!(tmp instanceof Method)) continue;
                    methods.add(tmp);
                    ((MDRObject)tmp).addListener((MDRChangeListener)this, 0x101FFFF);
                }
                this.containers.put(cls, methods);
                ((MDRObject)cls).addListener((MDRChangeListener)this, 0x101FFFF);
            }
        }

        public synchronized void addElement(Resource rsc) {
            this.rsc = rsc;
            ((MDRObject)rsc).addListener((MDRChangeListener)this, 0x101FFFF);
            JavaMetamodel.getDefaultRepository().addListener((MDRChangeListener)this, 0x110002);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateMethods(JavaClass cls) {
            JavaMetamodel.getDefaultRepository().beginTrans(false);
            try {
                WMDRChangeListener wMDRChangeListener = this;
                synchronized (wMDRChangeListener) {
                    block12: {
                        if (this.containers != null && !this.support.isSuspended) break block12;
                        return;
                    }
                    List methods = (List)this.containers.get(cls);
                    if (methods != null) {
                        Iterator it;
                        ArrayList toAdd = new ArrayList();
                        ArrayList toRemove = new ArrayList(methods);
                        if (cls.isValid()) {
                            it = cls.getContents().iterator();
                            while (it.hasNext()) {
                                Object tmp = it.next();
                                toRemove.remove(tmp);
                                if (!(tmp instanceof Method) || methods.contains(tmp)) continue;
                                toAdd.add(tmp);
                                ((MDRObject)tmp).addListener((MDRChangeListener)this, 0x101FFFF);
                            }
                            methods.addAll(toAdd);
                        }
                        methods.removeAll(toRemove);
                        it = toRemove.iterator();
                        while (it.hasNext()) {
                            MDRObject me = (MDRObject)it.next();
                            me.removeListener((MDRChangeListener)this);
                        }
                    }
                }
            }
            finally {
                JavaMetamodel.getDefaultRepository().endTrans();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAllElements() {
            JavaMetamodel.getDefaultRepository().beginTrans(false);
            try {
                WMDRChangeListener wMDRChangeListener = this;
                synchronized (wMDRChangeListener) {
                    block11: {
                        if (this.rsc != null) {
                            ((MDRObject)this.rsc).removeListener((MDRChangeListener)this);
                            JavaMetamodel.getDefaultRepository().removeListener((MDRChangeListener)this);
                            this.rsc = null;
                        }
                        if (this.containers != null) break block11;
                        return;
                    }
                    Iterator it = this.containers.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        MDRObject cls = (MDRObject)entry.getKey();
                        List methods = (List)entry.getValue();
                        cls.removeListener((MDRChangeListener)this);
                        Iterator jt = methods.iterator();
                        while (jt.hasNext()) {
                            MDRObject m = (MDRObject)jt.next();
                            m.removeListener((MDRChangeListener)this);
                        }
                        methods.clear();
                    }
                    this.containers.clear();
                }
            }
            finally {
                JavaMetamodel.getDefaultRepository().endTrans();
            }
        }

        public void change(MDRChangeEvent e) {
            if (this.support.isSuspended) {
                return;
            }
            if (e instanceof TransactionEvent) {
                if (this.refresh) {
                    this.support.processOverriddenAnnotation(this.recompute);
                    this.recompute = false;
                    this.refresh = false;
                }
                return;
            }
            if (e.getSource() instanceof Element && !((Element)e.getSource()).isValid()) {
                return;
            }
            AttributeEvent event = (AttributeEvent)e;
            String attrName = event.getAttributeName();
            this.refresh = true;
            if (event.getSource() instanceof JavaClass) {
                if ("contents".equals(attrName) && (event.getNewElement() instanceof Method || event.getOldElement() instanceof Method)) {
                    this.updateMethods((JavaClass)event.getSource());
                    this.recompute = true;
                } else if ("superClassName".equals(attrName) || "interfaceNames".equals(attrName)) {
                    if (this.containers.containsKey(event.getSource())) {
                        this.removeAllElements();
                    }
                    this.recompute = true;
                }
            } else if (event.getSource() instanceof Method && ("name".equals(attrName) || "modifiers".equals(attrName) || "parameters".equals(attrName) || "typeName".equals(attrName))) {
                this.recompute = true;
            }
        }
    }

    private class Request
    implements Runnable {
        private boolean isCanceled = false;
        private boolean isRunning = false;
        private boolean followMe = false;
        private final int type;
        private static final int DEFAULT = 0;
        private static final int CLEAN = 1;
        private static final int REFRESH = 2;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Request() {
            this(0);
        }

        public Request(int type) {
            this.type = type;
        }

        public void run() {
            switch (this.type) {
                case 0: {
                    this.computeAnnotations(true);
                    break;
                }
                case 2: {
                    this.computeAnnotations(false);
                    break;
                }
                case 1: {
                    OverrideAnnotationSupport.this.dispose();
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)("Invalid request type: " + this.type));
                    }
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void computeAnnotations(boolean recompute) {
            if (this.isCanceled) {
                return;
            }
            try {
                this.isRunning = true;
                OverrideAnnotationSupport.this.processOverriddenAnnotationImpl(recompute);
            }
            finally {
                this.isRunning = false;
            }
            OverrideAnnotationSupport overrideAnnotationSupport = OverrideAnnotationSupport.this;
            synchronized (overrideAnnotationSupport) {
                if (this.followMe) {
                    this.followMe = false;
                    OverrideAnnotationSupport.this.processOverriddenAnnotation(recompute);
                }
            }
        }

        public boolean cancel() {
            this.isCanceled = true;
            return !this.isRunning;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$OverrideAnnotationSupport == null ? (class$org$netbeans$modules$java$OverrideAnnotationSupport = OverrideAnnotationSupport.class$("org.netbeans.modules.java.OverrideAnnotationSupport")) : class$org$netbeans$modules$java$OverrideAnnotationSupport).desiredAssertionStatus();
        }
    }
}

