/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.JmiException;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.ErrorInfo;
import org.netbeans.jmi.javamodel.ErrorTypeEnum;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.JavaUpToDateStatusProvider;
import org.netbeans.modules.java.OverrideAnnotationSupport;
import org.netbeans.modules.java.ParserAnnotation;
import org.netbeans.modules.java.Util;
import org.netbeans.modules.java.settings.JavaSettings;
import org.netbeans.modules.java.ui.nodes.SourceNodeFactory;
import org.netbeans.modules.java.ui.nodes.SourceNodes;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.RepositoryUpdater;
import org.netbeans.modules.javacore.RequestPoster;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.ParsingListener;
import org.netbeans.modules.javacore.internalapi.UndoManager;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.SourceElement;
import org.openide.text.Annotation;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;

public class JavaEditor
extends DataEditorSupport
implements PropertyChangeListener,
Node.Cookie,
OpenCookie,
EditorCookie.Observable,
CloseCookie,
PrintCookie {
    static final String MAGIC_PREFIX = "//GEN-";
    private static String[] SECTION_MAGICS;
    private static final int LONGEST_ITEM = 10;
    private boolean shouldReload = false;
    private boolean wasReloaded = false;
    private static final int T_LINE = 0;
    private static final int T_BEGIN = 1;
    private static final int T_END = 2;
    private static final int T_HEADER = 3;
    private static final int T_HEADEREND = 4;
    private static final int T_FIRST = 5;
    private static final int T_LAST = 6;
    HashMap sections = null;
    Timer timer;
    static final byte NEW_LINE_N = 0;
    static final byte NEW_LINE_R = 1;
    static final byte NEW_LINE_RN = 2;
    byte newLineType;
    private transient boolean hasAnnotations = false;
    private boolean reloading = false;
    private static final Comparator SECTION_COMPARATOR;
    private ArrayList errorAnnotations = new ArrayList();
    private static final RequestProcessor ERROR_ANNOTATION_QUEUE;
    private boolean parsingAttached;
    private ParsingListener wParsingL;
    private OverrideAnnotationSupport overriddensSupport;
    private Reference sourceClasspath;
    private Reference librariesClasspath;
    private Reference bootClasspath;
    private UndoRedo.Manager undoRedo = null;
    private boolean undoRedoPrecreated = false;
    private transient String resourceMofId = null;
    private transient WeakReference resource = null;
    private final ParsingListener listener = new ParsingListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceParsed(Resource resource) {
            JavaMetamodel.getDefaultRepository().beginTrans(false);
            try {
                if (resource == JavaEditor.this.getResource()) {
                    JavaEditor.this.notifyParsingDone();
                }
            }
            finally {
                JavaMetamodel.getDefaultRepository().endTrans();
            }
        }
    };
    private boolean forceParseOnComponentActivated = false;
    static /* synthetic */ Class class$org$openide$cookies$LineCookie;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;
    static /* synthetic */ Class class$org$netbeans$jmi$javamodel$Element;

    public JavaEditor(DataObject dob) {
        super(dob, (CloneableEditorSupport.Env)new JavaEditorEnv(dob));
        this.addChangeListener(new JavaEditorChangeListener());
        JavaMetamodel.getUndoManager().addPropertyChangeListener((PropertyChangeListener)new UndoManagerListener(this));
    }

    private void changeTimeoutElapsed() {
        this.parseSource(false, true);
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        JavaDataObject obj = (JavaDataObject)this.getDataObject();
        if (obj.getCookie(SaveCookie.class) == null) {
            obj.addSaveCookie(new Save());
        }
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        JavaDataObject obj = (JavaDataObject)this.getDataObject();
        SaveCookie save = (SaveCookie)obj.getCookie(SaveCookie.class);
        if (save != null) {
            obj.removeSaveCookie(save);
        }
    }

    private void parseSource(final boolean force, final boolean refreshAnnotations) {
        ERROR_ANNOTATION_QUEUE.post(new Runnable(){

            public void run() {
                ResourceImpl resource;
                if (force) {
                    JavaMetamodel.getManager().addModified(JavaEditor.this.getDataObject().getPrimaryFile());
                } else if (JavaEditor.this.forceParseOnComponentActivated && (resource = (ResourceImpl)JavaEditor.this.getResource()) != null) {
                    resource.resetErrors();
                }
                StyledDocument doc = JavaEditor.this.getDocument();
                if (doc != null) {
                    JavaUpToDateStatusProvider.get(doc).notifyParsingStarted();
                }
                JavaMetamodel.getDefaultRepository().beginTrans(true);
                JavaMetamodel.getDefaultRepository().endTrans(false);
                if (refreshAnnotations) {
                    JavaEditor.this.refreshAnnotations();
                }
                if (doc != null) {
                    JavaUpToDateStatusProvider.get(doc).notifyParsingFinished();
                }
            }
        });
    }

    private void classpathChanged() {
        this.parseSource(true, true);
    }

    private void parsingErrorsChanged(PropertyChangeEvent evt) {
        int errors = JavaSettings.getDefault().getParsingErrors();
        Integer old = (Integer)evt.getOldValue();
        int oldErrors = 100;
        if (old != null) {
            oldErrors = old;
        }
        if (oldErrors == errors) {
            return;
        }
        if (errors == 0 && !this.errorAnnotations.isEmpty()) {
            JavaEditor.detachAnnotations(this.errorAnnotations);
            this.errorAnnotations.clear();
            return;
        }
        if (oldErrors == this.errorAnnotations.size() || errors < this.errorAnnotations.size()) {
            this.refreshAnnotations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showOverridingChanged(PropertyChangeEvent event) {
        if (this.getOpenedPanes() == null) {
            return;
        }
        boolean newValue = JavaSettings.getDefault().getShowOverriding();
        if (newValue) {
            this.overriddensSupport.processOverriddenAnnotation();
        } else {
            JavaEditor javaEditor = this;
            synchronized (javaEditor) {
                this.overriddensSupport.suspend();
                this.overriddensSupport = new OverrideAnnotationSupport(this);
            }
        }
    }

    private synchronized void attachParsingListener() {
        if (!this.parsingAttached) {
            if (this.wParsingL == null) {
                this.wParsingL = new WParsingListener(this.listener);
            }
            JavaMetamodel.addParsingListener((ParsingListener)this.wParsingL);
            this.parsingAttached = true;
        }
        if (this.overriddensSupport == null) {
            this.overriddensSupport = new OverrideAnnotationSupport(this);
        }
    }

    private synchronized void removeParsingListener() {
        if (this.parsingAttached) {
            JavaMetamodel.removeParsingListener((ParsingListener)this.wParsingL);
            this.parsingAttached = false;
        }
    }

    void restartTimer(boolean onlyIfRunning) {
        this.restartTimer(onlyIfRunning, false);
    }

    private void restartTimer(boolean onlyIfRunning, boolean componentActivated) {
        int delay;
        boolean timerRunning;
        boolean bl = timerRunning = this.timer != null && this.timer.isRunning();
        if (onlyIfRunning && !timerRunning) {
            return;
        }
        if (!onlyIfRunning) {
            this.forceParseOnComponentActivated = componentActivated;
        }
        if ((delay = JavaSettings.getDefault().getAutoParsingDelay()) <= 0) {
            return;
        }
        if (this.timer == null) {
            this.timer = new Timer(0, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JavaEditor.this.changeTimeoutElapsed();
                }
            });
            this.timer.setRepeats(false);
        }
        this.timer.setInitialDelay(delay);
        this.timer.restart();
    }

    private void stopTimerIfPossible() {
        if (this.forceParseOnComponentActivated && this.timer != null) {
            this.timer.stop();
        }
    }

    public void openAtPosition(PositionRef begin) {
        this.openAt(begin, -1).getComponent().requestActive();
    }

    public void openAt(PositionRef p) {
        this.openAtPosition(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyClosed() {
        JavaEditor javaEditor = this;
        synchronized (javaEditor) {
            this.removeParsingListener();
            if (this.overriddensSupport != null) {
                this.overriddensSupport.suspend();
            }
            this.overriddensSupport = null;
            this.hasAnnotations = false;
        }
        boolean wasModified = this.isModified();
        CloneableTopComponent.Ref ref = this.allEditors;
        synchronized (ref) {
            super.notifyClosed();
            this.clearSections();
        }
        if (wasModified) {
            this.parseSource(true, false);
        }
    }

    protected void notifyParsingDone() {
    }

    private void refreshAnnotations() {
        Resource r;
        ((JMManager)JMManager.getManager()).waitScanFinished();
        if (JMManager.PERF_DEBUG) {
            Thread.dumpStack();
        }
        if ((r = this.getResource()) != null) {
            try {
                final List errors = r.getErrors();
                errors.size();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JavaEditor.this.processAnnotations(errors);
                    }
                });
            }
            catch (InvalidObjectException invalidObjectException) {
                // empty catch block
            }
        }
    }

    public Resource getResource() {
        Resource result;
        Resource resource = result = this.resource == null ? null : (Resource)this.resource.get();
        if (result != null) {
            try {
                result.refImmediateComposite();
            }
            catch (InvalidObjectException e) {
                this.resourceMofId = null;
                result = null;
            }
        }
        if (result == null || !result.isValid()) {
            if (this.resourceMofId != null) {
                result = (Resource)JavaMetamodel.getDefaultRepository().getByMofId(this.resourceMofId);
            }
            if (result == null || !result.isValid()) {
                result = JavaMetamodel.getManager().getResource(this.getDataObject().getPrimaryFile());
                if (result == null) {
                    return null;
                }
                this.resourceMofId = result.refMofId();
            }
            this.resource = new WeakReference<Resource>(result);
        }
        return result;
    }

    protected void loadFromStreamToKit(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
        this.sections = new HashMap(10);
        GuardedReader reader = new GuardedReader(stream, false, Util.getFileEncoding(this.getDataObject().getPrimaryFile()));
        kit.read(reader, (Document)doc, 0);
        this.fillSections(reader, doc);
        this.newLineType = reader.getNewLineType();
        boolean forceUpdate = this.reloading;
        this.reloading = false;
        if (forceUpdate) {
            ERROR_ANNOTATION_QUEUE.post(new Runnable(){

                public void run() {
                    JavaEditor.this.refreshAnnotations();
                }
            });
        }
    }

    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        ArrayList list;
        NewLineOutputStream os = new NewLineOutputStream(stream, this.newLineType);
        String encoding = Util.getFileEncoding(this.getDataObject().getPrimaryFile());
        if (this.sections != null && (list = new ArrayList(this.sections.values())).size() > 0) {
            GuardedWriter writer = new GuardedWriter(os, list, encoding);
            kit.write(writer, (Document)doc, 0, doc.getLength());
            return;
        }
        OutputStreamWriter w = encoding == null ? new OutputStreamWriter(os) : new OutputStreamWriter((OutputStream)os, encoding);
        kit.write(w, (Document)doc, 0, doc.getLength());
    }

    public void saveDocument() throws IOException {
        this.saveDocument(true);
        if (this.shouldReload) {
            this.reloadDocument();
            this.shouldReload = false;
            this.wasReloaded = true;
        }
    }

    private void saveDocument(boolean forceSave) throws IOException {
        if (forceSave || this.isModified()) {
            if (!this.checkCharsetConversion(Util.getFileEncoding(this.getDataObject().getPrimaryFile()))) {
                return;
            }
            RepositoryUpdater.getDefault().addFileObjectToSave(this.getDataObject().getPrimaryFile());
            super.saveDocument();
        }
    }

    private boolean checkCharsetConversion(String encoding) {
        if (encoding == null) {
            return true;
        }
        boolean value = true;
        try {
            CharsetEncoder coder = Charset.forName(encoding).newEncoder();
            if (!coder.canEncode(this.getDocument().getText(0, this.getDocument().getLength()))) {
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)JavaEditor.class, (String)"MSG_BadCharConversion", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), encoding}), 0, 2);
                nd.setValue(NotifyDescriptor.NO_OPTION);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                    value = false;
                }
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return value;
    }

    private void processAnnotations(List errors) {
        Collection newAnnotations = this.getAnnotations(errors);
        ArrayList added = new ArrayList(newAnnotations);
        added.removeAll(this.errorAnnotations);
        ArrayList unchanged = new ArrayList(this.errorAnnotations);
        unchanged.retainAll(newAnnotations);
        ArrayList removed = this.errorAnnotations;
        removed.removeAll(newAnnotations);
        JavaEditor.detachAnnotations(removed);
        if (!added.isEmpty() && this.isDocumentLoaded()) {
            final ArrayList finalAdded = added;
            StyledDocument doc = this.getDocument();
            Runnable docRenderer = new Runnable(){

                public void run() {
                    LineCookie cookie = (LineCookie)JavaEditor.this.getDataObject().getCookie(class$org$openide$cookies$LineCookie == null ? (class$org$openide$cookies$LineCookie = JavaEditor.class$("org.openide.cookies.LineCookie")) : class$org$openide$cookies$LineCookie);
                    Line.Set lines = cookie.getLineSet();
                    Iterator i = finalAdded.iterator();
                    while (i.hasNext()) {
                        ParserAnnotation ann = (ParserAnnotation)i.next();
                        ann.attachToLineSet(lines);
                    }
                }
            };
            if (doc != null) {
                doc.render(docRenderer);
            } else {
                docRenderer.run();
            }
        }
        this.errorAnnotations = unchanged;
        this.errorAnnotations.addAll(added);
    }

    private Collection getAnnotations(List errors) {
        HashMap<Integer, ParserAnnotation> map = new HashMap<Integer, ParserAnnotation>(2 * errors.size());
        int maxErrors = JavaSettings.getDefault().getParsingErrors();
        Iterator it = errors.iterator();
        while (it.hasNext()) {
            ErrorInfo err = (ErrorInfo)it.next();
            int line = err.getLineNumber();
            if (line <= 0) continue;
            int column = err.getColumn();
            String message = err.getDescription();
            ParserAnnotation anno = new ParserAnnotation(line, column, err.getSeverity(), message);
            Integer lineInt = new Integer(line);
            ParserAnnotation prev = (ParserAnnotation)map.get(lineInt);
            if (prev != null) {
                if (prev.getSeverity().equals(ErrorTypeEnum.WARNING)) {
                    map.put(lineInt, anno);
                    anno.chain(prev);
                    continue;
                }
                prev.chain(anno);
                continue;
            }
            if (map.size() >= maxErrors) continue;
            map.put(lineInt, anno);
        }
        return map.values();
    }

    private static void detachAnnotations(Collection anns) {
        Iterator i = anns.iterator();
        while (i.hasNext()) {
            Annotation ann = (Annotation)i.next();
            if (ann.getAttachedAnnotatable() == null) continue;
            ann.detach();
        }
    }

    private ClassPath getBootClassPath() {
        ClassPath result;
        if ((this.bootClasspath == null || (result = (ClassPath)this.bootClasspath.get()) == null) && (result = ClassPath.getClassPath((FileObject)this.getDataObject().getPrimaryFile(), (String)"classpath/boot")) != null) {
            this.bootClasspath = new WeakReference<ClassPath>(result);
        }
        return result;
    }

    private ClassPath getLibrariesPath() {
        ClassPath result;
        if ((this.librariesClasspath == null || (result = (ClassPath)this.librariesClasspath.get()) == null) && (result = ClassPath.getClassPath((FileObject)this.getDataObject().getPrimaryFile(), (String)"classpath/compile")) != null) {
            this.librariesClasspath = new WeakReference<ClassPath>(result);
        }
        return result;
    }

    private ClassPath getSourcePath() {
        ClassPath result;
        if (this.sourceClasspath == null || (result = (ClassPath)this.sourceClasspath.get()) == null) {
            result = ClassPath.getClassPath((FileObject)this.getDataObject().getPrimaryFile(), (String)"classpath/source");
            this.sourceClasspath = new WeakReference<ClassPath>(result);
        }
        return result;
    }

    public SourceElement getSource() {
        return ((JavaDataObject)this.getDataObject()).getSource();
    }

    public Element sourceToText(org.openide.src.Element element) {
        return null;
    }

    public org.openide.src.Element textToSource(Element element) throws NoSuchElementException {
        throw new NoSuchElementException();
    }

    public org.openide.src.Element findElement(int offset) {
        return null;
    }

    public SimpleSection createSimpleSection(PositionRef pos, String name) throws IllegalArgumentException, BadLocationException {
        this.checkOverlap(pos);
        return this.doCreateSimpleSection(pos, name);
    }

    public SimpleSection createSimpleSection(PositionBounds bounds, String name) throws IllegalArgumentException, BadLocationException {
        this.checkOverlap(bounds);
        return this.doCreateSimpleSection(bounds, name);
    }

    private void checkOverlap(PositionRef pos) {
        Iterator it = this.sections.values().iterator();
        while (it.hasNext()) {
            GuardedSection s = (GuardedSection)it.next();
            if (!s.contains(pos, false)) continue;
            throw new IllegalArgumentException("Sections overlap");
        }
    }

    public boolean testOverlap(PositionBounds bounds) {
        try {
            this.openDocument();
        }
        catch (IOException e) {
            throw new IllegalArgumentException();
        }
        try {
            this.checkOverlap(bounds, true);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private void checkOverlap(PositionBounds bounds) throws IllegalArgumentException {
        this.checkOverlap(bounds, false);
    }

    private void checkOverlap(PositionBounds bounds, boolean allowHoles) throws IllegalArgumentException {
        TreeSet c = new TreeSet(new GuardedPositionComparator());
        c.addAll(this.sections.values());
        Iterator it = c.iterator();
        PositionRef begin = bounds.getBegin();
        PositionRef end = bounds.getEnd();
        int beginOffset = begin.getOffset();
        int endOffset = end.getOffset();
        Object starting = null;
        boolean overlapOK = false;
        while (it.hasNext()) {
            GuardedSection s = (GuardedSection)it.next();
            if (s.contains(begin, allowHoles) || s.contains(end, allowHoles)) {
                throw new IllegalArgumentException("Sections overlap");
            }
            if (s.getBegin().getOffset() <= beginOffset) continue;
            if (s.getBegin().getOffset() >= endOffset) break;
            throw new IllegalArgumentException("Sections overlap");
        }
    }

    private SimpleSection doCreateSimpleSection(final PositionBounds bounds, final String name) throws IllegalArgumentException, BadLocationException {
        StyledDocument loadedDoc = null;
        try {
            loadedDoc = this.openDocument();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot load document");
        }
        final StyledDocument doc = loadedDoc;
        final SimpleSection[] sect = new SimpleSection[]{null};
        Util.ExceptionRunnable run = new Util.ExceptionRunnable(){

            public void run() throws Exception {
                sect[0] = new SimpleSection(name, JavaEditor.this.createBounds(bounds.getBegin().getOffset(), bounds.getEnd().getOffset(), false));
                JavaEditor.this.sections.put(sect[0].getName(), sect[0]);
                sect[0].markGuarded(doc);
            }
        };
        try {
            Util.runAtomic(doc, run);
            this.notifyModified();
        }
        catch (Exception e) {
            if (e instanceof BadLocationException) {
                throw (BadLocationException)e;
            }
            throw new IllegalArgumentException();
        }
        return sect[0];
    }

    private SimpleSection doCreateSimpleSection(final PositionRef pos, final String name) throws IllegalArgumentException, BadLocationException {
        StyledDocument loadedDoc = null;
        try {
            loadedDoc = this.openDocument();
        }
        catch (IOException e) {
            throw new IllegalArgumentException();
        }
        final StyledDocument doc = loadedDoc;
        final SimpleSection[] sect = new SimpleSection[]{null};
        Util.ExceptionRunnable run = new Util.ExceptionRunnable(){

            public void run() throws Exception {
                int where = pos.getOffset();
                doc.insertString(where, "\n \n", null);
                sect[0] = new SimpleSection(name, JavaEditor.this.createBounds(where + 1, where + 3, false));
                JavaEditor.this.sections.put(sect[0].getName(), sect[0]);
                sect[0].markGuarded(doc);
            }
        };
        try {
            Util.runAtomic(doc, run);
            this.notifyModified();
        }
        catch (Exception e) {
            if (e instanceof BadLocationException) {
                throw (BadLocationException)e;
            }
            throw new IllegalArgumentException();
        }
        return sect[0];
    }

    public SimpleSection createSimpleSectionAfter(GuardedSection previous, String name) throws IllegalArgumentException, BadLocationException {
        PositionBounds bounds = previous instanceof SimpleSection ? ((SimpleSection)previous).bounds : ((InteriorSection)previous).bottom;
        if (previous == null || !previous.valid) {
            throw new IllegalArgumentException("Invalid guarded block");
        }
        return this.doCreateSimpleSection(bounds.getEnd(), name);
    }

    public InteriorSection createInteriorSection(PositionRef pos, String name) throws IllegalArgumentException, BadLocationException {
        this.checkOverlap(pos);
        return this.doCreateInteriorSection(pos, name);
    }

    public InteriorSection createInteriorSectionAfter(GuardedSection previous, String name) throws IllegalArgumentException, BadLocationException {
        PositionBounds bounds = previous instanceof SimpleSection ? ((SimpleSection)previous).bounds : ((InteriorSection)previous).bottom;
        if (previous == null || !previous.valid) {
            throw new IllegalArgumentException("Invalid guarded block");
        }
        return this.doCreateInteriorSection(bounds.getEnd(), name);
    }

    public InteriorSection createInteriorSection(PositionBounds bounds, PositionBounds interior, String name) throws IllegalArgumentException, BadLocationException {
        this.checkOverlap(bounds);
        if (bounds.getBegin().getOffset() > interior.getEnd().getOffset() || bounds.getEnd().getOffset() < interior.getEnd().getOffset()) {
            throw new IllegalArgumentException("Interior is not nested.");
        }
        return this.doCreateInteriorSection(bounds, interior, name);
    }

    private InteriorSection doCreateInteriorSection(final PositionBounds bounds, final PositionBounds interiorBounds, final String name) throws IllegalArgumentException, BadLocationException {
        StyledDocument loadedDoc = null;
        try {
            loadedDoc = this.openDocument();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot load document");
        }
        final StyledDocument doc = loadedDoc;
        final InteriorSection[] sect = new InteriorSection[]{null};
        Util.ExceptionRunnable run = new Util.ExceptionRunnable(){

            public void run() {
                sect[0] = new InteriorSection(name, JavaEditor.this.createBounds(bounds.getBegin().getOffset(), interiorBounds.getBegin().getOffset(), false), JavaEditor.this.createBounds(interiorBounds.getBegin().getOffset(), interiorBounds.getEnd().getOffset(), true), JavaEditor.this.createBounds(interiorBounds.getEnd().getOffset(), bounds.getEnd().getOffset(), false));
                JavaEditor.this.sections.put(sect[0].getName(), sect[0]);
                sect[0].markGuarded(doc);
            }
        };
        try {
            Util.runAtomic(doc, run);
            this.notifyModified();
        }
        catch (Exception e) {
            if (e instanceof BadLocationException) {
                throw (BadLocationException)e;
            }
            throw new IllegalArgumentException();
        }
        return sect[0];
    }

    private InteriorSection doCreateInteriorSection(final PositionRef pos, final String name) throws IllegalArgumentException, BadLocationException {
        StyledDocument loadedDoc = null;
        try {
            loadedDoc = this.openDocument();
        }
        catch (IOException e) {
            throw new IllegalArgumentException();
        }
        final StyledDocument doc = loadedDoc;
        final InteriorSection[] sect = new InteriorSection[]{null};
        Util.ExceptionRunnable run = new Util.ExceptionRunnable(){

            public void run() throws Exception {
                int where = pos.getOffset();
                doc.insertString(where, "\n \n \n \n", null);
                sect[0] = new InteriorSection(name, JavaEditor.this.createBounds(where + 1, where + 3, false), JavaEditor.this.createBounds(where + 3, where + 5, true), JavaEditor.this.createBounds(where + 5, where + 7, false));
                JavaEditor.this.sections.put(sect[0].getName(), sect[0]);
                sect[0].markGuarded(doc);
            }
        };
        try {
            Util.runAtomic(doc, run);
            this.notifyModified();
        }
        catch (Exception e) {
            if (e instanceof BadLocationException) {
                throw (BadLocationException)e;
            }
            throw new IllegalArgumentException();
        }
        return sect[0];
    }

    public SimpleSection findSimpleSection(String name) {
        GuardedSection s = this.findSection(name);
        return s instanceof SimpleSection ? (SimpleSection)s : null;
    }

    public InteriorSection findInteriorSection(String name) {
        GuardedSection s = this.findSection(name);
        return s instanceof InteriorSection ? (InteriorSection)s : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GuardedSection findSection(String name) {
        try {
            StyledDocument doc = this.openDocument();
            JavaEditor javaEditor = this;
            synchronized (javaEditor) {
                if (this.sections != null) {
                    return (GuardedSection)this.sections.get(name);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getGuardedSections() {
        try {
            StyledDocument doc = this.openDocument();
            JavaEditor javaEditor = this;
            synchronized (javaEditor) {
                if (this.sections != null) {
                    return ((HashMap)this.sections.clone()).values().iterator();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.EMPTY_SET.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getGuardedSectionNames() {
        try {
            StyledDocument doc = this.openDocument();
            JavaEditor javaEditor = this;
            synchronized (javaEditor) {
                if (this.sections != null) {
                    return ((HashMap)this.sections.clone()).keySet().iterator();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Collections.EMPTY_SET.iterator();
    }

    public PositionRef findFreePosition(PositionBounds bnds) {
        GuardedSection s;
        PositionRef start;
        try {
            StyledDocument doc = this.openDocument();
        }
        catch (IOException ex) {
            return null;
        }
        PositionRef beginPos = bnds.getBegin();
        int startOffs = beginPos.getOffset();
        TreeSet set = new TreeSet(SECTION_COMPARATOR);
        set.addAll(this.sections.values());
        Iterator it = set.iterator();
        while (it.hasNext() && (start = (s = (GuardedSection)it.next()).getBegin()).getOffset() <= startOffs) {
            if (!s.contains(beginPos, false)) continue;
            PositionRef after = s.getPositionAfter();
            if (after.getOffset() > bnds.getEnd().getOffset()) {
                return null;
            }
            return after;
        }
        return beginPos;
    }

    protected CloneableEditor createCloneableEditor() {
        return new JavaEditorComponent((CloneableEditorSupport)this);
    }

    synchronized void clearSections() {
        if (this.sections != null) {
            Iterator it = ((HashMap)this.sections.clone()).values().iterator();
            while (it.hasNext()) {
                GuardedSection sect = (GuardedSection)it.next();
                sect.valid = false;
            }
            this.sections = null;
        }
    }

    PositionRef findUnguarded(PositionRef fromWhere, boolean allowHoles, boolean after) {
        Iterator it = this.getGuardedSections();
        while (it.hasNext()) {
            GuardedSection sect = (GuardedSection)it.next();
            if (!sect.contains(fromWhere, allowHoles)) continue;
            if (after) {
                return sect.getPositionAfter();
            }
            return sect.getPositionBefore();
        }
        return fromWhere;
    }

    private void fillSections(GuardedReader is, StyledDocument doc) {
        SectionDesc descBegin = null;
        Iterator it = is.list.iterator();
        while (it.hasNext()) {
            SectionDesc descCurrent = (SectionDesc)it.next();
            GuardedSection sect = null;
            switch (descCurrent.type) {
                case 0: {
                    sect = new SimpleSection(descCurrent.name, this.createBounds(descCurrent.begin, descCurrent.end, false));
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    descBegin = descCurrent;
                    break;
                }
                case 4: {
                    if (descBegin != null && (descBegin.type == 3 || descBegin.type == 5) && descCurrent.name.equals(descBegin.name)) {
                        descBegin.end = descCurrent.end;
                        break;
                    }
                    descBegin = null;
                    break;
                }
                case 2: 
                case 6: {
                    if (descBegin != null && descBegin.name.equals(descCurrent.name)) {
                        if (descBegin.type == 1 && descCurrent.type == 2) {
                            sect = new SimpleSection(descCurrent.name, this.createBounds(descBegin.begin, descCurrent.end, false));
                            break;
                        }
                        if (descBegin.type == 5 && descCurrent.type == 6 || descBegin.type == 3 && descCurrent.type == 2) {
                            sect = new InteriorSection(descCurrent.name, this.createBounds(descBegin.begin, descBegin.end, false), this.createBounds(descBegin.end, descCurrent.begin, true), this.createBounds(descCurrent.begin, descCurrent.end, false));
                            break;
                        }
                    }
                    descBegin = null;
                }
            }
            if (sect == null) continue;
            this.sections.put(sect.getName(), sect);
            descBegin = null;
            sect.markGuarded(doc);
        }
    }

    public PositionBounds createBounds(int begin, int end, boolean dir) {
        if (!dir) {
            return new PositionBounds(this.createPositionRef(begin, Position.Bias.Forward), this.createPositionRef(end, Position.Bias.Backward));
        }
        return new PositionBounds(this.createPositionRef(begin, Position.Bias.Backward), this.createPositionRef(end, Position.Bias.Forward));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        UndoManager undo = JavaMetamodel.getUndoManager();
        if (undo.isUndoAvailable() || undo.isRedoAvailable()) {
            this.getUndoRedo().discardAllEdits();
        }
    }

    static {
        StringBuffer sb = new StringBuffer(MAGIC_PREFIX);
        int size = sb.length();
        SECTION_MAGICS = new String[7];
        JavaEditor.SECTION_MAGICS[0] = sb.append("LINE:").toString();
        sb.setLength(size);
        JavaEditor.SECTION_MAGICS[1] = sb.append("BEGIN:").toString();
        sb.setLength(size);
        JavaEditor.SECTION_MAGICS[2] = sb.append("END:").toString();
        sb.setLength(size);
        JavaEditor.SECTION_MAGICS[3] = sb.append("HEADER:").toString();
        sb.setLength(size);
        JavaEditor.SECTION_MAGICS[4] = sb.append("HEADEREND:").toString();
        sb.setLength(size);
        JavaEditor.SECTION_MAGICS[5] = sb.append("FIRST:").toString();
        sb.setLength(size);
        JavaEditor.SECTION_MAGICS[6] = sb.append("LAST:").toString();
        SECTION_COMPARATOR = new GuardedPositionComparator();
        ERROR_ANNOTATION_QUEUE = new RequestProcessor("Error Annotation Queue", 1);
    }

    private static class UndoManagerListener
    implements PropertyChangeListener {
        private WeakReference ref;

        UndoManagerListener(JavaEditor editor) {
            this.ref = new ActiveQueueReference(editor, Utilities.activeReferenceQueue());
        }

        public void propertyChange(PropertyChangeEvent evt) {
            UndoManager undo = JavaMetamodel.getUndoManager();
            JavaEditor editor = (JavaEditor)this.ref.get();
            if (editor == null) {
                undo.removePropertyChangeListener((PropertyChangeListener)this);
                return;
            }
            if (undo.isUndoAvailable() || undo.isRedoAvailable()) {
                editor.getUndoRedo().discardAllEdits();
            }
        }

        private class ActiveQueueReference
        extends WeakReference
        implements Runnable {
            public ActiveQueueReference(Object o, ReferenceQueue q) {
                super(o, q);
            }

            public void run() {
                UndoManager undo = JavaMetamodel.getUndoManager();
                undo.removePropertyChangeListener((PropertyChangeListener)UndoManagerListener.this);
            }
        }
    }

    static class WParsingListener
    extends WeakReference
    implements ParsingListener,
    Runnable {
        WParsingListener(ParsingListener orig) {
            super(orig, Utilities.activeReferenceQueue());
        }

        public void run() {
            JavaMetamodel.removeParsingListener((ParsingListener)this);
        }

        ParsingListener getListener() {
            Object o = this.get();
            if (o == null) {
                JavaMetamodel.removeParsingListener((ParsingListener)this);
            }
            return (ParsingListener)o;
        }

        public void resourceParsed(Resource rsc) {
            ParsingListener l = this.getListener();
            if (l != null) {
                l.resourceParsed(rsc);
            }
        }
    }

    private static class NewLineOutputStream
    extends OutputStream {
        OutputStream stream;
        byte newLineType;

        public NewLineOutputStream(OutputStream stream, byte newLineType) {
            this.stream = stream;
            this.newLineType = newLineType;
        }

        public void write(int b) throws IOException {
            if (b == 10) {
                switch (this.newLineType) {
                    case 1: {
                        this.stream.write(13);
                        break;
                    }
                    case 2: {
                        this.stream.write(13);
                    }
                    case 0: {
                        this.stream.write(10);
                    }
                }
            } else {
                this.stream.write(b);
            }
        }
    }

    class GuardedWriter
    extends Writer {
        BufferedWriter writer;
        Iterator sections;
        SectionDesc current;
        int offsetCounter;
        boolean wasNewLine;
        int spaces;

        GuardedWriter(OutputStream os, ArrayList list, String encoding) throws IOException {
            this.writer = encoding == null ? new BufferedWriter(new OutputStreamWriter(os)) : new BufferedWriter(new OutputStreamWriter(os, encoding));
            this.offsetCounter = 0;
            this.sections = this.prepareSections(list);
            this.nextSection();
            this.wasNewLine = false;
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                this.writeOneChar(cbuf[i + off]);
            }
        }

        public void close() throws IOException {
            this.writer.flush();
        }

        public void flush() throws IOException {
            this.writer.flush();
        }

        private Iterator prepareSections(ArrayList list) {
            LinkedList<SectionDesc> dest = new LinkedList<SectionDesc>();
            Collections.sort(list, new GuardedPositionComparator());
            Iterator it = list.iterator();
            while (it.hasNext()) {
                SectionDesc desc;
                GuardedSection o = (GuardedSection)it.next();
                if (o instanceof SimpleSection) {
                    desc = new SectionDesc(0);
                    desc.name = o.name;
                    desc.begin = ((SimpleSection)o).bounds.getBegin().getOffset();
                    desc.end = ((SimpleSection)o).bounds.getEnd().getOffset();
                    dest.add(desc);
                    continue;
                }
                desc = new SectionDesc(3);
                desc.begin = ((InteriorSection)o).header.getBegin().getOffset();
                desc.end = ((InteriorSection)o).header.getEnd().getOffset();
                desc.name = o.name;
                dest.add(desc);
                desc = new SectionDesc(2);
                desc.begin = ((InteriorSection)o).bottom.getBegin().getOffset();
                desc.end = ((InteriorSection)o).bottom.getEnd().getOffset();
                desc.name = o.name;
                dest.add(desc);
            }
            return dest.iterator();
        }

        void writeOneChar(int b) throws IOException {
            if (b == 13) {
                return;
            }
            if (this.current != null) {
                if (this.offsetCounter == this.current.begin) {
                    this.wasNewLine = false;
                }
                if (b == 10 && this.current.begin <= this.offsetCounter) {
                    switch (this.current.type) {
                        case 0: {
                            if (!this.wasNewLine) {
                                if (this.offsetCounter + 1 >= this.current.end) {
                                    this.writeMagic(0, this.current.name);
                                    this.nextSection();
                                    break;
                                }
                                this.writeMagic(1, this.current.name);
                                this.wasNewLine = true;
                                break;
                            }
                            if (this.offsetCounter + 1 < this.current.end) break;
                            this.writeMagic(2, this.current.name);
                            this.nextSection();
                            break;
                        }
                        case 3: {
                            if (!this.wasNewLine) {
                                if (this.offsetCounter + 1 >= this.current.end) {
                                    this.writeMagic(5, this.current.name);
                                    this.nextSection();
                                    break;
                                }
                                this.writeMagic(5, this.current.name);
                                this.wasNewLine = true;
                                break;
                            }
                            if (this.offsetCounter + 1 < this.current.end) break;
                            this.writeMagic(4, this.current.name);
                            this.nextSection();
                            break;
                        }
                        case 2: {
                            this.writeMagic(6, this.current.name);
                            this.nextSection();
                        }
                    }
                }
            }
            if (b == 32) {
                ++this.spaces;
            } else {
                char[] sp = new char[this.spaces];
                Arrays.fill(sp, ' ');
                this.writer.write(sp);
                this.writer.write(b);
                this.spaces = 0;
            }
            ++this.offsetCounter;
        }

        private void nextSection() {
            this.current = this.sections.hasNext() ? this.sections.next() : null;
        }

        private void writeMagic(int type, String name) throws IOException {
            if (!JavaEditor.this.shouldReload) {
                JavaEditor.this.shouldReload = this.spaces != SECTION_MAGICS[type].length() + name.length();
            }
            this.spaces = 0;
            this.writer.write(SECTION_MAGICS[type], 0, SECTION_MAGICS[type].length());
            this.writer.write(name, 0, name.length());
        }
    }

    static class GuardedReader
    extends Reader {
        Reader reader;
        char[] charBuff;
        char[] readBuff;
        int howmany;
        Pattern magicsAsRE;
        boolean justFilter;
        int position;
        LinkedList list;
        final int[] newLineTypes;

        GuardedReader(InputStream is, boolean justFilter) throws IOException {
            this(is, justFilter, null);
        }

        GuardedReader(InputStream is, boolean justFilter, String encoding) throws IOException {
            this.reader = encoding == null ? new InputStreamReader(is) : new InputStreamReader(is, encoding);
            this.justFilter = justFilter;
            this.position = 0;
            this.list = new LinkedList();
            this.newLineTypes = new int[]{0, 0, 0};
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.charBuff == null) {
                this.readCharBuff();
                this.translateToCharBuff();
            }
            if (this.howmany <= 0) {
                return -1;
            }
            int min = Math.min(len, this.howmany);
            System.arraycopy(this.charBuff, this.position, cbuf, off, min);
            this.howmany -= min;
            this.position += min;
            return min;
        }

        final void readCharBuff() throws IOException {
            int read;
            char[] tmp = new char[2048];
            ArrayList<char[]> buffs = new ArrayList<char[]>(20);
            while (true) {
                read = this.readFully(tmp);
                buffs.add(tmp);
                if (read < 2048) break;
                tmp = new char[2048];
            }
            int listsize = buffs.size() - 1;
            int size = listsize * 2048 + read;
            this.readBuff = new char[size];
            this.charBuff = new char[size];
            int copy = 0;
            for (int i = 0; i < listsize; ++i) {
                char[] tmp2 = (char[])buffs.get(i);
                System.arraycopy(tmp2, 0, this.readBuff, copy, 2048);
                copy += 2048;
            }
            System.arraycopy(tmp, 0, this.readBuff, copy, read);
        }

        final int readFully(char[] buff) throws IOException {
            int read = 0;
            int sum = 0;
            while ((sum += (read = this.reader.read(buff, sum, buff.length - sum))) < buff.length && read > 0) {
            }
            return sum + 1;
        }

        final void translateToCharBuff() {
            char c;
            this.position = 0;
            int charBuffPtr = 0;
            int stop = this.readBuff.length - 1;
            int i = 0;
            int lastNewLine = 0;
            int fatpos = 0;
            int MAGICLEN = JavaEditor.MAGIC_PREFIX.length();
            while (i < stop) {
                int searchLen;
                CharBuffer chi;
                c = this.readBuff[i];
                switch (c) {
                    case '\n': {
                        this.newLineTypes[0] = this.newLineTypes[0] + 1;
                        this.charBuff[charBuffPtr++] = 10;
                        lastNewLine = charBuffPtr;
                        ++i;
                        break;
                    }
                    case '\r': {
                        char c2 = this.readBuff[i + 1];
                        if (c2 != '\n') {
                            this.newLineTypes[1] = this.newLineTypes[1] + 1;
                            ++i;
                        } else {
                            i += 2;
                            this.newLineTypes[2] = this.newLineTypes[2] + 1;
                        }
                        this.charBuff[charBuffPtr++] = 10;
                        lastNewLine = charBuffPtr;
                        break;
                    }
                    default: {
                        this.charBuff[charBuffPtr++] = this.readBuff[i++];
                    }
                }
                switch (fatpos) {
                    case 0: {
                        if (c == '/') {
                            ++fatpos;
                            break;
                        }
                        fatpos = 0;
                        break;
                    }
                    case 1: {
                        if (c == '/') {
                            ++fatpos;
                            break;
                        }
                        fatpos = 0;
                        break;
                    }
                    case 2: {
                        if (c == 'G') {
                            ++fatpos;
                            break;
                        }
                        if (c == '/') {
                            fatpos = 2;
                            break;
                        }
                        fatpos = 0;
                        break;
                    }
                    case 3: {
                        if (c == 'E') {
                            ++fatpos;
                            break;
                        }
                        fatpos = 0;
                        break;
                    }
                    case 4: {
                        if (c == 'N') {
                            ++fatpos;
                            break;
                        }
                        fatpos = 0;
                        break;
                    }
                    case 5: {
                        if (c == '-') {
                            ++fatpos;
                            break;
                        }
                        fatpos = 0;
                        break;
                    }
                    default: {
                        fatpos = 0;
                    }
                }
                if (fatpos != MAGICLEN) continue;
                fatpos = 0;
                Pattern magics = this.getMagicsAsRE();
                Matcher matcher = magics.matcher(chi = CharBuffer.wrap(this.readBuff, i, searchLen = Math.min(10, this.readBuff.length - i)));
                if (!matcher.find()) continue;
                String match = matcher.group();
                charBuffPtr -= MAGICLEN;
                int toNl = this.toNewLine(i += match.length());
                int sectionSize = MAGICLEN + match.length() + toNl;
                if (!this.justFilter) {
                    int type = GuardedReader.string2Type(match);
                    SectionDesc desc = new SectionDesc(type);
                    desc.begin = lastNewLine;
                    desc.end = charBuffPtr + sectionSize + 1;
                    desc.name = new String(this.readBuff, i, toNl);
                    this.list.add(desc);
                }
                i += toNl;
                Arrays.fill(this.charBuff, charBuffPtr, charBuffPtr + sectionSize, ' ');
                charBuffPtr += sectionSize;
            }
            if (i == stop) {
                c = this.readBuff[i];
                switch (c) {
                    case '\n': {
                        this.newLineTypes[0] = this.newLineTypes[0] + 1;
                        this.charBuff[charBuffPtr++] = 10;
                        break;
                    }
                    case '\r': {
                        this.newLineTypes[1] = this.newLineTypes[1] + 1;
                        this.charBuff[charBuffPtr++] = 10;
                        break;
                    }
                    default: {
                        this.charBuff[charBuffPtr++] = this.readBuff[i++];
                    }
                }
            }
            if (!this.justFilter && this.list.size() > 0) {
                SectionDesc desc = (SectionDesc)this.list.getLast();
                if (desc.end > charBuffPtr) {
                    desc.end = charBuffPtr;
                }
            }
            this.howmany = charBuffPtr;
            this.readBuff = null;
        }

        static int string2Type(String match) {
            StringBuffer sb = new StringBuffer(JavaEditor.MAGIC_PREFIX);
            sb.append(match);
            match = sb.toString();
            int len = SECTION_MAGICS.length;
            for (int i = 0; i < len; ++i) {
                if (!match.equals(SECTION_MAGICS[i])) continue;
                return i;
            }
            return -1;
        }

        final int toNewLine(int i) {
            int counter = i;
            int len = this.readBuff.length;
            while (counter < len) {
                char c;
                if ((c = this.readBuff[counter++]) != '\r' && c != '\n') continue;
                --counter;
                break;
            }
            return counter - i;
        }

        final Pattern getMagicsAsRE() {
            if (this.magicsAsRE == null) {
                this.magicsAsRE = Pattern.compile(this.makeOrRegexp());
            }
            return this.magicsAsRE;
        }

        final String makeOrRegexp() {
            StringBuffer sb = new StringBuffer(100);
            int len = JavaEditor.MAGIC_PREFIX.length();
            int slen = SECTION_MAGICS.length - 1;
            for (int i = 0; i < slen; ++i) {
                sb.append(SECTION_MAGICS[i].substring(len));
                sb.append('|');
            }
            sb.append(SECTION_MAGICS[slen].substring(len));
            return sb.toString();
        }

        byte getNewLineType() {
            if (this.newLineTypes[0] == this.newLineTypes[1] && this.newLineTypes[1] == this.newLineTypes[2]) {
                String s = System.getProperty("line.separator");
                if ("\r".equals(s)) {
                    return 1;
                }
                if ("\r\n".equals(s)) {
                    return 2;
                }
                return 0;
            }
            if (this.newLineTypes[0] > this.newLineTypes[1]) {
                return this.newLineTypes[0] > this.newLineTypes[2] ? (byte)0 : 2;
            }
            return this.newLineTypes[1] > this.newLineTypes[2] ? (byte)1 : 2;
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }

    private static class SectionDesc {
        int type;
        String name;
        int begin;
        int end;

        SectionDesc(int type) {
            this.type = type;
            this.name = null;
            this.begin = 0;
            this.end = 0;
        }
    }

    private static class GuardedPositionComparator
    implements Comparator {
        private GuardedPositionComparator() {
        }

        public int compare(Object o1, Object o2) {
            return this.getOffset(o1) - this.getOffset(o2);
        }

        private int getOffset(Object o) {
            if (o instanceof SimpleSection) {
                return ((SimpleSection)o).bounds.getBegin().getOffset();
            }
            return ((InteriorSection)o).header.getBegin().getOffset();
        }
    }

    private class JavaEditorChangeListener
    implements ChangeListener {
        private PropertyChangeListener classpathListener;
        private PropertyChangeListener settingListener;

        private JavaEditorChangeListener() {
        }

        public void stateChanged(ChangeEvent ev) {
            JavaSettings js = JavaSettings.getDefault();
            if (this.classpathListener == null) {
                this.classpathListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("roots".equals(evt.getPropertyName())) {
                            JavaEditor.this.classpathChanged();
                        }
                    }
                };
            }
            if (this.settingListener == null) {
                this.settingListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("parsingErrors".equals(evt.getPropertyName())) {
                            JavaEditor.this.parsingErrorsChanged(evt);
                        }
                        if ("showOverriding".equals(evt.getPropertyName())) {
                            JavaEditor.this.showOverridingChanged(evt);
                        }
                    }
                };
            }
            ClassPath sourceClasspath = JavaEditor.this.getSourcePath();
            ClassPath librariesClasspath = JavaEditor.this.getLibrariesPath();
            ClassPath bootClassPath = JavaEditor.this.getBootClassPath();
            if (sourceClasspath != null) {
                sourceClasspath.removePropertyChangeListener(this.classpathListener);
            }
            if (librariesClasspath != null) {
                librariesClasspath.removePropertyChangeListener(this.classpathListener);
            }
            if (bootClassPath != null) {
                bootClassPath.removePropertyChangeListener(this.classpathListener);
            }
            js.removePropertyChangeListener(this.settingListener);
            if (JavaEditor.this.isDocumentLoaded()) {
                if (sourceClasspath != null) {
                    sourceClasspath.addPropertyChangeListener(this.classpathListener);
                }
                if (librariesClasspath != null) {
                    librariesClasspath.addPropertyChangeListener(this.classpathListener);
                }
                if (bootClassPath != null) {
                    bootClassPath.addPropertyChangeListener(this.classpathListener);
                }
                js.addPropertyChangeListener(this.settingListener);
            }
        }
    }

    public final class InteriorSection
    extends GuardedSection {
        PositionBounds header;
        PositionBounds body;
        PositionBounds bottom;

        InteriorSection(String name, PositionBounds header, PositionBounds body, PositionBounds bottom) {
            super(name);
            this.header = header;
            this.body = body;
            this.bottom = bottom;
        }

        public boolean setBody(String text) {
            return this.setText(this.body, text, false);
        }

        public boolean setHeader(String text) {
            return this.setText(this.header, text, true);
        }

        public String getHeader() {
            if (!this.isValid()) {
                return null;
            }
            try {
                return this.header.getText();
            }
            catch (IOException ex) {
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return null;
        }

        public boolean setBottom(String text) {
            int lastEol;
            boolean endsWithEol = text.endsWith("\n");
            int firstEol = text.indexOf(10);
            if (firstEol != (lastEol = text.lastIndexOf(10)) || endsWithEol && firstEol != -1) {
                if (endsWithEol) {
                    text = text.substring(0, text.length() - 1);
                }
                text = text.replace('\n', ' ');
            }
            return this.setText(this.bottom, text, true);
        }

        public String getBottom() throws IOException, BadLocationException {
            if (!this.isValid()) {
                return null;
            }
            try {
                return this.bottom.getText();
            }
            catch (IOException ex) {
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return null;
        }

        public PositionRef getBegin() {
            return this.body.getBegin();
        }

        void deleteText() throws BadLocationException, IOException {
            this.header.setText("");
            this.body.setText("");
            this.bottom.setText("");
            this.deleteNewLineBeforeBlock(this.header.getBegin().getOffset());
        }

        void markGuarded(StyledDocument doc) {
            this.markGuarded(doc, this.header, true);
            this.markGuarded(doc, this.bottom, true);
        }

        void unmarkGuarded(StyledDocument doc) {
            this.markGuarded(doc, this.header, false);
            this.markGuarded(doc, this.bottom, false);
            JavaEditor.this.notifyModified();
        }

        public String getText() {
            StringBuffer buf = new StringBuffer();
            try {
                buf.append(this.header.getText());
                buf.append(this.body.getText());
                buf.append(this.bottom.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return buf.toString();
        }

        public boolean contains(PositionRef pos, boolean allowHoles) {
            if (!allowHoles) {
                return this.header.getBegin().getOffset() <= pos.getOffset() && this.bottom.getEnd().getOffset() >= pos.getOffset();
            }
            if (this.header.getBegin().getOffset() <= pos.getOffset() && this.header.getEnd().getOffset() >= pos.getOffset()) {
                return true;
            }
            return this.bottom.getBegin().getOffset() <= pos.getOffset() && this.bottom.getEnd().getOffset() >= pos.getOffset();
        }

        public PositionRef getPositionBefore() {
            return JavaEditor.this.createPositionRef(this.header.getBegin().getOffset(), Position.Bias.Forward);
        }

        public PositionRef getPositionAfter() {
            return JavaEditor.this.createPositionRef(this.bottom.getEnd().getOffset(), Position.Bias.Backward);
        }
    }

    public final class SimpleSection
    extends GuardedSection {
        PositionBounds bounds;

        SimpleSection(String name, PositionBounds bounds) {
            super(name);
            this.bounds = bounds;
        }

        public boolean setText(String text) {
            return this.setText(this.bounds, text, true);
        }

        void deleteText() throws BadLocationException, IOException {
            this.bounds.setText("");
            this.deleteNewLineBeforeBlock(this.bounds.getBegin().getOffset());
        }

        void markGuarded(StyledDocument doc) {
            this.markGuarded(doc, this.bounds, true);
        }

        void unmarkGuarded(StyledDocument doc) {
            this.markGuarded(doc, this.bounds, false);
            JavaEditor.this.notifyModified();
        }

        public PositionRef getBegin() {
            return this.bounds.getBegin();
        }

        public String getText() {
            StringBuffer buf = new StringBuffer();
            try {
                buf.append(this.bounds.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return buf.toString();
        }

        public PositionRef getPositionAfter() {
            return JavaEditor.this.createPositionRef(this.bounds.getEnd().getOffset(), Position.Bias.Backward);
        }

        public boolean contains(PositionRef pos, boolean allowHoles) {
            return this.bounds.getBegin().getOffset() <= pos.getOffset() && this.bounds.getEnd().getOffset() >= pos.getOffset();
        }

        public PositionRef getPositionBefore() {
            return JavaEditor.this.createPositionRef(this.bounds.getBegin().getOffset(), Position.Bias.Forward);
        }
    }

    public abstract class GuardedSection {
        String name;
        boolean valid;

        public String getName() {
            return this.name;
        }

        GuardedSection(String name) {
            this.name = name;
            this.valid = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setName(String name) throws PropertyVetoException {
            if (!this.name.equals(name)) {
                JavaEditor javaEditor = JavaEditor.this;
                synchronized (javaEditor) {
                    if (this.valid) {
                        if (JavaEditor.this.sections.get(name) != null) {
                            throw new PropertyVetoException("", new PropertyChangeEvent(this, "name", this.name, name));
                        }
                        JavaEditor.this.sections.remove(this.name);
                        this.name = name;
                        JavaEditor.this.sections.put(name, this);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean deleteSection() {
            JavaEditor javaEditor = JavaEditor.this;
            synchronized (javaEditor) {
                if (this.valid) {
                    try {
                        JavaEditor.this.sections.remove(this.name);
                        this.unmarkGuarded(JavaEditor.this.getDocument());
                        this.deleteText();
                        this.valid = false;
                        return true;
                    }
                    catch (BadLocationException e) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return false;
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeSection() {
            JavaEditor javaEditor = JavaEditor.this;
            synchronized (javaEditor) {
                if (!this.valid) {
                    return false;
                }
                JavaEditor.this.sections.remove(this.name);
                this.unmarkGuarded(JavaEditor.this.getDocument());
                this.valid = false;
                return true;
            }
        }

        void deleteNewLineBeforeBlock(int offset) {
            if (offset > 1) {
                try {
                    PositionBounds b = JavaEditor.this.createBounds(offset - 1, offset, true);
                    String s = b.getText();
                    if (s.equals("\n")) {
                        b.setText("");
                    }
                }
                catch (IOException e) {
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        public void openAt() {
            JavaEditor.this.openAt(this.getBegin());
        }

        protected boolean setText(PositionBounds bounds, String text, boolean minLen) {
            if (!this.valid) {
                return false;
            }
            if (minLen) {
                if (text.length() == 0) {
                    text = " \n";
                } else if (text.length() == 1) {
                    String string = text = text.equals("\n") ? " \n" : text + "\n";
                }
            }
            if (!text.endsWith("\n")) {
                text = text + "\n";
            }
            try {
                bounds.setText(text);
                return true;
            }
            catch (BadLocationException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
            return false;
        }

        void markGuarded(StyledDocument doc, PositionBounds bounds, boolean mark) {
            int begin = bounds.getBegin().getOffset();
            int end = bounds.getEnd().getOffset();
            if (mark) {
                NbDocument.markGuarded((StyledDocument)doc, (int)begin, (int)(end - begin));
            } else {
                NbDocument.unmarkGuarded((StyledDocument)doc, (int)begin, (int)(end - begin));
            }
        }

        abstract void markGuarded(StyledDocument var1);

        abstract void unmarkGuarded(StyledDocument var1);

        abstract void deleteText() throws BadLocationException, IOException;

        public abstract PositionRef getBegin();

        public abstract String getText();

        public abstract boolean contains(PositionRef var1, boolean var2);

        public abstract PositionRef getPositionAfter();

        public abstract PositionRef getPositionBefore();
    }

    public static class JavaEditorComponent
    extends CloneableEditor {
        static final int SELECTED_NODES_DELAY = 1000;
        Timer timerSelNodes;
        JavaEditor support;
        CaretListener caretListener;
        Component toolBar;
        int lastCaretOffset = -1;
        static final long serialVersionUID = 6223349196427270209L;
        private transient RequestProcessor.Task selectionTask = null;
        private final RequestPoster elementSelectionPoster = new RequestPoster();

        public JavaEditorComponent() {
        }

        public JavaEditorComponent(CloneableEditorSupport sup) {
            super(sup);
            this.initialize();
        }

        void selectElementsAtOffset(final int offset) {
            this.elementSelectionPoster.post(new Runnable(){

                public void run() {
                    ((JMManager)JMManager.getManager()).waitScanFinished();
                    final DataObject d = JavaEditorComponent.this.support.getDataObject();
                    if (!JavaEditorComponent.this.isActiveTC() || d == null || !d.isValid() || d.isTemplate()) {
                        return;
                    }
                    final Node n = (Node)Children.MUTEX.readAccess(new Mutex.Action(){

                        public Object run() {
                            return JavaEditorComponent.this.createNode(offset, d);
                        }
                    });
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Node[] nodeArray;
                            JavaEditorComponent javaEditorComponent = JavaEditorComponent.this;
                            if (n != null) {
                                Node[] nodeArray2 = new Node[1];
                                nodeArray = nodeArray2;
                                nodeArray2[0] = n;
                            } else {
                                nodeArray = new Node[]{};
                            }
                            javaEditorComponent.setActivatedNodes(nodeArray);
                        }
                    });
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Node createNode(int offset, DataObject d) {
            SourceNodeFactory factory = SourceNodes.getExplorerFactory();
            Node n = null;
            org.netbeans.jmi.javamodel.Element currentElement = null;
            Node[] nodes = this.getActivatedNodes();
            if (nodes != null && nodes.length == 1) {
                currentElement = (org.netbeans.jmi.javamodel.Element)nodes[0].getLookup().lookup(class$org$netbeans$jmi$javamodel$Element == null ? (class$org$netbeans$jmi$javamodel$Element = JavaEditor.class$("org.netbeans.jmi.javamodel.Element")) : class$org$netbeans$jmi$javamodel$Element);
            }
            try {
                JMManager.getTransactionMutex().addPriorityThread();
                JavaMetamodel.getDefaultRepository().beginTrans(false);
                try {
                    org.netbeans.jmi.javamodel.Element element;
                    FileObject fo = d.getPrimaryFile();
                    JavaModel.setClassPath((FileObject)fo);
                    Resource res = JavaMetamodel.getManager().getResource(fo);
                    org.netbeans.jmi.javamodel.Element element2 = element = res == null ? null : JavaEditorComponent.findElement(res, offset);
                    if (element != null && currentElement != null && element.isValid() && currentElement.isValid() && element.equals(currentElement)) {
                        Node node = nodes[0];
                        return node;
                    }
                    if (element instanceof Field) {
                        n = factory.createFieldNode((Field)element);
                        return n;
                    }
                    if (element instanceof Attribute) {
                        n = factory.createAnnotationTypeMethodNode((Attribute)element);
                        return n;
                    }
                    if (element instanceof AnnotationType) {
                        n = factory.createAnnotationTypeNode((AnnotationType)element);
                        return n;
                    }
                    if (element instanceof Constructor) {
                        n = factory.createConstructorNode((Constructor)element);
                        return n;
                    }
                    if (element instanceof EnumConstant) {
                        n = factory.createEnumConstantNode((EnumConstant)element);
                        return n;
                    }
                    if (element instanceof Initializer) {
                        n = factory.createInitializerNode((Initializer)element);
                        return n;
                    }
                    if (element instanceof Method) {
                        n = factory.createMethodNode((Method)element);
                        return n;
                    }
                    if (element instanceof JavaEnum) {
                        n = factory.createEnumNode((JavaEnum)element);
                        return n;
                    }
                    if (element instanceof JavaClass) {
                        n = factory.createClassNode((JavaClass)element);
                        return n;
                    }
                    if (element instanceof Resource) {
                        n = d.getNodeDelegate();
                        return n;
                    }
                    n = null;
                    return n;
                }
                finally {
                    JavaMetamodel.getDefaultRepository().endTrans();
                }
            }
            catch (JmiException e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
            }
            return n;
        }

        private static org.netbeans.jmi.javamodel.Element findElement(Resource r, int offset) {
            Iterator cit = r.getClassifiers().iterator();
            Resource el = r;
            while (cit.hasNext()) {
                JavaClass jc = (JavaClass)cit.next();
                PositionBounds bounds = JavaMetamodel.getManager().getElementPosition((org.netbeans.jmi.javamodel.Element)jc);
                if (bounds == null || offset < bounds.getBegin().getOffset() || offset > bounds.getEnd().getOffset()) continue;
                el = JavaEditorComponent.findElement(jc, offset);
                break;
            }
            return el;
        }

        private static org.netbeans.jmi.javamodel.Element findElement(JavaClass jc, int offset) {
            Iterator classIt = jc.getFeatures().iterator();
            JavaClass el = jc;
            while (classIt.hasNext()) {
                ClassMember cm = (ClassMember)classIt.next();
                PositionBounds bounds = JavaMetamodel.getManager().getElementPosition((org.netbeans.jmi.javamodel.Element)cm);
                if (offset < bounds.getBegin().getOffset() || offset > bounds.getEnd().getOffset()) continue;
                if (cm instanceof JavaClass) {
                    el = JavaEditorComponent.findElement((JavaClass)cm, offset);
                    break;
                }
                el = cm;
                break;
            }
            return el;
        }

        protected boolean isActiveTC() {
            return JavaEditorComponent.getRegistry().getActivated() == this;
        }

        protected void notifyParsingDone() {
        }

        public SystemAction[] getSystemActions() {
            this.selectElementsAtOffset(this.lastCaretOffset);
            this.timerSelNodes.stop();
            return super.getSystemActions();
        }

        private void initialize() {
            this.support = (JavaEditor)this.cloneableEditorSupport();
            if (this.support == null) {
                return;
            }
            this.timerSelNodes = new Timer(200, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Caret caret;
                    Timer t = JavaEditorComponent.this.support.timer;
                    if (t != null && t.isRunning()) {
                        JavaEditorComponent.this.timerSelNodes.restart();
                        return;
                    }
                    if (!JavaEditorComponent.this.isActiveTC()) {
                        return;
                    }
                    if (JavaEditorComponent.this.lastCaretOffset == -1 && JavaEditorComponent.this.getEditorPane() != null && (caret = JavaEditorComponent.this.getEditorPane().getCaret()) != null) {
                        JavaEditorComponent.this.lastCaretOffset = caret.getDot();
                    }
                    JavaEditorComponent.this.selectElementsAtOffset(JavaEditorComponent.this.lastCaretOffset);
                }
            });
            this.timerSelNodes.setInitialDelay(200);
            this.timerSelNodes.setRepeats(false);
            this.caretListener = new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    JavaEditorComponent.this.support.restartTimer(true);
                    JavaEditorComponent.this.restartTimerSelNodes(e.getDot());
                }
            };
            this.timerSelNodes.restart();
        }

        void restartTimerSelNodes(int pos) {
            this.timerSelNodes.setInitialDelay(1000);
            this.timerSelNodes.restart();
            this.lastCaretOffset = pos;
        }

        protected void componentActivated() {
            JEditorPane p = this.getEditorPane();
            if (p != null) {
                p.addCaretListener(this.caretListener);
            }
            super.componentActivated();
            if (p != null) {
                p.requestFocusInWindow();
            }
            if (this.support.timer == null || !this.support.timer.isRunning()) {
                this.support.restartTimer(false, true);
            }
            if (!this.support.hasAnnotations) {
                ERROR_ANNOTATION_QUEUE.post(new Runnable(){

                    public void run() {
                        if (JavaEditorComponent.this.support.overriddensSupport != null) {
                            JavaEditorComponent.this.support.overriddensSupport.processOverriddenAnnotation();
                        }
                    }
                }, 1000, 1);
            }
            this.support.attachParsingListener();
        }

        public void requestFocus() {
            super.requestFocus();
            JEditorPane p = this.getEditorPane();
            if (p != null) {
                p.requestFocus();
            }
        }

        public boolean requestFocusInWindow() {
            super.requestFocusInWindow();
            JEditorPane p = this.getEditorPane();
            if (p != null) {
                return p.requestFocusInWindow();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void componentDeactivated() {
            JEditorPane p = this.getEditorPane();
            if (p != null) {
                p.removeCaretListener(this.caretListener);
            }
            this.support.removeParsingListener();
            JavaEditorComponent javaEditorComponent = this;
            synchronized (javaEditorComponent) {
                if (this.selectionTask != null) {
                    this.selectionTask.cancel();
                    this.selectionTask = null;
                }
            }
            this.support.stopTimerIfPossible();
            super.componentDeactivated();
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.initialize();
        }
    }

    private static class JavaEditorEnv
    extends DataEditorSupport.Env {
        static final long serialVersionUID = -6792511207355520950L;

        public JavaEditorEnv(DataObject obj) {
            super(obj);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((JavaDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = JavaEditor.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
        }
    }

    private class Save
    implements SaveCookie {
        private Save() {
        }

        public void save() throws IOException {
            JavaEditor.this.saveDocument();
            if (JavaEditor.this.wasReloaded) {
                JavaEditor.this.getDataObject().setModified(true);
                JavaEditor.this.wasReloaded = false;
            } else {
                JavaEditor.this.getDataObject().setModified(false);
            }
        }
    }
}

