/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.transaction;

import oracle.toplink.essentials.exceptions.TransactionException;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.logging.SessionLogEntry;
import oracle.toplink.essentials.transaction.AbstractTransactionController;

public abstract class AbstractSynchronizationListener {
    protected AbstractTransactionController controller;
    protected AbstractSession session;
    protected UnitOfWorkImpl unitOfWork;
    protected Object transaction;

    public AbstractSynchronizationListener() {
    }

    protected AbstractSynchronizationListener(UnitOfWorkImpl unitOfWork, AbstractSession session, Object transaction, AbstractTransactionController controller) {
        this.session = session;
        this.unitOfWork = unitOfWork;
        this.transaction = transaction;
        this.controller = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion() {
        UnitOfWorkImpl uow = this.getUnitOfWork();
        try {
            Object status = this.getTransactionController().getTransactionStatus();
            this.getTransactionController().logTxStateTrace(uow, "TX_beforeCompletion", status);
            this.session.startOperationProfile("TXBeforeCompletion");
            if (!uow.isActive()) {
                throw TransactionException.inactiveUnitOfWork(uow);
            }
            if (!this.getTransactionController().canIssueSQLToDatabase_impl(status)) {
                return;
            }
            if (this.getSession().isInTransaction()) {
                this.getSession().getTransactionMutex().setActiveThread(Thread.currentThread());
            }
            uow.issueSQLbeforeCompletion();
            uow.setPendingMerge();
        }
        catch (RuntimeException exception) {
            uow.log(new SessionLogEntry(uow, 6, "transaction", exception));
            this.handleException(exception);
        }
        finally {
            this.session.endOperationProfile("TXBeforeCompletion");
        }
    }

    public void afterCompletion(Object status) {
        UnitOfWorkImpl uow = this.getUnitOfWork();
        try {
            this.getTransactionController().logTxStateTrace(uow, "TX_afterCompletion", status);
            this.session.startOperationProfile("TXAfterCompletion");
            if (!uow.isActive()) {
                throw TransactionException.inactiveUnitOfWork(uow);
            }
            if (this.getTransactionController().canMergeUnitOfWork_impl(status)) {
                uow.afterTransaction(true, true);
                if (uow.isMergePending()) {
                    uow.mergeClonesAfterCompletion();
                }
            } else {
                uow.afterTransaction(false, true);
            }
        }
        catch (RuntimeException rtEx) {
            uow.log(new SessionLogEntry(uow, 6, "transaction", rtEx));
            throw rtEx;
        }
        finally {
            this.session.endOperationProfile("TXAfterCompletion");
        }
        if (uow.shouldResumeUnitOfWorkOnTransactionCompletion() && this.getTransactionController().canMergeUnitOfWork_impl(status)) {
            uow.synchronizeAndResume();
            uow.setSynchronized(false);
        } else {
            uow.release();
            if (this.getSession().isClientSession()) {
                this.getSession().release();
            }
        }
        this.getTransactionController().removeUnitOfWork(this.getTransaction());
        this.setUnitOfWork(null);
        this.setTransaction(null);
        this.setSession(null);
    }

    public void handleException(RuntimeException exception) {
        throw exception;
    }

    protected AbstractTransactionController getTransactionController() {
        return this.controller;
    }

    protected void setTransactionController(AbstractTransactionController newController) {
        this.controller = newController;
    }

    protected Object getTransaction() {
        return this.transaction;
    }

    protected void setTransaction(Object transaction) {
        this.transaction = transaction;
    }

    protected AbstractSession getSession() {
        return this.session;
    }

    protected void setSession(AbstractSession session) {
        this.session = session;
    }

    protected UnitOfWorkImpl getUnitOfWork() {
        return this.unitOfWork;
    }

    protected void setUnitOfWork(UnitOfWorkImpl unitOfWork) {
        this.unitOfWork = unitOfWork;
    }
}

