/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.descriptors.FetchGroupManager;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.expressions.DataExpression;
import oracle.toplink.essentials.internal.expressions.ExpressionJavaPrinter;
import oracle.toplink.essentials.internal.expressions.ExpressionNormalizer;
import oracle.toplink.essentials.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.essentials.internal.expressions.ObjectExpression;
import oracle.toplink.essentials.internal.expressions.TableExpression;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.AggregateMapping;
import oracle.toplink.essentials.mappings.AggregateObjectMapping;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.DirectCollectionMapping;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;
import oracle.toplink.essentials.mappings.foundation.AbstractDirectMapping;
import oracle.toplink.essentials.queryframework.InMemoryQueryIndirectionPolicy;
import oracle.toplink.essentials.querykeys.DirectQueryKey;
import oracle.toplink.essentials.querykeys.ForeignReferenceQueryKey;
import oracle.toplink.essentials.querykeys.QueryKey;

public class QueryKeyExpression
extends ObjectExpression {
    protected String name;
    protected DatabaseField aliasedField;
    protected boolean shouldQueryToManyRelationship;
    protected transient QueryKey queryKey;
    protected boolean hasQueryKey;
    protected transient DatabaseMapping mapping;
    protected boolean hasMapping;

    public QueryKeyExpression() {
        this.shouldQueryToManyRelationship = false;
        this.hasQueryKey = true;
        this.hasMapping = true;
    }

    public QueryKeyExpression(String aName, Expression base) {
        this.name = aName;
        this.baseExpression = base;
        this.shouldUseOuterJoin = false;
        this.shouldQueryToManyRelationship = false;
        this.hasQueryKey = true;
        this.hasMapping = true;
    }

    public Expression additionalExpressionCriteria() {
        if (this.getDescriptor() == null) {
            return null;
        }
        Expression criteria = this.getDescriptor().getQueryManager().getAdditionalJoinExpression();
        if (criteria != null) {
            criteria = this.getBaseExpression().twist(criteria, this);
            if (this.shouldUseOuterJoin() && this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause()) {
                criteria.convertToUseOuterJoin();
            }
        }
        if (this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause() && this.isUsingOuterJoinForMultitableInheritance()) {
            Expression childrenCriteria = this.getDescriptor().getInheritancePolicy().getChildrenJoinExpression();
            childrenCriteria = this.getBaseExpression().twist(childrenCriteria, this);
            childrenCriteria.convertToUseOuterJoin();
            criteria = criteria == null ? childrenCriteria : criteria.and(childrenCriteria);
        }
        return criteria;
    }

    public Map additionalExpressionCriteriaMap() {
        if (this.getDescriptor() == null) {
            return null;
        }
        HashMap<DatabaseTable, Expression> tablesJoinExpressions = new HashMap<DatabaseTable, Expression>();
        Vector tables = this.getDescriptor().getTables();
        int tablesSize = tables.size();
        if (this.shouldUseOuterJoin()) {
            for (int i = 1; i < tablesSize; ++i) {
                DatabaseTable table = (DatabaseTable)tables.elementAt(i);
                Expression joinExpression = (Expression)this.getDescriptor().getQueryManager().getTablesJoinExpressions().get(table);
                joinExpression = this.getBaseExpression().twist(joinExpression, this);
                tablesJoinExpressions.put(table, joinExpression);
            }
        }
        if (this.isUsingOuterJoinForMultitableInheritance()) {
            List childrenTables = this.getDescriptor().getInheritancePolicy().getChildrenTables();
            tablesSize = childrenTables.size();
            for (int i = 0; i < tablesSize; ++i) {
                DatabaseTable table = (DatabaseTable)childrenTables.get(i);
                Expression joinExpression = (Expression)this.getDescriptor().getInheritancePolicy().getChildrenTablesJoinExpressions().get(table);
                joinExpression = this.getBaseExpression().twist(joinExpression, this);
                tablesJoinExpressions.put(table, joinExpression);
            }
        }
        return tablesJoinExpressions;
    }

    public DatabaseTable aliasForTable(DatabaseTable table) {
        if (this.isAttribute() || this.getMapping() != null && (this.getMapping().isAggregateObjectMapping() || this.getMapping().isTransformationMapping())) {
            return ((DataExpression)this.getBaseExpression()).aliasForTable(table);
        }
        if (this.getMapping() != null && (this.getMapping().isReferenceMapping() || this.getMapping().isStructureMapping())) {
            DatabaseTable alias = this.getBaseExpression().aliasForTable((DatabaseTable)this.getMapping().getDescriptor().getTables().firstElement());
            alias.setName(alias.getName() + "." + this.getMapping().getField().getName());
            return alias;
        }
        return super.aliasForTable(table);
    }

    public String descriptionOfNodeType() {
        return "Query Key";
    }

    public void doQueryToManyRelationship() {
        this.shouldQueryToManyRelationship = true;
    }

    public DatabaseField getAliasedField() {
        if (this.aliasedField == null) {
            this.initializeAliasedField();
        }
        return this.aliasedField;
    }

    protected DatabaseTable getAliasedTable() {
        DataExpression base = (DataExpression)this.getBaseExpression();
        DatabaseTable alias = base.aliasForTable(this.getField().getTable());
        if (alias == null) {
            return this.getField().getTable();
        }
        return alias;
    }

    public ClassDescriptor getContainingDescriptor() {
        return ((DataExpression)this.getBaseExpression()).getDescriptor();
    }

    public DatabaseField getField() {
        if (!this.isAttribute()) {
            return null;
        }
        return this.getContainingDescriptor().getObjectBuilder().getFieldForQueryKeyName(this.getName());
    }

    public Vector getFields() {
        if (this.isAttribute()) {
            Vector<DatabaseField> result = new Vector<DatabaseField>(1);
            DatabaseField field = this.getField();
            if (field != null) {
                result.addElement(field);
            }
            return result;
        }
        if (this.getMapping() != null && this.getMapping().isTransformationMapping()) {
            return this.getMapping().getFields();
        }
        if (this.isUsingOuterJoinForMultitableInheritance()) {
            return this.getDescriptor().getAllFields();
        }
        return super.getFields();
    }

    public Object getFieldValue(Object objectValue) {
        DatabaseMapping mapping = this.getMapping();
        Vector<Object> fieldValue = objectValue;
        if (mapping != null && mapping.isDirectToFieldMapping()) {
            if (objectValue instanceof Vector) {
                Vector values = objectValue;
                Vector<Object> fieldValues = new Vector<Object>(values.size());
                for (int index = 0; index < values.size(); ++index) {
                    fieldValues.addElement(this.getFieldValue(values.get(index)));
                }
                fieldValue = fieldValues;
            } else {
                fieldValue = ((AbstractDirectMapping)mapping).getFieldValue(objectValue, this.getSession());
            }
        }
        return fieldValue;
    }

    public DatabaseMapping getMapping() {
        if (!this.hasMapping) {
            return null;
        }
        if (this.mapping == null) {
            this.mapping = super.getMapping();
            if (this.mapping == null) {
                this.hasMapping = false;
            }
        }
        return this.mapping;
    }

    public DatabaseMapping getMappingFromQueryKey() {
        QueryKey queryKey = this.getQueryKeyOrNull();
        if (queryKey == null || !(queryKey instanceof DirectQueryKey)) {
            throw QueryException.cannotConformExpression();
        }
        this.mapping = queryKey.getDescriptor().getObjectBuilder().getMappingForField(((DirectQueryKey)queryKey).getField());
        if (this.mapping == null) {
            throw QueryException.cannotConformExpression();
        }
        return this.mapping;
    }

    public String getName() {
        return this.name;
    }

    public Vector getOwnedTables() {
        if (this.getMapping() != null && (this.getMapping().isReferenceMapping() || this.getMapping().isStructureMapping())) {
            return null;
        }
        return super.getOwnedTables();
    }

    public QueryKey getQueryKeyOrNull() {
        if (!this.hasQueryKey) {
            return null;
        }
        if (this.getContainingDescriptor() == null) {
            throw QueryException.invalidQueryKeyInExpression(this.getName());
        }
        if (this.queryKey == null) {
            this.queryKey = this.getContainingDescriptor().getQueryKeyNamed(this.getName());
            if (this.queryKey == null) {
                this.hasQueryKey = false;
            }
        }
        return this.queryKey;
    }

    protected void initializeAliasedField() {
        DatabaseField tempField = (DatabaseField)this.getField().clone();
        DatabaseTable aliasedTable = this.getAliasedTable();
        this.aliasedField = tempField;
        this.aliasedField.setTable(aliasedTable);
    }

    public boolean isAttribute() {
        if (this.getSession() == null) {
            return false;
        }
        QueryKey queryKey = this.getQueryKeyOrNull();
        if (queryKey != null) {
            return queryKey.isDirectQueryKey();
        }
        DatabaseMapping mapping = this.getMapping();
        if (mapping != null) {
            if (mapping.isVariableOneToOneMapping()) {
                throw QueryException.cannotQueryAcrossAVariableOneToOneMapping(mapping, mapping.getDescriptor());
            }
            return mapping.isDirectToFieldMapping();
        }
        return false;
    }

    public boolean isQueryKeyExpression() {
        return true;
    }

    public Expression mappingCriteria() {
        Expression selectionCriteria;
        if (this.getQueryKeyOrNull() == null) {
            if (this.getMapping() == null || !this.getMapping().isForeignReferenceMapping()) {
                return null;
            }
            selectionCriteria = ((ForeignReferenceMapping)this.getMapping()).getJoinCriteria(this);
        } else {
            if (!this.getQueryKeyOrNull().isForeignReferenceQueryKey()) {
                return null;
            }
            selectionCriteria = ((ForeignReferenceQueryKey)this.getQueryKeyOrNull()).getJoinCriteria();
            selectionCriteria = this.getBaseExpression().twist(selectionCriteria, this);
        }
        if (this.shouldUseOuterJoin() && this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause()) {
            selectionCriteria = selectionCriteria.convertToUseOuterJoin();
        }
        return selectionCriteria;
    }

    public Expression normalize(ExpressionNormalizer normalizer) {
        return this.normalize(normalizer, null);
    }

    public Expression normalize(ExpressionNormalizer normalizer, Vector foreignKeyJoinPointer) {
        Expression mappingExpression;
        if (this.hasBeenNormalized()) {
            return this;
        }
        super.normalize(normalizer);
        this.setHasBeenNormalized(true);
        if (this.getMapping() != null && this.getMapping().isDirectToXMLTypeMapping()) {
            normalizer.getStatement().setRequiresAliases(true);
        }
        if (this.isAttribute()) {
            return this;
        }
        if (this.getMapping() != null && (this.getMapping().isReferenceMapping() || this.getMapping().isStructureMapping())) {
            normalizer.getStatement().setRequiresAliases(true);
            return this;
        }
        if (this.shouldQueryToManyRelationship() && !normalizer.getStatement().isDistinctComputed() && !normalizer.getStatement().isAggregateSelect()) {
            normalizer.getStatement().useDistinct();
        }
        if (this.getMapping() != null && this.getMapping().isNestedTableMapping()) {
            if (!this.shouldQueryToManyRelationship()) {
                return this;
            }
            normalizer.getStatement().dontUseDistinct();
        }
        if ((mappingExpression = this.mappingCriteria()) != null) {
            mappingExpression = mappingExpression.normalize(normalizer);
        }
        if (mappingExpression != null) {
            if (this.shouldUseOuterJoin() && this.getSession().getPlatform().isInformixOuterJoin()) {
                normalizer.getStatement().getOuterJoinExpressions().addElement(this);
                normalizer.getStatement().getOuterJoinedMappingCriteria().addElement(mappingExpression);
                normalizer.addAdditionalExpression(mappingExpression.and(this.additionalExpressionCriteria()));
                return this;
            }
            if ((this.shouldUseOuterJoin() || this.isUsingOuterJoinForMultitableInheritance()) && !this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause()) {
                if (this.shouldUseOuterJoin()) {
                    normalizer.getStatement().getOuterJoinExpressions().addElement(this);
                    normalizer.getStatement().getOuterJoinedMappingCriteria().addElement(mappingExpression);
                    normalizer.getStatement().getOuterJoinedAdditionalJoinCriteria().addElement(this.additionalExpressionCriteriaMap());
                    normalizer.getStatement().getDescriptorsForMultitableInheritanceOnly().add(null);
                    return this;
                }
                if (this.isUsingOuterJoinForMultitableInheritance()) {
                    normalizer.getStatement().getOuterJoinExpressions().addElement(null);
                    normalizer.getStatement().getOuterJoinedMappingCriteria().addElement(null);
                    normalizer.getStatement().getOuterJoinedAdditionalJoinCriteria().addElement(this.additionalExpressionCriteriaMap());
                    normalizer.getStatement().getDescriptorsForMultitableInheritanceOnly().add(this.getMapping().getReferenceDescriptor());
                }
            }
            if (foreignKeyJoinPointer != null) {
                foreignKeyJoinPointer.add(mappingExpression);
            } else {
                normalizer.addAdditionalExpression(mappingExpression.and(this.additionalExpressionCriteria()));
            }
        }
        return this;
    }

    public void printSQL(ExpressionSQLPrinter printer) {
        if (this.isAttribute()) {
            printer.printField(this.getAliasedField());
        }
        if (this.getMapping() != null && this.getMapping().isDirectCollectionMapping()) {
            DirectCollectionMapping directCollectionMapping = (DirectCollectionMapping)this.getMapping();
            TableExpression table = (TableExpression)this.getTable(directCollectionMapping.getReferenceTable());
            DatabaseTable aliasedTable = table.aliasForTable(table.getTable());
            DatabaseField aliasedField = (DatabaseField)directCollectionMapping.getDirectField().clone();
            aliasedField.setTable(aliasedTable);
            printer.printField(aliasedField);
        }
    }

    public void printJava(ExpressionJavaPrinter printer) {
        this.getBaseExpression().printJava(printer);
        if (!this.shouldUseOuterJoin()) {
            if (!this.shouldQueryToManyRelationship()) {
                printer.printString(".get(");
            } else {
                printer.printString(".anyOf(");
            }
        } else if (!this.shouldQueryToManyRelationship()) {
            printer.printString(".getAllowingNull(");
        } else {
            printer.printString(".anyOfAllowingNone(");
        }
        printer.printString("\"" + this.getName() + "\")");
    }

    public Expression rebuildOn(Expression newBase) {
        Expression newLocalBase = this.getBaseExpression().rebuildOn(newBase);
        QueryKeyExpression result = null;
        result = this.shouldUseOuterJoin ? (QueryKeyExpression)newLocalBase.getAllowingNull(this.getName()) : (QueryKeyExpression)newLocalBase.get(this.getName());
        if (this.shouldQueryToManyRelationship) {
            result.doQueryToManyRelationship();
        }
        return result;
    }

    public Expression rebuildOn(Expression oldBase, Expression newBase) {
        if (this == oldBase) {
            return newBase;
        }
        Expression newLocalBase = ((QueryKeyExpression)this.getBaseExpression()).rebuildOn(oldBase, newBase);
        QueryKeyExpression result = null;
        result = this.shouldUseOuterJoin ? (QueryKeyExpression)newLocalBase.getAllowingNull(this.getName()) : (QueryKeyExpression)newLocalBase.get(this.getName());
        if (this.shouldQueryToManyRelationship) {
            result.doQueryToManyRelationship();
        }
        result.setSelectIfOrderedBy(this.selectIfOrderedBy());
        return result;
    }

    protected void resetCache() {
        this.hasMapping = true;
        this.mapping = null;
        this.hasQueryKey = true;
        this.queryKey = null;
    }

    public boolean shouldQueryToManyRelationship() {
        return this.shouldQueryToManyRelationship;
    }

    public Expression twistedForBaseAndContext(Expression newBase, Expression context) {
        Expression twistedBase = this.getBaseExpression().twistedForBaseAndContext(newBase, context);
        QueryKeyExpression result = (QueryKeyExpression)twistedBase.get(this.getName());
        if (this.shouldUseOuterJoin) {
            result.doUseOuterJoin();
        }
        if (this.shouldQueryToManyRelationship) {
            result.doQueryToManyRelationship();
        }
        return result;
    }

    public void validateNode() {
        if (this.getQueryKeyOrNull() == null && this.getMapping() == null) {
            throw QueryException.invalidQueryKeyInExpression(this.getName());
        }
        QueryKey queryKey = this.getQueryKeyOrNull();
        DatabaseMapping mapping = this.getMapping();
        Cloneable theOneThatsNotNull = null;
        if (queryKey != null) {
            theOneThatsNotNull = queryKey;
        }
        if (mapping != null) {
            theOneThatsNotNull = mapping;
        }
        boolean qkIsToMany = false;
        if (queryKey != null) {
            boolean bl = qkIsToMany = queryKey.isManyToManyQueryKey() || queryKey.isOneToManyQueryKey();
        }
        if (mapping != null) {
            if (!(!this.shouldUseOuterJoin || mapping.isOneToOneMapping() || mapping.isOneToManyMapping() || mapping.isManyToManyMapping() || mapping.isAggregateCollectionMapping() || mapping.isDirectCollectionMapping())) {
                throw QueryException.outerJoinIsOnlyValidForOneToOneMappings(this.getMapping());
            }
            qkIsToMany = mapping.isCollectionMapping();
        }
        if (!this.shouldQueryToManyRelationship() && qkIsToMany && !mapping.isNestedTableMapping()) {
            throw QueryException.invalidUseOfToManyQueryKeyInExpression(theOneThatsNotNull);
        }
        if (this.shouldQueryToManyRelationship() && !qkIsToMany) {
            throw QueryException.invalidUseOfAnyOfInExpression(theOneThatsNotNull);
        }
    }

    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, InMemoryQueryIndirectionPolicy valueHolderPolicy, boolean isObjectUnregistered) {
        if (this.getBuilder() != this.getBaseExpression() && this.getBaseExpression().isQueryKeyExpression()) {
            object = this.getBaseExpression().valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
            if (object == null) {
                return null;
            }
            if (object instanceof Vector) {
                Vector<Object> comparisonVector = new Vector<Object>(((Vector)object).size() + 2);
                Enumeration valuesToIterate = ((Vector)object).elements();
                while (valuesToIterate.hasMoreElements()) {
                    Object vectorObject = valuesToIterate.nextElement();
                    if (vectorObject == null) {
                        comparisonVector.addElement(vectorObject);
                        continue;
                    }
                    Object valueOrValues = this.valuesFromCollection(vectorObject, session, valueHolderPolicy, isObjectUnregistered);
                    if (valueOrValues instanceof Vector) {
                        Enumeration nestedValuesToIterate = ((Vector)valueOrValues).elements();
                        while (nestedValuesToIterate.hasMoreElements()) {
                            comparisonVector.addElement(nestedValuesToIterate.nextElement());
                        }
                        continue;
                    }
                    comparisonVector.addElement(valueOrValues);
                }
                return comparisonVector;
            }
        }
        return this.valuesFromCollection(object, session, valueHolderPolicy, isObjectUnregistered);
    }

    public Object valuesFromCollection(Object object, AbstractSession session, InMemoryQueryIndirectionPolicy valueHolderPolicy, boolean isObjectUnregistered) {
        FetchGroupManager fetchGroupMgr;
        DatabaseMapping mapping;
        boolean readMappingFromQueryKey = false;
        if (this.getMapping() == null) {
            this.getMappingFromQueryKey();
            readMappingFromQueryKey = true;
        }
        if ((mapping = this.mapping).getDescriptor().hasInheritance() && mapping.getDescriptor().getJavaClass() != object.getClass()) {
            mapping = session.getDescriptor(object.getClass()).getObjectBuilder().getMappingForAttributeName(this.getName());
        }
        if (mapping.getDescriptor().hasFetchGroupManager() && (fetchGroupMgr = mapping.getDescriptor().getFetchGroupManager()).isPartialObject(object) && !fetchGroupMgr.isAttributeFetched(object, mapping.getAttributeName())) {
            throw QueryException.cannotConformUnfetchedAttribute(mapping.getAttributeName());
        }
        if (mapping.isForeignReferenceMapping()) {
            Object clone;
            UnitOfWorkImpl uow;
            Object valueFromMapping = mapping.getAttributeValueFromObject(object);
            if (!((ForeignReferenceMapping)mapping).getIndirectionPolicy().objectIsInstantiated(valueFromMapping) && !valueHolderPolicy.shouldTriggerIndirection()) {
                throw QueryException.mustInstantiateValueholders();
            }
            Object valueToIterate = mapping.getRealAttributeValueFromObject(object, session);
            UnitOfWorkImpl unitOfWorkImpl = uow = isObjectUnregistered ? (UnitOfWorkImpl)session : null;
            if (mapping.isCollectionMapping() && valueToIterate != null) {
                valueToIterate = mapping.getContainerPolicy().vectorFor(valueToIterate, session);
                if (isObjectUnregistered && uow.getCloneMapping().get(object) == null) {
                    Vector objectValues = (Vector)valueToIterate;
                    for (int i = 0; i < objectValues.size(); ++i) {
                        Object original = objectValues.elementAt(i);
                        Object clone2 = uow.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(original);
                        if (clone2 == null) continue;
                        objectValues.setElementAt(clone2, i);
                    }
                }
            } else if (isObjectUnregistered && uow.getCloneMapping().get(object) == null && (clone = uow.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(valueToIterate)) != null) {
                valueToIterate = clone;
            }
            return valueToIterate;
        }
        if (mapping.isDirectToFieldMapping()) {
            return ((AbstractDirectMapping)mapping).valueFromObject(object, mapping.getField(), session);
        }
        if (mapping.isAggregateMapping()) {
            Object aggregateValue = ((AggregateMapping)mapping).getAttributeValueFromObject(object);
            while (readMappingFromQueryKey && mapping.isAggregateObjectMapping() && !((AggregateObjectMapping)mapping).getReferenceClass().equals(this.queryKey.getDescriptor().getJavaClass())) {
                mapping = mapping.getReferenceDescriptor().getObjectBuilder().getMappingForField(((DirectQueryKey)this.queryKey).getField());
                aggregateValue = mapping.getRealAttributeValueFromObject(aggregateValue, session);
            }
            return aggregateValue;
        }
        throw QueryException.cannotConformExpression();
    }

    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(this.getName());
        writer.write(this.tableAliasesDescription());
    }

    public boolean isNormalizationRequired() {
        return this.shouldQueryToManyRelationship() || this.getMapping() == null || (this.shouldUseOuterJoin() || this.isUsingOuterJoinForMultitableInheritance()) && !this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause() || this.shouldUseOuterJoin() && this.getSession().getPlatform().isInformixOuterJoin();
    }
}

