/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util;

import javax.swing.SwingUtilities;

public class PriorityMutex {
    private Thread lockThread;
    private int lockDepth;
    private Thread waitingPriorityThread;

    public synchronized void lock() {
        Thread thread = Thread.currentThread();
        if (thread != this.lockThread) {
            while (this.lockThread != null || this.waitingPriorityThread != null && this.waitingPriorityThread != thread) {
                try {
                    if (this.waitingPriorityThread == null && this.isPriorityThread()) {
                        this.waitingPriorityThread = thread;
                    }
                    this.wait();
                }
                catch (InterruptedException e) {
                    this.waitingPriorityThread = null;
                }
            }
            this.lockThread = thread;
            if (thread == this.waitingPriorityThread) {
                this.waitingPriorityThread = null;
            }
        }
        ++this.lockDepth;
    }

    public synchronized void unlock() {
        if (Thread.currentThread() != this.lockThread) {
            throw new IllegalStateException("Not locker");
        }
        if (--this.lockDepth == 0) {
            this.lockThread = null;
            this.notifyAll();
        }
    }

    public boolean isPriorityThreadWaiting() {
        return this.waitingPriorityThread != null;
    }

    public final synchronized Thread getLockThread() {
        return this.lockThread;
    }

    protected boolean isPriorityThread() {
        return SwingUtilities.isEventDispatchThread();
    }
}

