/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.debug.callstackviewfilterring;

import com.sun.jdi.AbsentInformationException;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class CallStackFilter
implements TreeModelFilter,
NodeModel,
TableModelFilter {
    private ContextProvider lookupProvider;
    private JPDADebugger debugger;
    private SourcePathProvider contextProvider;

    public CallStackFilter(ContextProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
    }

    private static String convertSlash(String original) {
        return original.replace(File.separatorChar, '/');
    }

    private static String convertClassNameToRelativePath(String className) {
        int i = className.indexOf(36);
        if (i > 0) {
            className = className.substring(0, i);
        }
        String sourceName = className.replace('.', '/') + ".java";
        return sourceName;
    }

    private SourcePathProvider getSourcePathProvider() {
        if (this.contextProvider == null) {
            List l = this.lookupProvider.lookup(null, SourcePathProvider.class);
            this.contextProvider = (SourcePathProvider)l.get(0);
            int k = l.size();
            for (int i = 1; i < k; ++i) {
                this.contextProvider = new CompoundSourcePathProvider((SourcePathProvider)l.get(i), this.contextProvider);
            }
        }
        return this.contextProvider;
    }

    String getURL(String relativePath) {
        return this.getSourcePathProvider().getURL(relativePath, false);
    }

    boolean isOnSourcePath(CallStackFrame csf) {
        String url = null;
        try {
            url = this.getURL(CallStackFilter.convertSlash(csf.getSourcePath(null)));
        }
        catch (AbsentInformationException e) {
            url = this.getURL(CallStackFilter.convertClassNameToRelativePath(csf.getClassName()));
        }
        return url != null;
    }

    public Object getRoot(TreeModel original) {
        return original.getRoot();
    }

    public int getChildrenCount(TreeModel original, Object node) throws UnknownTypeException {
        if (node.equals(original.getRoot())) {
            Object[] originalCh = original.getChildren(node, 0, original.getChildrenCount(node));
            int k = originalCh.length;
            int j = 0;
            boolean in = false;
            for (int i = 0; i < k; ++i) {
                if (!(originalCh[i] instanceof CallStackFrame)) {
                    ++j;
                    continue;
                }
                CallStackFrame f = (CallStackFrame)originalCh[i];
                if (!this.isOnSourcePath(f)) {
                    if (in) continue;
                    ++j;
                    in = true;
                    continue;
                }
                in = false;
                ++j;
            }
            return j;
        }
        if (node instanceof HiddenFrames) {
            return ((HiddenFrames)node).getStack().size();
        }
        return original.getChildrenCount(node);
    }

    public Object[] getChildren(TreeModel original, Object parent, int from, int to) throws UnknownTypeException {
        if (parent.equals(original.getRoot())) {
            Object[] originalCh = original.getChildren(parent, 0, original.getChildrenCount(parent));
            int k = originalCh.length;
            ArrayList<Object> newCh = new ArrayList<Object>();
            HiddenFrames hiddenFrames = null;
            for (int i = 0; i < k; ++i) {
                if (!(originalCh[i] instanceof CallStackFrame)) {
                    newCh.add(originalCh[i]);
                    continue;
                }
                CallStackFrame f = (CallStackFrame)originalCh[i];
                if (!this.isOnSourcePath(f)) {
                    if (hiddenFrames == null) {
                        hiddenFrames = new HiddenFrames();
                        newCh.add(hiddenFrames);
                    }
                    hiddenFrames.addFrame(f);
                    continue;
                }
                hiddenFrames = null;
                newCh.add(f);
            }
            int lto = Math.min(newCh.size(), to);
            return newCh.subList(from, lto).toArray();
        }
        if (parent instanceof HiddenFrames) {
            return ((HiddenFrames)parent).getStack().toArray();
        }
        return original.getChildren(parent, from, to);
    }

    public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
        if (node instanceof HiddenFrames) {
            return false;
        }
        return original.isLeaf(node);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof HiddenFrames) {
            return NbBundle.getMessage((Class)CallStackFilter.class, (String)"LBL_HIDDEN_FRAMES");
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof HiddenFrames) {
            return NbBundle.getMessage((Class)CallStackFilter.class, (String)"RES_FRAME_GROUP");
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof HiddenFrames) {
            return NbBundle.getMessage((Class)CallStackFilter.class, (String)"TLT_HIDDEN_FRAMES");
        }
        throw new UnknownTypeException(node);
    }

    public void setValueAt(TableModel original, Object node, String columnID, Object value) throws UnknownTypeException {
        original.setValueAt(node, columnID, value);
    }

    public boolean isReadOnly(TableModel original, Object node, String columnID) throws UnknownTypeException {
        if (node instanceof HiddenFrames) {
            return true;
        }
        return original.isReadOnly(node, columnID);
    }

    public Object getValueAt(TableModel original, Object node, String columnID) throws UnknownTypeException {
        if (node instanceof HiddenFrames) {
            return "";
        }
        return original.getValueAt(node, columnID);
    }

    private static class CompoundSourcePathProvider
    extends SourcePathProvider {
        private SourcePathProvider cp1;
        private SourcePathProvider cp2;

        CompoundSourcePathProvider(SourcePathProvider cp1, SourcePathProvider cp2) {
            this.cp1 = cp1;
            this.cp2 = cp2;
        }

        public String getURL(String relativePath, boolean global) {
            String p1 = this.cp1.getURL(relativePath, global);
            if (p1 != null) {
                return p1;
            }
            return this.cp2.getURL(relativePath, global);
        }

        public String getRelativePath(String url, char directorySeparator, boolean includeExtension) {
            String p1 = this.cp1.getRelativePath(url, directorySeparator, includeExtension);
            if (p1 != null) {
                return p1;
            }
            return this.cp2.getRelativePath(url, directorySeparator, includeExtension);
        }

        public String[] getSourceRoots() {
            String[] fs1 = this.cp1.getSourceRoots();
            String[] fs2 = this.cp2.getSourceRoots();
            String[] fs = new String[fs1.length + fs2.length];
            System.arraycopy(fs1, 0, fs, 0, fs1.length);
            System.arraycopy(fs2, 0, fs, fs1.length, fs2.length);
            return fs;
        }

        public String[] getOriginalSourceRoots() {
            String[] fs1 = this.cp1.getOriginalSourceRoots();
            String[] fs2 = this.cp2.getOriginalSourceRoots();
            String[] fs = new String[fs1.length + fs2.length];
            System.arraycopy(fs1, 0, fs, 0, fs1.length);
            System.arraycopy(fs2, 0, fs, fs1.length, fs2.length);
            return fs;
        }

        public void setSourceRoots(String[] sourceRoots) {
            this.cp1.setSourceRoots(sourceRoots);
            this.cp2.setSourceRoots(sourceRoots);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.cp1.addPropertyChangeListener(l);
            this.cp2.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.cp1.removePropertyChangeListener(l);
            this.cp2.removePropertyChangeListener(l);
        }
    }

    public static class HiddenFrames {
        private List frames = new ArrayList();

        void addFrame(CallStackFrame frame) {
            this.frames.add(frame);
        }

        List getStack() {
            return this.frames;
        }

        public boolean equals(Object o) {
            if (!(o instanceof HiddenFrames)) {
                return false;
            }
            if (this.frames.size() != ((HiddenFrames)o).frames.size()) {
                return false;
            }
            if (this.frames.size() == 0) {
                return o == this;
            }
            return this.frames.get(0).equals(((HiddenFrames)o).frames.get(0));
        }

        public int hashCode() {
            if (this.frames.size() == 0) {
                return super.hashCode();
            }
            return this.frames.get(0).hashCode();
        }
    }
}

