/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.modules.welcome.content.BundleSupport;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.ContentPanel;
import org.netbeans.modules.welcome.content.LinkButton;
import org.netbeans.modules.welcome.content.SampleProjectLink;
import org.netbeans.modules.welcome.content.Utils;
import org.netbeans.modules.welcome.ui.RelativeSizeScrollPane;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;

public class Samples
extends ContentPanel
implements Constants {
    protected int row = 0;

    public Samples() {
        super(BundleSupport.getLabel("Samples"));
        this.setOpaque(true);
        this.setBackground(Utils.getColor("DefaultBackgroundColor"));
        this.setContent(this.buildContent());
        NewProjectButton button = new NewProjectButton();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        panel.add((Component)button, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 16, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setBottomContent(panel);
    }

    private JComponent buildContent() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        this.createLinks(panel);
        panel.add((Component)new JLabel(), new GridBagConstraints(0, this.row++, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        RelativeSizeScrollPane scroll = new RelativeSizeScrollPane(panel, 0.3f, 30);
        scroll.getViewport().setOpaque(false);
        scroll.setOpaque(false);
        scroll.setHorizontalScrollBarPolicy(31);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        return scroll;
    }

    protected void addLink(JPanel panel, String category, String title) {
        SampleProjectLink link = new SampleProjectLink(category, null, title);
        link.setForeground(Utils.getColor("HeaderTextColor"));
        panel.add((Component)link, new GridBagConstraints(0, this.row++, 1, 1, 1.0, 0.0, 18, 0, new Insets(this.row == 1 ? 5 : 0, 13, 0, 5 + UIManager.getInt("ScrollBar.width")), 0, 0));
    }

    protected void createLinks(JPanel panel) {
        FileObject root = Repository.getDefault().getDefaultFileSystem().findResource("Templates/Project/Samples");
        DataFolder df = DataFolder.findFolder((FileObject)root);
        DataObject[] children = df.getChildren();
        for (int i = 0; i < children.length; ++i) {
            try {
                this.createLinkForCategory(panel, children[i]);
                continue;
            }
            catch (DataObjectNotFoundException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void createLinkForCategory(JPanel panel, DataObject categoryDO) throws DataObjectNotFoundException {
        if (categoryDO instanceof DataShadow) {
            categoryDO = ((DataShadow)categoryDO).getOriginal();
        }
        String category = null;
        FileObject origFile = categoryDO.getPrimaryFile();
        DataFolder df = DataFolder.findFolder((FileObject)origFile);
        if (null != df) {
            DataObject[] categoryChildren = df.getChildren();
            boolean hasSubFoldersOnly = true;
            for (int i = 0; i < categoryChildren.length; ++i) {
                if (categoryChildren[i].getPrimaryFile().isFolder()) continue;
                hasSubFoldersOnly = false;
                break;
            }
            if (hasSubFoldersOnly && categoryChildren.length > 0) {
                origFile = categoryChildren[0].getPrimaryFile();
            }
        }
        category = origFile.getPath();
        category = category.replaceFirst("Templates/Project/", "");
        String label = categoryDO.getNodeDelegate().getDisplayName();
        this.addLink(panel, category, label);
    }

    private static class NewProjectButton
    extends LinkButton {
        public NewProjectButton() {
            super(BundleSupport.getLabel("NewProject"), false);
            this.setFont(HEADER_FONT);
        }

        public void actionPerformed(ActionEvent e) {
            Action a = Utils.findAction("Actions/Project/org-netbeans-modules-project-ui-NewProject.instance");
            if (null != a) {
                a.actionPerformed(e);
            }
        }
    }
}

